'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /usr/cvs/NEOSOFT/inet_workstation/tcl7.3/tcl7.3/doc/split.n,v 2.0 1994/12/23 20:12:34 karl Exp $ SPRITE (Berkeley)
'\" 
.so man.macros
.HS split tcl
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
split \- Split a string into a proper Tcl list
.SH SYNOPSIS
\fBsplit \fIstring \fR?\fIsplitChars\fR?
.BE

.SH DESCRIPTION
.PP
Returns a list created by splitting \fIstring\fR at each character
that is in the \fIsplitChars\fR argument.
Each element of the result list will consist of the
characters from \fIstring\fR that lie between instances of the
characters in \fIsplitChars\fR.
Empty list elements will be generated if \fIstring\fR contains
adjacent characters in \fIsplitChars\fR, or if the first or last
character of \fIstring\fR is in \fIsplitChars\fR.
If \fIsplitChars\fR is an empty string then each character of
\fIstring\fR becomes a separate element of the result list.
\fISplitChars\fR defaults to the standard white-space characters.
For example,
.DS
\fBsplit "comp.unix.misc" .\fR
.DE
returns \fB"comp unix misc"\fR and
.DS
\fBsplit "Hello world" {}\fR
.DE
returns \fB"H e l l o { } w o r l d"\fR.

.SH KEYWORDS
list, split, string
