'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /usr/cvs/NEOSOFT/inet_workstation/tcl7.3/tk3.6/doc/after.n,v 2.0 1994/12/23 20:37:32 karl Exp $ SPRITE (Berkeley)
'\" 
.so man.macros
.HS after tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
after \- Execute a command after a time delay
.SH SYNOPSIS
\fBafter \fIms \fR?\fIarg1 arg2 arg3 ...\fR?
.BE

.SH DESCRIPTION
.PP
This command is used to delay execution of the program or to execute
a command in background after a delay.  The \fIms\fR argument gives
a time in milliseconds.
If \fIms\fR is the only argument to \fBafter\fR
then the command sleeps for \fIms\fR milliseconds and returns.
.VS
While the command is sleeping the application does not respond to
X events and other events.
.VE
.PP
If additional arguments are
present after \fIms\fR, then a Tcl command is formed by concatenating
all the additional arguments in the same fashion as the \fBconcat\fR
command.  \fBAfter\fR returns immediately but arranges for the command
to be executed \fIms\fR milliseconds later in background.
.VS
The command will be executed at global level (outside the context
of any Tcl procedure).
.VE
If an error occurs while executing the delayed command then the
\fBtkerror\fR mechanism is used to report the error.
.PP
The \fBafter\fR command always returns an empty string.

.SH "SEE ALSO"
tkerror

.SH KEYWORDS
delay, sleep, time
