'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /usr/cvs/NEOSOFT/inet_workstation/tcl7.3/tk3.6/doc/checkbutton.n,v 2.0 1994/12/23 20:37:38 karl Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS checkbutton tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
checkbutton \- Create and manipulate check-button widgets
.SH SYNOPSIS
\fBcheckbutton\fI pathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.VS
\fBactiveBackground\fR	\fBbitmap\fR	\fBfont\fR	\fBpadY\fR
\fBactiveForeground\fR	\fBborderWidth\fR	\fBforeground\fR	\fBrelief\fR
\fBanchor\fR	\fBcursor\fR	\fBmask\fR	\fBtext\fR
\fBbackground\fR	\fBdisabledForeground\fR	\fBpadX\fR	\fBtextVariable\fR
.VE
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
.nf
Name:	\fBcommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB\-command\fR
.fi
.IP
Specifies a Tcl command to associate with the button.  This command
is typically invoked when mouse button 1 is released over the button
window.  The button's global variable (\fB\-variable\fR option) will
be updated before the command is invoked.
.LP
.nf
.VS
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB\-height\fR
.fi
.IP
Specifies a desired height for the button.
If a bitmap is being displayed in the button then the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in lines of text.
If this option isn't specified, the button's desired height is computed
from the size of the bitmap or text being displayed in it.
.VE
.LP
.nf
Name:	\fBoffValue\fR
Class:	\fBValue\fR
Command-Line Switch:	\fB\-offvalue\fR
.fi
.IP
Specifies value to store in the button's associated variable whenever
this button is deselected.  Defaults to ``0''.
.LP
.nf
Name:	\fBonValue\fR
Class:	\fBValue\fR
Command-Line Switch:	\fB\-onvalue\fR
.fi
.IP
Specifies value to store in the button's associated variable whenever
this button is selected.  Defaults to ``1''.
.LP
.nf
Name:	\fBselector\fR
Class:	\fBForeground\fR
Command-Line Switch:	\fB\-selector\fR
.fi
.IP
Specifies the color to draw in the selector when this button is
selected.
.VS
If specified as an empty string then no selector is
drawn for the button.
.LP
.nf
Name:	\fBstate\fR
Class:	\fBState\fR
Command-Line Switch:	\fB\-state\fR
.fi
.IP
Specifies one of three states for the check button:  \fBnormal\fR, \fBactive\fR,
or \fBdisabled\fR.  In normal state the check button is displayed using the
\fBforeground\fR and \fBbackground\fR options.  The active state is
typically used when the pointer is over the check button.  In active state
the check button is displayed using the \fBactiveForeground\fR and
\fBactiveBackground\fR options.  Disabled state means that the check button
is insensitive:  it doesn't activate and doesn't respond to mouse
button presses.  In this state the \fBdisabledForeground\fR and
\fBbackground\fR options determine how the check button is displayed.
.VE
.LP
.nf
Name:	\fBvariable\fR
Class:	\fBVariable\fR
Command-Line Switch:	\fB\-variable\fR
.fi
.IP
Specifies name of global variable to set to indicate whether
or not this button is selected.  Defaults to the name of the
button within its parent (i.e. the last element of the button
window's path name).
.LP
.nf
.VS
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB\-width\fR
.fi
.IP
Specifies a desired width for the button.
If a bitmap is being displayed in the button then the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in characters.
If this option isn't specified, the button's desired width is computed
from the size of the bitmap or text being displayed in it.
.VE
.BE

.SH DESCRIPTION
.PP
The \fBcheckbutton\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a check-button widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the check button such as its colors, font,
text, and initial relief.  The \fBcheckbutton\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A check button is a widget
.VS
that displays a textual string or bitmap
and a square called a \fIselector\fR.
A check button has
all of the behavior of a simple button, including the
following: it can display itself in either of three different
ways, according to the \fBstate\fR option;
.VE
it can be made to appear
raised, sunken, or flat; it can be made to flash; and it invokes
a Tcl command whenever mouse button 1 is clicked over the
check button.
.PP
In addition, check buttons can be \fIselected\fR.  If a check button is
selected then a special highlight appears in the selector, and
a Tcl variable associated with the check button is set to a particular
value (normally 1).  If the check button is not selected, then
the selector is drawn in a different fashion and the associated
variable is set to a different value (typically 0).  By default,
the name of the variable associated with a check button is the
same as the \fIname\fR used to create the check button.  The
variable name, and the ``on'' and ``off'' values stored in it,
may be modified with options on the command line or in the option
database.  By default a check button is configured to select and deselect
itself on alternate button clicks.
.VS
In addition, each check button monitors its associated variable and
automatically selects and deselects itself when the variables value
changes to and from the button's ``on'' value.
.VE

.SH "WIDGET COMMAND"
.PP
The \fBcheckbutton\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for check button widgets:
.TP
\fIpathName \fBactivate\fR
Change the check button's state to \fBactive\fR and redisplay the button
using its active foreground and background colors instead of normal
colors.
.VS
This command is ignored if the check button's state is \fBdisabled\fR.
This command is obsolete and will eventually be removed;
use ``\fIpathName \fBconfigure \-state active\fR'' instead.
.VE
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBcheckbutton\fR
command.
.TP
\fIpathName \fBdeactivate\fR
Change the check button's state to \fBnormal\fR and redisplay the button
using its normal foreground and background colors.
.VS
This command is ignored if the check button's state is \fBdisabled\fR.
This command is obsolete and will eventually be removed;
use ``\fIpathName \fBconfigure \-state normal\fR'' instead.
.VE
.TP
\fIpathName \fBdeselect\fR
Deselect the check button:  redisplay it without a highlight in
the selector and set the associated variable to its ``off''
value.
.TP
\fIpathName \fBflash\fR
Flash the check button.  This is accomplished by redisplaying the check button
several times, alternating between active and normal colors.  At
the end of the flash the check button is left in the same normal/active
state as when the command was invoked.
.VS
This command is ignored if the check button's state is \fBdisabled\fR.
.VE
.TP
\fIpathName \fBinvoke\fR
.VS
Does just what would have happened if the user invoked the check button
with the mouse: toggle the selection state of the button and invoke
the Tcl command associated with the check button, if there is one.
The return value is the return value from the Tcl command, or an
empty string if there is no command associated with the check button.
This command is ignored if the check button's state is \fBdisabled\fR.
.VE
.TP
\fIpathName \fBselect\fR
Select the check button:  display it with a highlighted
selector and set the associated variable to its ``on''
value.
.TP
\fIpathName \fBtoggle\fR
Toggle the selection state of the button, redisplaying it and
modifying its associated variable to reflect the new state.

.SH BINDINGS
.PP
.VS
Tk automatically creates class bindings for check buttons that give them
the following default behavior:
.IP [1]
The check button activates whenever the mouse passes over it and deactivates
whenever the mouse leaves the check button.
.IP [2]
The check button's relief is changed to sunken whenever mouse button 1 is
pressed over it, and the relief is restored to its original
value when button 1 is later released.
.IP [3]
If mouse button 1 is pressed over the check button and later released over
the check button, the check button is invoked (i.e. its selection
state toggles and the command associated with the button is invoked,
if there is one).  However, if the mouse is not
over the check button when button 1 is released, then no invocation occurs.
.PP
If the check button's state is \fBdisabled\fR then none of the above
actions occur:  the check button is completely non-responsive.
.PP
The behavior of check buttons can be changed by defining new bindings for
individual widgets or by redefining the class bindings.
.VE

.SH KEYWORDS
check button, widget
