'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /usr/cvs/NEOSOFT/inet_workstation/tcl7.3/tk3.6/doc/label.n,v 2.0 1994/12/23 20:37:51 karl Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS label tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
label \- Create and manipulate label widgets
.SH SYNOPSIS
\fBlabel\fI \fIpathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.VS
\fBanchor	\fBborderWidth\fR	\fBforeground\fR	\fBrelief\fR
\fBbackground\fR	\fBcursor\fR	\fBpadX\fR	\fBtext\fR
\fBbitmap\fR	\fBfont\fR	\fBpadY\fR	\fBtextVariable\fR
.VE
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
.VS
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB\-height\fR
.fi
.IP
Specifies a desired height for the label.
If a bitmap is being displayed in the label then the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in lines of text.
If this option isn't specified, the label's desired height is computed
from the size of the bitmap or text being displayed in it.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB\-width\fR
.fi
.IP
Specifies a desired width for the label.
If a bitmap is being displayed in the label then the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in characters.
If this option isn't specified, the label's desired width is computed
from the size of the bitmap or text being displayed in it.
.VE
.BE

.SH DESCRIPTION
.PP
The \fBlabel\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a label widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the label such as its colors, font,
text, and initial relief.  The \fBlabel\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A label is a widget
.VS
that displays a textual string or bitmap.
.VE
The label can be manipulated in a few simple ways, such as
changing its relief or text, using the commands described below.

.SH "WIDGET COMMAND"
.PP
The \fBlabel\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for label widgets:
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBlabel\fR
command.

.SH BINDINGS
.PP
When a new label is created, it has no default event bindings:
labels are not intended to be interactive.

.SH KEYWORDS
label, widget
