'\"
'\" Copyright (c) 1990-1992 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /usr/cvs/NEOSOFT/inet_workstation/tcl7.3/tk3.6/doc/menubutton.n,v 2.0 1994/12/23 20:38:02 karl Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS menubutton tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
menubutton \- Create and manipulate menubutton widgets
.SH SYNOPSIS
\fBmenubutton\fI \fIpathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.VS
.ta 4c 8c 12c
\fBactiveBackground\fR	\fBborderwidth\fR	\fBmask\fR	\fBtextVariable\fR
\fBactiveForeground\fR	\fBcursor\fR	\fBpadX\fR	\fBunderline\fR
\fBanchor\fR	\fBdisabledForeground\fR	\fBpadY\fR
\fBbackground\fR	\fBfont\fR	\fBrelief\fR
\fBbitmap\fR	\fBforeground\fR	\fBtext\fR
.VE
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
.nf
.VS
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB\-height\fR
.fi
.IP
Specifies a desired height for the menu button.
If a bitmap is being displayed in the menu button then the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in lines of text.
If this option isn't specified, the menu button's desired height is computed
from the size of the bitmap or text being displayed in it.
.VE
.LP
.nf
Name:	\fBmenu\fR
Class:	\fBMenuName\fR
Command-Line Switch:	\fB\-menu\fR
.fi
.IP
Specifies the path name of the menu associated with this menubutton.
.VS
The menu must be a descendant of the menubutton in order for normal pull-down
operation to work via the mouse.
.VE
.LP
.nf
Name:	\fBstate\fR
Class:	\fBState\fR
Command-Line Switch:	\fB\-state\fR
.fi
.IP
Specifies one of three states for the menu button:  \fBnormal\fR, \fBactive\fR,
or \fBdisabled\fR.  In normal state the menu button is displayed using the
\fBforeground\fR and \fBbackground\fR options.  The active state is
typically used when the pointer is over the menu button.  In active state
the menu button is displayed using the \fBactiveForeground\fR and
\fBactiveBackground\fR options.  Disabled state means that the menu button
is insensitive:  it doesn't activate and doesn't respond to mouse
button presses.  In this state the \fBdisabledForeground\fR and
\fBbackground\fR options determine how the button is displayed.
.LP
.nf
.VS
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB\-width\fR
.fi
.IP
Specifies a desired width for the menu button.
If a bitmap is being displayed in the menu button then the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in characters.
If this option isn't specified, the menu button's desired width is computed
from the size of the bitmap or text being displayed in it.
.VE
.BE

.SH INTRODUCTION
.PP
The \fBmenubutton\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a menubutton widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the menubutton such as its colors, font,
text, and initial relief.  The \fBmenubutton\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A menubutton is a widget that displays a
.VS
textual string or bitmap
.VE
and is associated with a menu widget.  In normal usage, pressing
mouse button 1 over the menubutton causes the associated menu to
be posted just underneath the menubutton.  If the mouse is moved over
the menu before releasing the mouse button, the button release
causes the underlying menu entry to be invoked.  When the button
is released, the menu is unposted.
.PP
.VS
Menubuttons are typically organized into groups called menu bars
that allow scanning:
if the mouse button is pressed over one menubutton (causing it
to post its menu) and the mouse is moved over another menubutton
in the same menu bar without releasing the mouse button, then the
menu of the first menubutton is unposted and the menu of the
new menubutton is posted instead.
The \fBtk_menuBar\fR procedure is used to set up menu bars for
scanning; see that procedure for more details.
.VE

.SH "WIDGET COMMAND"
.PP
The \fBmenubutton\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for menubutton widgets:
.TP
\fIpathName \fBactivate\fR
Change the menu button's state to \fBactive\fR and redisplay the menu
button using its active foreground and background colors instead of normal
colors.
The command returns an empty string.
.VS
This command is ignored if the menu button's state is \fBdisabled\fR.
This command is obsolete and will eventually be removed;
use ``\fIpathName \fBconfigure \-state active\fR'' instead.
.VE
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBmenubutton\fR
command.
.TP
\fIpathName \fBdeactivate\fR
Change the menu button's state to \fBnormal\fR and redisplay the menu
button using its normal foreground and background colors.
The command returns an empty string.
.VS
This command is ignored if the menu button's state is \fBdisabled\fR.
This command is obsolete and will eventually be removed;
use ``\fIpathName \fBconfigure \-state normal\fR'' instead.
.VE

.SH "DEFAULT BINDINGS"
.PP
.VS
Tk automatically creates class bindings for menu buttons that give them
the following default behavior:
.IP [1]
A menu button activates whenever the mouse passes over it and deactivates
whenever the mouse leaves it.
.IP [2]
A menu button's relief is changed to raised whenever mouse button 1 is
pressed over it, and the relief is restored to its original value
when button 1 is later released or the mouse is dragged into another
menu button in the same menu bar.
.IP [3]
When mouse button 1 is pressed over a menu button, or when the mouse
is dragged into a menu button with mouse button 1 pressed, the associated
menu is posted;  the mouse can be dragged across the menu and released
over an entry in the menu to invoke that entry.  The menu is unposted
when button 1 is released outside either the menu or the menu button.
The menu is also unposted when the mouse is dragged into another
menu button in the same menu bar.
.IP [4]
If mouse button 1 is pressed and released within the menu button,
then the menu stays posted and keyboard traversal is possible as
described in the manual entry for \fBtk_menuBar\fR.
.IP [5]
Menubuttons may also be posted by typing characters on the keyboard.
See the manual entry for \fBtk_menuBar\fR for full details on keyboard
menu traversal.
.IP [6]
If mouse button 2 is pressed over a menu button then the associated
menu is posted and also \fItorn off\fR:  it can then be dragged around on
the screen with button 2 and the menu will not automatically unpost when
entries in it are invoked.
To close a torn off menu, click mouse button 1 over the associated
menu button.
.PP
If the menu button's state is \fBdisabled\fR then none of the above
actions occur:  the menu button is completely non-responsive.
.PP
The behavior of menu buttons can be changed by defining new bindings for
individual widgets or by redefining the class bindings.
.VE

.SH KEYWORDS
menubutton, widget
