'\"
'\" Copyright (c) 1993 by Sven Delmas
'\" All rights reserved.
'\" See the file COPYRIGHT for the copyright notes.
'\"
'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /usr/cvs/NEOSOFT/inet_workstation/tcl7.3/tk3.6/doc/pinfo.n,v 2.0 1994/12/23 20:38:11 karl Exp $
'/" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS pinfo cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
pinfo \- manipulate pixmaps
.SH SYNOPSIS
\fBpinfo\fR \fIcommand \fR?\fIarg\fR? \fR?\fIarg\fR?
.BE

.SH DESCRIPTION
.PP
The \fBpinfo\fR command is used to manipulate pixmaps via the
tcl language. It can take any of a number of different forms,
depending on the \fIcommand\fR argument.  The legal forms are:
.VS
.TP
\fBpinfo cache \fIname\fR \fIstatus\fR
If no pixmap \fIname\fR is specified, a list of all
currently cached pixmaps is returned. If a pixmap \fIname\fR
is given, the cache status of this pixmap is returned, and
if a \fIstatus\fR is specified, the pixmap's cache status is
set to this boolean value. Caching means that the pixmap is
not removed when it is no longer used. Instead, it remains in
the Tk hash table for later use. This can reduce loading
time when big pixmaps are often displayed/hidden.
.TP
\fBpinfo cacheconfig option \fIvalue\fR
This command allows the manipulation of the pixmap caching
mechanism. The only option that is allowed is
\fI-defaultstatus\fR. If no new value is specified, the
current default cache status is returned. Otherwise, the
default cache status is set to the given boolean value. This
status indicates which is the default cache status for
loaded pixmaps.
.VE
.TP
\fBpinfo clipmaskdata \fIname\fR
This command returns the clipmask data of the pixmap with
the name \fIname\fR. The format of the returned data is a
list. The first element of the list is a string with three
elements: the width, the height and the depth of the bitmap.
The second element of the list contains the data defining
the bitmap in standard X11 bitmap format. If no pixmap exists
with the name \fIname\fR then an error is returned. If the pixmap has
no clip mask, then "none" is returned.
.TP
\fBpinfo data \fIname\fR \fIformat\fR
This command returns the data of the pixmap with the name
\fIname\fR. The format of the returned data is a list. The
first element of the list is a string with four elements:
the width, the height and the depth of the pixmap. The fourth
element is the format of the pixmap data. A pixmap with a depth of
more than 1 has the depth value 0. The second element of the list
contains the data defining the pixmap. The type of the data can be
specified with the \fIformat\fR option. Currently only \fIbitmap\fR
and \fIxpm3\fR are supported.
.TP
\fBpinfo define \fIname\fR \fIdataList\fR
This command defines a new pixmap with the name \fIname\fR.
The format of the list containing the data for the pixmap
is the same as returned by the command \fIpinfo data\fR. If
the data string is empty (i.e. {{20 30 8 xpm3} {}}), an empty
pixmap is created. The command returns a decimal string giving
the X11 pixmap ID of the newly created pixmap.
.TP
\fBpinfo depth \fIname\fR
Returns a decimal string giving the depth of the pixmap
with the name \fIname\fR.  If no pixmap exists with the name
\fIname\fR, then "0" is returned.
.TP
\fBpinfo formats \fI?specifier?\fR
Returns a list of the supported pixmap formats. If \fIspecifier\fR is
empty all formats are returned. If \fIspecifier\fR is set to \fIall\fR,
all formats that support the complete functionality are returned. The
\fIspecifiers\fR \fIget\fR, \fIput\fR, \fItoascii\fR and \fItopixmap\fR
restrict the returned list to those formats supporting the given
functionality.
.TP
\fBpinfo get \fIname\fR
Returns a decimal string giving the X11 pixmap ID of the pixmap
with the name \fIname\fR.  This command loads a pixmap if the
user has specified a filename to load. If no pixmap exists with
the name \fIname\fR and no pixmap can be loaded, then "none" is
returned.
.TP
\fBpinfo height \fIname\fR
Returns a decimal string giving the height of the pixmap
with the name \fIname\fR.  If no pixmap exists with the name
\fIname\fR then "0" is returned.
.TP
\fBpinfo names
Returns a list of all known pixmap names.
.TP
\fBpinfo save \fIname\fR \fIfileName\fR \fIformat\fR
Saves the given pixmap into the file named \fIfileName\fR. 
The output format, specified with \fIformat\fR, can be
\fIbitmap\fR, \fIxpm3\fR, or annother supported pixmap format.
.TP
\fBpinfo undefine \fIname\fR
Undefines the pixmap with the name \fIname\fR. To undefine means
that it is removed from the name list. The pixmap is not freed.
.TP
\fBpinfo width \fIname\fR
Returns a decimal string giving the width of the pixmap
with the name \fIname\fR.  If no pixmap exists with the name
\fIname\fR, then "0" is returned.

.SH KEYWORDS
pinfo, Xpm3
