'\"
'\" Copyright (c) 1990-1992 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /usr/cvs/NEOSOFT/inet_workstation/tcl7.3/tk3.6/doc/selection.n,v 2.0 1994/12/23 20:38:20 karl Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS selection tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
selection \- Manipulate the X selection
.SH SYNOPSIS
\fBselection \fIoption\fR ?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
This command provides a Tcl interface to the X selection mechanism and
implements the full selection functionality described in the
X Inter-Client Communication Conventions Manual (ICCCM), except that it
supports only the primary selection.
.PP
The first argument to \fBselection\fR determines the format of the
rest of the arguments and the behavior of the command.  The following
forms are currently supported:
.TP
\fBselection clear \fIwindow\fR
.VS
If there is a selection anywhere on \fIwindow\fR's display, clear it
so that no window owns the selection anymore.  Returns an empty string.
.VE
.TP
\fBselection get \fR?\fItype\fR?
Retrieves the value
of the primary selection and returns it as a result.
\fBType\fR specifies the form in which the selection is to be
returned (the desired ``target'' for conversion, in ICCCM
terminology), and should be an
atom name such as STRING or FILE_NAME;  see the Inter-Client
Communication Conventions Manual for complete details.
\fBType\fR defaults to STRING.  The selection owner may choose to
return the selection in any of several different representation
formats, such as STRING, ATOM, INTEGER, etc. (this format is
different than the selection type;  see the ICCCM for all the
confusing details).  If the selection is returned in
a non-string format, such as INTEGER or ATOM, the \fBselection\fR
command converts it to string format as a collection of fields
separated by spaces:  atoms are converted to their
textual names, and anything else is converted to hexadecimal
integers.
.TP
\fBselection handle \fIwindow command \fR?\fItype\fR? ?\fIformat\fR?
Creates a handler for selection requests, such that \fIcommand\fR will
be executed whenever the primary selection is
owned by \fIwindow\fR and someone attempts to retrieve it in the form
given by \fItype\fR (e.g. \fItype\fR is specified in the \fBselection get\fR
command).  \fIType\fR defaults to STRING.
.VS
If \fIcommand\fR is an empty string then any existing handler for
\fIwindow\fR and \fItype\fR is removed.
.VE
.RS
.PP
When the selection is requested and \fIwindow\fR is the selection owner
and \fItype\fR is the requested type, \fIcommand\fR will be executed
as a Tcl command with two additional numbers appended to it
(with space separators).  The two additional numbers
are \fIoffset\fR and \fImaxBytes\fR:  \fIoffset\fR specifies a starting
character position in the selection and \fImaxBytes\fR gives the maximum
number of bytes to retrieve.  The command should return a value consisting
of at most \fImaxBytes\fR of the selection, starting at position
\fIoffset\fR.  For very large selections (larger than \fImaxBytes\fR)
the selection will be retrieved using several invocations of \fIcommand\fR
with increasing \fIoffset\fR values.  If \fIcommand\fR returns a string
whose length is less than \fImaxBytes\fR, the return value is assumed to
include all of the remainder of the selection;  if the length of
\fIcommand\fR's result is equal to \fImaxBytes\fR then
\fIcommand\fR will be invoked again, until it eventually
returns a result shorter than \fImaxBytes\fR.  The value of \fImaxBytes\fR
will always be relatively large (thousands of bytes).
.PP
If \fIcommand\fR returns an error then the selection retrieval is rejected
.VS
just as if the selection didn't exist at all.
.VE
.PP
The \fIformat\fR argument specifies the representation that should be
used to transmit the selection to the requester (the second column of
Table 2 of the ICCCM), and defaults to STRING.  If \fIformat\fR is
STRING, the selection is transmitted as 8-bit ASCII characters (i.e.
just in the form returned by \fIcommand\fR).  If \fIformat\fR is
ATOM, then the return value from \fIcommand\fR is divided into fields
separated by white space;  each field is converted to its atom value,
and the 32-bit atom value is transmitted instead of the atom name.
For any other \fIformat\fR, the return value from \fIcommand\fR is
divided into fields separated by white space and each field is
converted to a 32-bit integer;  an array of integers is transmitted
to the selection requester.
.PP
The \fIformat\fR argument is needed only for compatibility with
selection requesters that don't use Tk.  If the Tk toolkit is being
used to retrieve the selection then the value is converted back to
a string at the requesting end, so \fIformat\fR is
irrelevant.
.RE
.TP
\fBselection own \fR?\fIwindow\fR? ?\fIcommand\fR?
.VS
If \fIwindow\fR is specified, then it becomes the new selection owner
and the command returns an empty string as result.
The existing owner, if any, is notified that it has lost the selection.
If \fIcommand\fR is specified, it is a Tcl script to execute when
some other window claims ownership of the selection away from
\fIwindow\fR.
If neither \fIwindow\fR nor \fIcommand\fR is specified then
the command returns the path name of the window in this application
that owns the selection, or an empty string if no window in this
application owns the selection.
.VE

.SH KEYWORDS
clear, format, handler, ICCCM, own, selection, target, type
