'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /usr/cvs/NEOSOFT/inet_workstation/tcl7.3/tk3.6/doc/tkvars.n,v 2.0 1994/12/23 20:38:29 karl Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS tkvars tk 3.3
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tkvars \- Variables used or set by Tk
.BE

.SH DESCRIPTION
.PP
The following Tcl variables are either set or used by Tk at various times
in its execution:
.TP 15
\fBtk_library\fR
Tk sets this variable hold the name of a directory containing a library
of Tcl scripts related to Tk.  These scripts include an initialization
file that is normally processed whenever a Tk application starts up,
plus other files containing procedures that implement default behaviors
for widgets.
.VS
The value of this variable is taken from the TK_LIBRARY environment
variable, if one exists, or else from a default value compiled into
Tk.
.VE
.TP
\fBtk_patchLevel\fR
.VS
Contains a decimal integer giving the current patch level for Tk.
The patch level is incremented for each new release or patch, and
it uniquely identifies an official version of Tk.
.VE
.TP
\fBtk_priv\fR
This variable is an array containing several pieces of information
that are private to Tk.  The elements of \fBtk_priv\fR are used by
Tk library procedures and default bindings.
They should not be accessed by any code outside Tk.
.TP
\fBtk_strictMotif\fR
This variable is set to zero by default.
If an application sets it to one, then Tk attempts to adhere as
closely as possible to Motif look-and-feel standards.
For example, active elements such as buttons and scrollbar
sliders will not change color when the pointer passes over them.
.TP 15
\fBtk_version\fR
Tk sets this variable in the interpreter for each application.
The variable holds the current version number of the Tk
library in the form \fImajor\fR.\fIminor\fR.  \fIMajor\fR and
\fIminor\fR are integers.  The major version number increases in
any Tk release that includes changes that are not backward compatible
(i.e. whenever existing Tk applications and scripts may have to change to
work with the new release).  The minor version number increases with
each new release of Tk, except that it resets to zero whenever the
major version number changes.
.TP 15
\fBtkVersion\fR
Has the same value as \fBtk_version\fR.  This variable is obsolete and
will be deleted soon.

.SH KEYWORDS
variables, version
