'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /usr/cvs/NEOSOFT/inet_workstation/tcl7.3/tk3.6/doc/winfo.n,v 2.0 1994/12/23 20:38:35 karl Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS winfo tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
winfo \- Return window-related information
.SH SYNOPSIS
\fBwinfo\fR \fIoption \fR?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
The \fBwinfo\fR command is used to retrieve information about windows
managed by Tk.  It can take any of a number of different forms,
depending on the \fIoption\fR argument.  The legal forms are:
.TP
\fBwinfo atom \fIname\fR
.VS
Returns a decimal string giving the integer identifier for the
atom whose name is \fIname\fR.  If no atom exists with the name
\fIname\fR then a new one is created.
.TP
\fBwinfo atomname \fIid\fR
Returns the textual name for the atom whose integer identifier is
\fIid\fR.
This command is the inverse of the \fBwinfo atom\fR command.
Generates an error if no such atom exists.
.TP
\fBwinfo cells \fIwindow\fR
Returns a decimal string giving the number of cells in the
color map for \fIwindow\fR.
.VE
.TP
\fBwinfo children \fIwindow\fR
Returns a list containing the path names of all the children
of \fIwindow\fR.  Top-level windows are returned as children
of their logical parents.
.TP
\fBwinfo class \fIwindow\fR
Returns the class name for \fIwindow\fR.
.TP
\fBwinfo containing \fIrootX rootY\fR
.VS
Returns the path name for the window containing the point given
by \fIrootX\fR and \fIrootY\fR.
\fIRootX\fR and \fIrootY\fR are specified in screen units (i.e.
any form acceptable to \fBTk_GetPixels\fR) in the coordinate
system of the root window (if a virtual-root window manager is in
use then the coordinate system of the virtual root window is used).
If no window in this application contains the point then an empty
string is returned.
In selecting the containing window, children are given higher priority
than parents and among siblings the highest one in the stacking order is
chosen.
.TP
\fBwinfo depth \fIwindow\fR
Returns a decimal string giving the depth of \fIwindow\fR (number
of bits per pixel).
.TP
\fBwinfo exists \fIwindow\fR
Returns 1 if there exists a window named \fIwindow\fR, 0 if no such
window exists.
.TP
\fBwinfo fpixels \fIwindow\fR \fInumber\fR
Returns a floating-point value giving the number of pixels
in \fIwindow\fR corresponding to the distance given by \fInumber\fR.
\fINumber\fR may be specified in any of the forms acceptable
to \fBTk_GetScreenMM\fR, such as ``2.0c'' or ``1i''.
The return value may be fractional;  for an integer value, use
\fBwinfo pixels\fR.
.VE
.TP
\fBwinfo geometry \fIwindow\fR
Returns the geometry for \fIwindow\fR, in the form
\fIwidth\fBx\fIheight\fB+\fIx\fB+\fIy\fR.  All dimensions are
in pixels.
.TP
\fBwinfo height \fIwindow\fR
Returns a decimal string giving \fIwindow\fR's height in pixels.
When a window is first created its height will be 1 pixel;  the
height will eventually be changed by a geometry manager to fulfill
the window's needs.
If you need the true height immediately after creating a widget,
invoke \fBupdate\fR to force the geometry manager to arrange it,
or use \fBwinfo reqheight\fR to get the window's requested height
instead of its actual height.
.TP
\fBwinfo id \fIwindow\fR
Returns a hexadecimal string indicating the X identifier for \fIwindow\fR.
.TP
\fBwinfo interps\fR
Returns a list whose members are the names of all Tcl interpreters
(e.g. all Tk-based applications) currently registered for the
display of the invoking application.
.TP
\fBwinfo ismapped \fIwindow\fR
Returns \fB1\fR if \fIwindow\fR is currently mapped, \fB0\fR otherwise.
.TP
\fBwinfo name \fIwindow\fR
Returns \fIwindow\fR's name (i.e. its name within its parent, as opposed
to its full path name).
.VS
The command \fBwinfo name .\fR will return the name of the application.
.VE
.TP
\fBwinfo parent \fIwindow\fR
Returns the path name of \fIwindow\fR's parent, or an empty string
if \fIwindow\fR is the main window of the application.
.TP
\fBwinfo pathname \fIid\fR
Returns the path name of the window whose X identifier is \fIid\fR.
\fIId\fR must be a decimal, hexadecimal, or octal integer and must
correspond to a window in the invoking application.
.TP
\fBwinfo pixels \fIwindow\fR \fInumber\fR
.VS
Returns the number of pixels in \fIwindow\fR corresponding
to the distance given by \fInumber\fR.
\fINumber\fR may be specified in any of the forms acceptable
to \fBTk_GetPixels\fR, such as ``2.0c'' or ``1i''.
The result is rounded to the nearest integer value;  for a
fractional result, use \fBwinfo fpixels\fR.
.VE
.TP
\fBwinfo reqheight \fIwindow\fR
Returns a decimal string giving \fIwindow\fR's requested height,
in pixels.  This is the value used by \fIwindow\fR's geometry
manager to compute its geometry.
.TP
\fBwinfo reqwidth \fIwindow\fR
Returns a decimal string giving \fIwindow\fR's requested width,
in pixels.  This is the value used by \fIwindow\fR's geometry
manager to compute its geometry.
.TP
\fBwinfo rgb \fIwindow color\fR
.VS
Returns a list containing three decimal values, which are the
red, green, and blue intensities that correspond to \fIcolor\fR in
the window given by \fIwindow\fR.  \fIColor\fR
may be specified in any of the forms acceptable for a color
option.
.VE
.TP
\fBwinfo rootx \fIwindow\fR
Returns a decimal string giving the x-coordinate, in the root
window of the screen, of the
upper-left corner of \fIwindow\fR's border (or \fIwindow\fR if it
has no border).
.TP
\fBwinfo rooty \fIwindow\fR
Returns a decimal string giving the y-coordinate, in the root
window of the screen, of the
upper-left corner of \fIwindow\fR's border (or \fIwindow\fR if it
has no border).
.TP
\fBwinfo screen \fIwindow\fR
Returns the name of the screen associated with \fIwindow\fR, in
the form \fIdisplayName\fR.\fIscreenIndex\fR.
.TP
\fBwinfo screencells \fIwindow\fR
.VS
Returns a decimal string giving the number of cells in the default
color map for \fIwindow\fR's screen.
.TP
\fBwinfo screendepth \fIwindow\fR
Returns a decimal string giving the depth of the root window
of \fIwindow\fR's screen (number of bits per pixel).
.TP
\fBwinfo screenheight \fIwindow\fR
Returns a decimal string giving the height of \fIwindow\fR's screen,
in pixels.
.TP
\fBwinfo screenmmheight \fIwindow\fR
Returns a decimal string giving the height of \fIwindow\fR's screen,
in millimeters.
.TP
\fBwinfo screenmmwidth \fIwindow\fR
Returns a decimal string giving the width of \fIwindow\fR's screen,
in millimeters.
.TP
\fBwinfo screenvisual \fIwindow\fR
Returns one of the following strings to indicate the default visual
type for \fIwindow\fR's screen: \fBdirectcolor\fR, \fBgrayscale\fR,
\fBpseudocolor\fR, \fBstaticcolor\fR, \fBstaticgray\fR, or
\fBtruecolor\fR.
.TP
\fBwinfo screenwidth \fIwindow\fR
Returns a decimal string giving the width of \fIwindow\fR's screen,
in pixels.
.TP
\fBwinfo toplevel \fIwindow\fR
Returns the path name of the top-level window containing \fIwindow\fR.
.TP
\fBwinfo visual \fIwindow\fR
Returns one of the following strings to indicate the visual
type for \fIwindow\fR: \fBdirectcolor\fR, \fBgrayscale\fR,
\fBpseudocolor\fR, \fBstaticcolor\fR, \fBstaticgray\fR, or
\fBtruecolor\fR.
.TP
\fBwinfo vrootheight \fIwindow\fR
Returns the height of the virtual root window associated with \fIwindow\fR
if there is one;  otherwise returns the height of \fIwindow\fR's screen.
.TP
\fBwinfo vrootwidth \fIwindow\fR
Returns the width of the virtual root window associated with \fIwindow\fR
if there is one;  otherwise returns the width of \fIwindow\fR's screen.
.TP
\fBwinfo vrootx \fIwindow\fR
Returns the x-offset of the virtual root window associated with \fIwindow\fR,
relative to the root window of its screen.
This is normally either zero or negative.
Returns 0 if there is no virtual root window for \fIwindow\fR.
.TP
\fBwinfo vrooty \fIwindow\fR
Returns the y-offset of the virtual root window associated with \fIwindow\fR,
relative to the root window of its screen.
This is normally either zero or negative.
Returns 0 if there is no virtual root window for \fIwindow\fR.
.VE
.TP
\fBwinfo width \fIwindow\fR
Returns a decimal string giving \fIwindow\fR's width in pixels.
When a window is first created its width will be 1 pixel;  the
width will eventually be changed by a geometry manager to fulfill
the window's needs.
If you need the true width immediately after creating a widget,
invoke \fBupdate\fR to force the geometry manager to arrange it,
or use \fBwinfo reqwidth\fR to get the window's requested width
instead of its actual width.
.TP
\fBwinfo x \fIwindow\fR
Returns a decimal string giving the x-coordinate, in \fIwindow\fR's
parent, of the
upper-left corner of \fIwindow\fR's border (or \fIwindow\fR if it
has no border).
.TP
\fBwinfo y \fIwindow\fR
Returns a decimal string giving the y-coordinate, in \fIwindow\fR's
parent, of the
upper-left corner of \fIwindow\fR's border (or \fIwindow\fR if it
has no border).

.SH KEYWORDS
atom, children, class, geometry, height, identifier, information, interpreters,
mapped, parent, path name, screen, virtual root, width, window
