#
# iwidgets.tcl
# ----------------------------------------------------------------------
# Invoked automatically by [incr Tk] upon startup to initialize
# the [incr Widgets] package.
# ----------------------------------------------------------------------
#  AUTHOR: Mark L. Ulferts               EMAIL: mulferts@spd.dsccc.com
#
#  @(#) $Id: iwidgets.tcl.in,v 1.1.1.1 1996/09/10 06:55:02 karl Exp $
# ----------------------------------------------------------------------
#                Copyright (c) 1995  Mark L. Ulferts
# ======================================================================
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in
# all copies of this software.
#
# IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
# ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
# IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.
#
# THE COPYRIGHT HOLDER SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND THE COPYRIGHT HOLDER HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
# ======================================================================
package require Tcl 7.5
package require Tk 4.1
package require Itcl 2.1
package require Itk 2.1

package provide Iwidgets 2.1.0

#
# Create the namespace that will contain all [incr Widgets]
#
namespace ::iwidgets {}
import add iwidgets

#
# See if the user has set a value for IWIDGETS_LIBRARY.
# If not, use the value set when this package was installed.
#
public variable iwidgets::library "/usr/neosoft96/lib/itcl/iwidgets2.1.0"

if {[info exists env(IWIDGETS_LIBRARY)]} {
    set iwidgets::library $env(IWIDGETS_LIBRARY)
}
if {![file exists ${iwidgets::library}]} {
    set msg "can't find ${iwidgets::library}\n"
    append msg "Perhaps you need to install \[incr Widgets\]\n"
    append msg "or set your IWIDGETS_LIBRARY environment variable?"
    error $msg
}

#
# Set up the [incr Widgets] library directory for auto-loading
#
lappend auto_path ${iwidgets::library}
