'\"
'\" Copyright (c) 1995 AT&T Bell Laboratories
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" $Id: itk.n,v 1.1.1.1 1996/09/10 06:55:23 karl Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" @(#) man.macros 1.3 95/05/06 15:19:04
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# CS - begin display of code example
.de CS
.in +0.4i
.nf
\fC
..
'\"	# CE - end display of code example
.de CE
\fP
.fi
.in -0.4i
..
.TH itk n "" itk "[incr\ Tk]"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
itk \- framework for building mega-widgets in Tcl/Tk
.BE

.SH DESCRIPTION
.PP
Mega-widgets are high-level widgets that are constructed using
Tk widgets as component parts, usually without any C code.  A
fileselectionbox, for example, may have a few listboxes, some
entry widgets and some control buttons.  These individual widgets
are put together in a way that makes them act like one big
widget.  A fileselectionbox mega-widget can be created with a
command like:
.CS
fileselectionbox .fsb -background blue -foreground white
.CE
Once it has been created, it can be reconfigured with a command
like:
.CS
\&.fsb configure -background green -foreground black
.CE
and all of its internal components will change color.  Each
mega-widget has a set of methods that can be used to manipulate
it.  For example, the current selection can be queried from a
fileselectionbox like this:
.CS
set fileName [.fsb get]
.CE
In effect, a mega-widget looks and acts exactly like a Tk widget,
but is considerably easier to implement.
.PP
\fB[incr\ Tk]\fR is a framework for building mega-widgets.  It
uses \fB[incr\ Tcl]\fR to support the object paradigm, and adds
base classes which provide default widget behaviors.
.PP
All \fB[incr\ Tk]\fR widgets are derived from the \fBArchetype\fR
base class.  This class manages internal component widgets,
and provides methods like "configure" and "cget" to access
configuration options.
.PP
The \fBWidget\fR base class inherits everything from \fBArchetype\fR,
and adds a Tk frame which acts as a container for the mega-widget.
It is used to build mega-widgets that sit inside of other frames
and toplevels.  Derived classes create other internal components
and pack them into the "hull" frame created by the \fBWidget\fR
base class.
.PP
The \fBToplevel\fR base class inherits everything from \fBArchetype\fR,
but adds a Tk toplevel which acts as a container for the mega-widget.
It is used to build mega-widgets, such as dialog boxes, that have
their own toplevel window.  Derived classes create other internal
components and pack them into the "hull" toplevel created by the
\fBToplevel\fR base class.

.SH [incr Widgets] LIBRARY
.PP
\fB[incr\ Widgets]\fR is a mega-widget library built using
\fB[incr\ Tk]\fR.  It can be used right out of the box, and
contains more than 30 different widget classes, including:
.IP -
fileselectiondialog
.IP -
tabnotebook
.IP -
panedwindow
.IP -
combobox
.IP -
optionmenu
.IP -
scrolledlistbox
.IP -
scrolledframe
.IP -
messagedialog
.IP -
and many others...
.LP
The \fBcatalog\fR demo in the "iwidgets/demos" directory
shows all of the available widgets in action.  Each widget
class has its own man page describing the features available.

.SH KEYWORDS
class, object, object-oriented, mega-widget
