'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) trace.n 1.11 96/03/25 20:25:42
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  If an argument is present, then a line break is
'\"	forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" SCCS: @(#) man.macros 1.8 96/02/15 20:02:24
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$1"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH trace n "" Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
trace \- Monitor variable accesses
.SH SYNOPSIS
\fBtrace \fIoption\fR ?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
This command causes Tcl commands to be executed whenever certain operations are
invoked.  At present, only variable tracing is implemented. The
legal \fIoption\fR's (which may be abbreviated) are:
.TP
\fBtrace variable \fIname ops command\fR
Arrange for \fIcommand\fR to be executed whenever variable \fIname\fR
is accessed in one of the ways given by \fIops\fR.  \fIName\fR may
refer to a normal variable, an element of an array, or to an array
as a whole (i.e. \fIname\fR may be just the name of an array, with no
parenthesized index).  If \fIname\fR refers to a whole array, then
\fIcommand\fR is invoked whenever any element of the array is
manipulated.
.RS
.PP
\fIOps\fR indicates which operations are of interest, and consists of
one or more of the following letters:
.TP
\fBr\fR
Invoke \fIcommand\fR whenever the variable is read.
.TP
\fBw\fR
Invoke \fIcommand\fR whenever the variable is written.
.TP
\fBu\fR
Invoke \fIcommand\fR whenever the variable is unset.  Variables
can be unset explicitly with the \fBunset\fR command, or
implicitly when procedures return (all of their local variables
are unset).  Variables are also unset when interpreters are
deleted, but traces will not be invoked because there is no
interpreter in which to execute them.
.PP
When the trace triggers, three arguments are appended to
\fIcommand\fR so that the actual command is as follows:
.CS
\fIcommand name1 name2 op\fR
.CE
\fIName1\fR and \fIname2\fR give the name(s) for the variable
being accessed:  if the variable is a scalar then \fIname1\fR
gives the variable's name and \fIname2\fR is an empty string;
if the variable is an array element then \fIname1\fR gives the
name of the array and name2 gives the index into the array;
if an entire array is being deleted and the trace was registered
on the overall array, rather than a single element, then \fIname1\fR
gives the array name and \fIname2\fR is an empty string.
\fIName1\fR and \fIname2\fR are not necessarily the same as the
name used in the \fBtrace variable\fR command:  the \fBupvar\fR
command allows a procedure to reference a variable under a
different name.
\fIOp\fR indicates what operation is being performed on the
variable, and is one of \fBr\fR, \fBw\fR, or \fBu\fR as
defined above.
.PP
\fICommand\fR executes in the same context as the code that invoked
the traced operation:  if the variable was accessed as part of a
Tcl procedure, then \fIcommand\fR will have access to the same
local variables as code in the procedure.  This context may be
different than the context in which the trace was created.
If \fIcommand\fR invokes a procedure (which it normally does) then
the procedure will have to use \fBupvar\fR or \fBuplevel\fR if it
wishes to access the traced variable.
Note also that \fIname1\fR may not necessarily be the same as the name
used to set the trace on the variable;  differences can occur if
the access is made through a variable defined with the \fBupvar\fR
command.
.PP
For read and write traces, \fIcommand\fR can modify
the variable to affect the result of the traced operation.
If \fIcommand\fR modifies the value of a variable during a
read or write trace, then the new value will be returned as the
result of the traced operation.
The return value from  \fIcommand\fR is ignored except that
if it returns an error of any sort then the traced operation
also returns an error with
.VS
the same error message returned by the trace command
.VE
(this mechanism can be used to implement read-only variables, for
example).
For write traces, \fIcommand\fR is invoked after the variable's
value has been changed; it can write a new value into the variable
to override the original value specified in the write operation.
To implement read-only variables, \fIcommand\fR will have to restore
the old value of the variable.
.PP
While \fIcommand\fR is executing during a read or write trace, traces
on the variable are temporarily disabled.
This means that reads and writes invoked by
\fIcommand\fR will occur directly, without invoking \fIcommand\fR
(or any other traces) again.
.VS
However, if \fIcommand\fR unsets the variable then unset traces
will be invoked.
.VE
.PP
When an unset trace is invoked, the variable has already been
deleted:  it will appear to be undefined with no traces.
If an unset occurs because of a procedure return, then the
trace will be invoked in the variable context of the procedure
being returned to:  the stack frame of the returning procedure
will no longer exist.
Traces are not disabled during unset traces, so if an unset trace
command creates a new trace and accesses the variable, the
trace will be invoked.
.VS
Any errors in unset traces are ignored.
.VE
.PP
If there are multiple traces on a variable they are invoked
in order of creation, most-recent first.
If one trace returns an error, then no further traces are
invoked for the variable.
If an array element has a trace set, and there is also a trace
set on the array as a whole, the trace on the overall array
is invoked before the one on the element.
.PP
Once created, the trace remains in effect either until the
trace is removed with the \fBtrace vdelete\fR command described
below, until the variable is unset, or until the interpreter
is deleted.
Unsetting an element of array will remove any traces on that
element, but will not remove traces on the overall array.
.PP
This command returns an empty string.
.RE
.TP
\fBtrace vdelete \fIname ops command\fR
If there is a trace set on variable \fIname\fR with the
operations and command given by \fIops\fR and \fIcommand\fR,
then the trace is removed, so that \fIcommand\fR will never
again be invoked.
Returns an empty string.
.TP
\fBtrace vinfo \fIname\fR
Returns a list containing one element for each trace
currently set on variable \fIname\fR.
Each element of the list is itself a list containing two
elements, which are the \fIops\fR and \fIcommand\fR associated
with the trace.
If \fIname\fR doesn't exist or doesn't have any traces set, then
the result of the command will be an empty string.

.SH KEYWORDS
read, variable, write, trace, unset
