/*
 * ------------------------------------------------------------------------
 *      PACKAGE:  [incr Tk]
 *  DESCRIPTION:  Building mega-widgets with [incr Tcl]
 *
 *  [incr Tk] provides a framework for building composite "mega-widgets"
 *  using [incr Tcl] classes.  It defines a set of base classes that are
 *  specialized to create all other widgets.
 *  
 *  This file includes all declarations used internally by this
 *  package.
 *  
 * ========================================================================
 *  AUTHOR:  Michael J. McLennan
 *           Bell Labs Innovations for Lucent Technologies
 *           mmclennan@lucent.com
 *           http://www.tcltk.com/itcl
 *
 *     RCS:  $Id: itkInt.h,v 1.1.1.1 1997/10/20 03:58:21 kunkee Exp $
 * ========================================================================
 *               Copyright (c) 1993-1996  Lucent Technologies
 * ------------------------------------------------------------------------
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */
#ifndef ITKINT_H
#define ITKINT_H

#ifndef ITK_H
#include "itk.h"
#endif

#include "itclInt.h"

/*
 *  List of options in alphabetical order...
 */
typedef struct ItkOptList {
    Tcl_HashTable *options;     /* list containing the real options */
    Tcl_HashEntry **list;       /* gives ordering of options */
    int len;                    /* number of entries in order list */
    int max;                    /* maximum size of order list */
} ItkOptList;

/*
 *  List of options created in the class definition...
 */
typedef struct ItkClassOptTable {
    Tcl_HashTable options;        /* option storage with fast lookup */
    ItkOptList order;             /* gives ordering of options */
} ItkClassOptTable;

/*
 *  Each option created in the class definition...
 */
typedef struct ItkClassOption {
    Itcl_Class *cdefn;            /* class containing this option */
    char *switchName;             /* command-line switch for this option */
    char *resName;                /* resource name in X11 database */
    char *resClass;               /* resource class name in X11 database */
    char *init;                   /* initial value for option */
    ItclCmdImplement *config;     /* code invoked when reconfigured */
} ItkClassOption;


/*
 *  Functions used internally by this package...
 */
EXTERN int Itk_ConfigBodyCmd _ANSI_ARGS_((ClientData cdata,
    Tcl_Interp *interp, int argc, char **argv));
EXTERN int Itk_UsualCmd _ANSI_ARGS_((ClientData cdata,
    Tcl_Interp *interp, int argc, char **argv));

/*
 *  Functions for managing options included in class definitions...
 */
EXTERN int Itk_ClassOptionDefineCmd _ANSI_ARGS_((ClientData cdata,
    Tcl_Interp *interp, int argc, char **argv));
EXTERN int Itk_ClassOptionIllegalCmd _ANSI_ARGS_((ClientData cdata,
    Tcl_Interp *interp, int argc, char **argv));

EXTERN int Itk_ConfigClassOption _ANSI_ARGS_((Tcl_Interp *interp,
    Itcl_Object *obj, ClientData cdata, char* newVal));

EXTERN ItkClassOptTable* Itk_CreateClassOptTable _ANSI_ARGS_((
    Tcl_Interp *interp, Itcl_Class *cdefn));
EXTERN ItkClassOptTable* Itk_FindClassOptTable _ANSI_ARGS_((
    Itcl_Class *cdefn));
EXTERN void Itk_DeleteClassOptTable _ANSI_ARGS_((Tcl_Interp *interp,
    Itcl_Class *cdefn));

EXTERN char* Itk_TraceClassDestroy _ANSI_ARGS_((ClientData cdata,
    Tcl_Interp *interp, char *name1, char *name2, int flags));

EXTERN int Itk_CreateClassOption _ANSI_ARGS_((Tcl_Interp *interp,
    Itcl_Class *cdefn, char *switchName, char *resName, char *resClass,
    char *defVal, char *config, ItkClassOption **optPtr));
EXTERN ItkClassOption* Itk_FindClassOption _ANSI_ARGS_((
    Itcl_Class *cdefn, char *switchName));
EXTERN void Itk_DelClassOption _ANSI_ARGS_((ItkClassOption *opt));

/*
 *  Functions needed for the Archetype base class...
 */
EXTERN int Itk_ArchetypeInit _ANSI_ARGS_((Tcl_Interp* interp));

/*
 *  Functions for maintaining the ordered option list...
 */
EXTERN void Itk_OptListInit _ANSI_ARGS_((ItkOptList* olist,
    Tcl_HashTable *options));
EXTERN void Itk_OptListFree _ANSI_ARGS_((ItkOptList* olist));

EXTERN void Itk_OptListAdd _ANSI_ARGS_((ItkOptList* olist,
    Tcl_HashEntry *entry));
EXTERN void Itk_OptListRemove _ANSI_ARGS_((ItkOptList* olist,
    Tcl_HashEntry *entry));

#endif
