/*
 * General NeoSoft Extension Routines
 *
 *
 * $Id: neoXgeneral.c,v 1.2 1997/05/28 22:24:32 kunkee Exp $
 *
 */

#include "neo.h"
#include "util_md5.h"


/*
 *----------------------------------------------------------------------
 *
 * Tcl_Incr0Cmd --
 *
 *	This procedure is invoked to process the "incr0" Tcl command.
 *	See the user documentation for details on what it does.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *----------------------------------------------------------------------
 */

    /* ARGSUSED */
int
Neo_Incr0Cmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
    int value;
    char *oldString, *result;
    char newString[30];

    if ((argc != 2) && (argc != 3)) {
	Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		" varName ?increment?\"", (char *) NULL);
	return TCL_ERROR;
    }

    oldString = Tcl_GetVar(interp, argv[1], 0);
    if (oldString == NULL) {
	value = 0;
    } else {
        if (Tcl_GetInt(interp, oldString, &value) != TCL_OK) {
	    Tcl_AddErrorInfo(interp,
		    "\n    (reading value of variable to increment)");
	    return TCL_ERROR;
	}
    }
    if (argc == 2) {
	value += 1;
    } else {
	int increment;

	if (Tcl_GetInt(interp, argv[2], &increment) != TCL_OK) {
	    Tcl_AddErrorInfo(interp,
		    "\n    (reading increment)");
	    return TCL_ERROR;
	}
	value += increment;
    }
    sprintf(newString, "%d", value);
    result = Tcl_SetVar(interp, argv[1], newString, TCL_LEAVE_ERR_MSG);
    if (result == NULL) {
	return TCL_ERROR;
    }
    interp->result = result;
    return TCL_OK; 
}

int
Neo_MD5Cmd (clientData, interp, argc, argv)
    ClientData  clientData;
    Tcl_Interp *interp;
    int         argc;
    char      **argv;
{
    char *digest;
 
    if (argc != 2) {
        sprintf(interp->result, "usage: md5 string");
        return TCL_ERROR;
    }
    digest = md5(argv[1]);
    Tcl_SetResult(interp, digest, TCL_DYNAMIC);
    return TCL_OK;
}

int
Neo_initGeneral (interp)
Tcl_Interp	*interp;
{
    Tcl_CreateCommand (interp, "incr0", Neo_Incr0Cmd,
	  (ClientData)NULL, (void (*)())NULL);
    Tcl_CreateCommand (interp, "md5", Neo_MD5Cmd,
	  (ClientData)NULL, (void (*)())NULL);

    return TCL_OK;
}
