
#@package: menu1 create_pulldown_menu

package require Tk

#
# Copyright (C) 1992-1996 NeoSoft.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  NeoSoft makes no 
# representations about the suitability of this software for any purpose.
# It is provided "as is" without express or implied warranty.

#
# $Id: menus.tcl,v 1.1.1.1 1997/01/15 23:54:57 kunkee Exp $
#

#
# first cut at menus, see control station to see it in use
#
# doesn't do enough, but it at least simplifies things 
#
#

proc combine_widgetnames {parentName childName} {
    if {$parentName == "."} {
        return .$childName
    }
    return $parentName.$childName
}

proc create_pulldown_menu {parentFrame menuName menuText underline {packing left}} {
    global pulldownMenuElements

    set menuFrame [combine_widgetnames $parentFrame menuFrame]
    set buttonName "$menuFrame.$menuName"
    menubutton $buttonName -text $menuText -menu $buttonName.m -underline $underline
    menu $buttonName.m
    pack append $menuFrame $buttonName $packing
    lappend pulldownMenuElements($menuFrame) $buttonName
}

proc add_pulldown {command parentFrame menuName entryName args} {
    set menuFrame [combine_widgetnames $parentFrame menuFrame]
    set menu $menuFrame.$menuName.m
    eval $menu add $command -label \"$entryName\" $args
}

proc add_pulldown_separator {parentFrame menuName} {
    set menuFrame [combine_widgetnames $parentFrame menuFrame]
    set menu $menuFrame.$menuName.m
    $menu add separator
}

proc bind_pulldown_menus {parentFrame} {
    global pulldownMenuElements
    set menuFrame [combine_widgetnames $parentFrame menuFrame]

    foreach frame [array names pulldownMenuElements] {
        eval tk_menuBar $frame $pulldownMenuElements($frame)
    }
    tk_bindForTraversal $menuFrame
    bind $parentFrame <Any-Enter> "focus $menuFrame"
}

