#@package: array_utilities copy_array array_to_keyed_list keyed_list_to_array are_arrays_identical
#
# Array Utility Functions
#
#
# $Id: arrayutil.tcl,v 1.1.1.1 1997/01/15 23:54:58 kunkee Exp $

#
# Copy the contents of one array into another.
#
proc copy_array {sourceArrayName destArrayName} {
    upvar $sourceArrayName sourceArray $destArrayName destArray

    set searchId [array startsearch sourceArray]
    while {[array anymore sourceArray $searchId]} {
	set elementName [array nextelement sourceArray $searchId]
	set destArray($elementName) sourceArray($elementName)
    }
    array donesearch sourceArray $searchId
}

#
# Convert an array to a keyed list.  Only handles "flat" keyed lists.
#
proc array_to_keyed_list {arrayName} {
    upvar $arrayName array

    set list ""
    foreach key [array names array] {
        keylset list $key $array($key)
    }
    return $list
}

#
# Convert a keyed list to an array.  Only handles "flat" keyed lists.
#
proc keyed_list_to_array {list arrayName} {
    upvar $arrayName array

    foreach key [keylkeys list] {
        set array($key) [keylget list $key]
    }
}

#
# Return true if two arrays are identical, else false.
#
proc are_arrays_identical {array1Name array2Name} {
    upvar $array1Name array1 $array2Name array2

    # if they don't have the same number of elements, no way are they identical
    if {[array size array1] != [array size array2]} {return 0}

    # For each element in the first array,
    #    If the element isn't in the second array, they're not identical.
    #    If the contents of both elements aren't the same, the arrays aren't
    #      identical.
    # If you get to the end, the arrays are identical.

    set searchId [array startsearch array1]
    while {[array anymore array1 $searchId]} {
	set elementName [array nextelement array1 $searchId]
	if ![info exists array2($elementName)] {return 0}
	if {$array1($elementName) != $array2($elementName)} {
	    return 0
	}
    }
    array donesearch sourceArray $searchId
    return 1
}

