#@package: catchers fail_exit die

#
# Copyright (C) 1992-1996 NeoSoft.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  NeoSoft makes no 
# representations about the suitability of this software for any purpose.
# It is provided "as is" without express or implied warranty.

# $Id: catchers.tcl,v 1.1.1.1 1997/01/15 23:54:58 kunkee Exp $

#
#  fail_exit command [exitStatus]
#      execute command and, if it gets a tcl error, write the program
#      name and error message to stderr and exit the program.
#      If exit is taken, exit status is 1 unless specified.
#
proc fail_exit {command {exitStatus 1}} {
    if {[catch {uplevel $command} result] == 1} {
        global argv0
	puts stderr "$argv0: $result"
	exit $exitStatus
    }
}

proc die {message {exitStatus 1}} {
    puts stderr $message
    exit $exitStatus
}
