#@package: neo_misc_procs force_width dollar_format

#
# Copyright (C) 1992-1996 NeoSoft.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  NeoSoft makes no 
# representations about the suitability of this software for any purpose.
# It is provided "as is" without express or implied warranty.

#
# return a string forceed to a specified width either by padding, if it
# is too short, or by truncation, if it is too long.
#
proc force_width {string width} {
    return [crange [format "%-${width}s" $string] 0 $width-1]
}

#
# format a number and return it as a dollar field (two digits precision
# to the right of the decimal place.)
#
proc dollar_format {number} {
    return [format "%.2f" $number]
}

