'\"
'\" Copyright (c) 1996 Lucent Technologies
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" $Id: variable.n,v 1.1.1.1 1997/10/20 03:57:57 kunkee Exp $
'\" 
.so man.macros
.TH variable n "" Tcl "Tcl With Namespaces"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
variable \- create or modify a global variable
.SH SYNOPSIS
\fBvariable \fIvarName \fR?\fIvalue\fR?
.BE

.SH DESCRIPTION
.PP
Creates a global variable named \fIvarName\fR in the current namespace
context and sets its protection to the current level.  If the variable
already exists, it is updated to have the current protection level.
If the optional \fIvalue\fR string is specified, the variable
is set to that value.  This command is usually used in conjunction
with the \fBpublic\fR, \fBprotected\fR and \fBprivate\fR commands to
declare a variable with a certain protection level within a namespace.
.PP
The \fIvarName\fR string cannot reference an element within an array.
Instead, \fIvarName\fR should reference the entire array, and the
initialization \fIvalue\fR should be left off.  After the variable
has been declared, elements within the array can be set using ordinary
\fBset\fR statements or the \fBarray\fR command.
.PP
If the \fBvariable\fR command is used within a procedure, it will still
create or modify a global variable, but unlike the \fBglobal\fR command,
it will not install an alias to the variable in the local call frame.

.SH KEYWORDS
global, namespace, private, protected, public
