/*
 * tkMacLibrary.r --
 *
 *	This file creates resources for use in most Tk applications.
 *	This is designed to be an example of using the Tcl/Tk 
 *	libraries in a Macintosh Application.
 *
 * Copyright (c) 1996 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * SCCS: @(#) tkMacLibrary.r 1.5 96/10/03 17:54:21
 */

#include <Types.r>
#include <SysTypes.r>
#include <AEUserTermTypes.r>

/*
 * The folowing include and defines help construct
 * the version string for Tcl.
 */

#define RESOURCE_INCLUDED
#include <tcl.h>
#include "tk.h"

#if (TK_RELEASE_LEVEL == 0)
#   define RELEASE_LEVEL alpha
#elif (TK_RELEASE_LEVEL == 1)
#   define RELEASE_LEVEL beta
#elif (TK_RELEASE_LEVEL == 2)
#   define RELEASE_LEVEL final
#endif

#if (TK_RELEASE_LEVEL == 2)
#   define MINOR_VERSION (TK_MINOR_VERSION * 16) + TK_RELEASE_SERIAL
#else
#   define MINOR_VERSION TK_MINOR_VERSION * 16
#endif

#define RELEASE_CODE 0x00

resource 'vers' (1) {
	TK_MAJOR_VERSION, MINOR_VERSION,
	RELEASE_LEVEL, 0x00, verUS,
	TK_PATCH_LEVEL,
	TK_PATCH_LEVEL ", by Ray Johnson  1993-1996" "\n" "Sun Microsystems Labratories"
};

resource 'vers' (2) {
	TK_MAJOR_VERSION, MINOR_VERSION,
	RELEASE_LEVEL, 0x00, verUS,
	TK_PATCH_LEVEL,
	"Tk Library " TK_PATCH_LEVEL "  1993-1996"
};

#define TK_LIBRARY_RESOURCES 3000
/*
 * The -16397 string will be displayed by Finder when a user
 * tries to open the shared library. The string should
 * give the user a little detail about the library's capabilities
 * and enough information to install the library in the correct location.  
 * A similar string should be placed in all shared libraries.
 */
resource 'STR ' (-16397, purgeable) {
	"Tk Library\n\n"
	"This is the library needed to run Tcl/Tk programs. "
	"To work properly, it should be placed in the Tool Command Language folder "
	"within the Extensions folder."
};


/* 
 * We now load the Tk library into the resource fork of the library.
 */

#include "tkMacTclCode.r"

/*
 * Now we define a pkgIndex file for the library.
 */
 
data 'TEXT' (TK_LIBRARY_RESOURCES+19,"pkgIndex",purgeable, preload) {
	"# Tcl package index file, version 1.0\n"
	"package ifneeded Tk 4.2 [list load [file join $dir tk4.2i[info sharedlibextension]] Tk]\n"
};

/*
 * The following resources defines the Apple Events that Tk can be
 * sent from Apple Script.
 */

resource 'aete' (0, "Tcl Suite") {
    0x01, 0x00, english, roman,
    {
	"Required Suite", 
	"Events that every application should support", 
	'reqd', 1, 1,
	{},
	{},
	{},
	{},

	"Tcl Suite", "Events for Tcl applications", 'WIsH', 1, 1,
	{
	    "do script", "Execute a Tcl script", 'misc', 'dosc',
	    'TEXT', "Result", replyOptional, singleItem,
	    notEnumerated, reserved, reserved, reserved, reserved,
	    reserved, reserved, reserved, reserved, reserved,
	    reserved, reserved, reserved, reserved, 
	    'TEXT', "Script to execute", directParamRequired,
	    singleItem, notEnumerated, changesState, reserved,
	    reserved, reserved, reserved, reserved, reserved,
	    reserved, reserved, reserved, reserved, reserved,
	    reserved, 
	    {},
	},
	{},
	{},
	{},
    }
};

