#
##		client.tcl:  procedures to be sourced into the safe interpreter.
###		Written by George Porter <gporter@neosoft.com>
##		NeoWebScript-SA.  Copyright 1997, NeoSoft, Inc.  All rights reserved.
#		$Id: client.tcl,v 1.8 1997/06/16 15:19:14 gporter Exp $


proc dump_environment {} {
	global webenv

	html "<pre>"
	html webenv h2
	foreach var [lsort [array names webenv]] {
		html "$var = $webenv($var)\n"
	}
	html "</pre>"
}

proc parray {arrayName} {
	upvar $arrayName localArray

	html "<pre><b>$arrayName</b>\n"
	foreach element [array names localArray] {
		html "$element = $localArray($element)\n"
	}
	html "</pre>"
}

proc backlink {{linktext ""} {nolinktext ""}} {
	global webenv

	if ![info exists webenv(HTTP_REFERER)] {
		return $nolinktext
	}

	if {$linktext == ""} {
		set linktext "Back"
	}
	return "<a href=$webenv(HTTP_REFERER)>$linktext</a>"
}

proc incr_page_counter {} {
	global webenv

	dbfetch pagecounters $webenv(DOCUMENT_URI) accessInfo
	if ![info exists accessInfo(counter)] {
		set accessInfo(counter) 0
	}
	set counter [incr accessInfo(counter)]
	dbstore pagecounters $webenv(DOCUMENT_URI) accessInfo
	return $counter
}

proc random_pick_html {list} {
	return [lindex $list [expr [clock seconds] % [llength $list]]]
}

proc emit_standard_yahoo_link {} {
	html {<a href="http://www.yahoo.com"><img src="http://www.yahoo.com/images/recip.gif" alt="Yahoo!" border=0></a>}
}

proc emit_standard_magellan_search_link {} {
	html {<form method=GET action="http://www.mckinley.com/extsearch.cgi"><IMG SRC="http://images.mckinley.com/img/type.gif" ALIGN=MIDDLE><B>Search for:  </B> <imput type=text name=query size=30 value=""><INPUT type=submit value="Search"> </form>}
}


#
# forms1 - neosoft forms1 manager for neoscript 
#

#
# this package allows you to define forms that will automatically
# fill in the values of the form elements with the contents of an array,
# where the names of the fields are fetched from correspondingly
# named elements of an array.
#
# If there is no corresponding element, a reasonable default
# value is set instead.  (Blank, in most cases.)
#

#
# set_array_defaults arrayName -key value -key value -key value
#
proc set_array_defaults {arrayName args} {
    upvar $arrayName array
    import_keyvalue_pairs array $args
}

#
# neo_form formName "form html parms"
#
proc neo_form {arrayName parms} {
    global neoFormDataName
    set neoFormDataName $arrayName

    html "<form $parms>"
}

#
# neo_form_field type name parms
#
# emit a form entry of
#
proc neo_form_field {type name {parms ""}} {
    global neoFormDataName
    upvar #0 $neoFormDataName data

    if ![info exists data($name)] {
	set data($name) ""
    }

    if {[string match "*value=*" $parms] == 1} {
    html "<input name=\"$name\" type=\"$type\" $parms>"
    } else {
    html "<input name=\"$name\" type=\"$type\" $parms value=\"$data($name)\">"
    }
}

proc neo_form_radiobuttons {name parms values} {
    global neoFormDataName
    upvar #0 $neoFormDataName data
    if ![info exists data($name)] {
	set data($name) ""
    }
    set baseValue $data($name)

    foreach value $values {
	if {$baseValue == $value} {
	    set checked "checked"
	} else {
	    set checked ""
	}
	html "<input name=\"$name\" type=\"radio\" $parms value=\"$value\" $checked>$value"
    }
}

proc neo_form_select {name parms values} {
    global neoFormDataName
    upvar #0 $neoFormDataName data
    if ![info exists data($name)] {
	set data($name) ""
    }
    set baseValue $data($name)

    html "<select name=\"$name\" $parms>"

    foreach value $values {
	if {$baseValue == $value} {
	    set selected "selected"
	} else {
	    set selected ""
	}
	html "<option $selected>$value"
    }
    html "</select>"
}

proc neo_form_checkbox {name {parms ""}}  {
    global neoFormDataName
    upvar #0 $neoFormDataName data
    if ![info exists data($name)] {
	set data($name) "0"
    }

    if ![string match *value=* $parms] {
        append parms " value=\"$data($name)\""
    }

    html "<input name=\"$name\" type=\"checkbox\" $parms>"
}

proc neo_form_textarea {name {parms ""}} {
    global neoFormDataName
    upvar #0 $neoFormDataName data

    if ![info exists data($name)] {
	set data($name) ""
    }
    html "<textarea name=\"$name\" $parms>$data($name)</textarea>"
}

proc neo_form_submit {{text ""}} {
    if {$text == ""} {
	html "<input type=submit>"
    } else {
	html "<input type=submit value=\"$text\">"
    }
}

proc neo_form_reset {{text ""}} {
    if {$text == ""} {
	html "<input type=reset>"
    } else {
	html "<input type=reset value=\"$text\">"
    }
}

proc neo_form_end {} {
    html "</form>"
}

# simply for compatibility
proc load_response {args} {
}
