#
##		db.tcl:  a db-style emulator
### 	Written by George Porter <gporter@neosoft.com>
##		Copyright 1997, NeoSoft, Inc.  All rights reserved.
#		$Id: db.tcl,v 1.3 1997/06/18 01:07:04 gporter Exp $


#dbstore dbName key arrayName
#dbfetch dbName key arrayName
#dbkeys dbName ?pattern?
#dbdelkey dbName key
#dbexists dbName
#dbfiles
#delete_data_file dbName


proc db2file {dbName} {
	# return the filename, else ""
	set userName [get_username]
	return [user2path $userName]
}

proc dbstore {dbName key localList} {
	set file [file join [db2file $dbName] db $dbName.db]

	create_user_dir [get_username] db

	if {[file exists $file]} {
		if {[catch {open $file r} result] == 1} {
			error "1: Error:  opening file $file."
			return ""
		}
		
		if {[catch {open $file.tmp w} tmpFP] == 1} {
			error "2: Error:  opening temporary file $file.tmp"
			return ""
		}

		set i 1

		while {[gets $result line] >= 0} {
			if {[string compare $key [lindex $line 0]] == 0} {
				puts $tmpFP "[list $key] [list $localList]"
				set i 0
			} else {
				puts $tmpFP $line
			}
		}

		if {$i} {
			puts $tmpFP "[list $key] [list $localList]"
		}

		close $result
		close $tmpFP
		file rename -force -- $file.tmp $file

	} else {
		if {[catch {open $file w} result] == 1} {
			error "3: Error:  opening file $file."
			return ""
		}

		puts $result "$key [list $localList]"
		close $result
	}
	return ""	
}

proc dbfetch {dbName key} {
	set file [file join [db2file $dbName] db $dbName.db]

	if {![file exists $file]} {
		return ""	
	}

	if {[catch {open $file r} result] == 1} {
		error "Error:  opening file $file"
		return ""
	}

	while {[gets $result line] >= 0} {
		if {[string compare $key [lindex $line 0]] == 0} {
			close $result
			return [lindex $line 1]
		} else {
			continue	
		}
	}

	close $result
	return ""
}

proc dbkeys {dbName {pattern ""}} {
	set file [file join [db2file $dbName] db $dbName.db]

	if {![file exists $file]} {
		return ""
	}

	if {[catch {open $file r} result] == 1} {
		error "Error:  opening file $file"
		return ""
	}

	set lst ""

	if {$pattern == ""} {
		while {[gets $result line] >= 0} {
			lappend lst [lindex $line 0]
		}
	} else {
		while {[gets $result line] >= 0} {
			if {[string match $pattern [lindex $line 0]]} {
				lappend lst [lindex $line 0]
			}
		}
	}

	close $result
	return $lst
}

proc dbdelkey {dbName key} {
	set file [file join [db2file $dbName] db $dbName.db]

	if {![file exists $file]} {
		return ""
	}

	if {[catch {open $file r} result] == 1} {
		error "Error:  opening file $file"
		return ""
	}

	if {[catch {open $file.tmp w} tmpFP] == 1} {
		error "Error:  opening file $file.tmp"
		return ""
	}

	while {[gets $result line] >= 0} {
		if {[string compare $key [lindex $line 0]] == 0} {
			continue
		} else {
			puts $tmpFP $line
		}
	}

	close $result
	close $tmpFP
	file rename -force -- $file.tmp $file
	return ""
}

proc dbexists {dbName} {
	set file [file join [db2file $dbName] db $dbName.db]

	if {[file exists $file]} {
		return 1
	} else {
		return 0
	}
}

proc dbfiles {} {
	set userName [get_username]
	set dbpath [file join [user2path $userName] db]

	set dbs ""
	set dblist [lsort [glob -nocomplain -- [file join $dbpath *.db]]]

	foreach line $dblist {
		lappend dbs [file rootname [file tail $line]]
	}

	return [list $dbs]
}

proc delete_data_file {dbName} {
	set file [file join [db2file $dbName] db $dbName.db]

	file delete -- $file
}
