#
## 		gui.tcl:  A graphical user interface for NeoWebScript-SA
###		Written by George Porter <gporter@neosoft.com>
##		NeoWebScript-SA.  Copyright 1997 NeoSoft, Inc.  All rights reserved.
# 		$Id: gui.tcl,v 1.7 1997/07/29 14:50:45 gporter Exp $


# Utility procs
proc status {w} {
}

proc roll_hits {host uri} {
	global web_conf
	set w $web_conf(wHandle)
	set w "$w.body"

	$w.hits.4.host.hostent configure -text [$w.hits.3.host.hostent cget -text]
	$w.hits.3.host.hostent configure -text [$w.hits.2.host.hostent cget -text]
	$w.hits.2.host.hostent configure -text [$w.hits.1.host.hostent cget -text]
	$w.hits.1.host.hostent configure -text $host

	$w.hits.4.req.reqent configure -text [$w.hits.3.req.reqent cget -text]
	$w.hits.3.req.reqent configure -text [$w.hits.2.req.reqent cget -text]
	$w.hits.2.req.reqent configure -text [$w.hits.1.req.reqent cget -text]
	$w.hits.1.req.reqent configure -text $uri
}

proc update_clock {w} {
	$w configure -text "[clock format [clock seconds]]"
	after 1000 update_clock $w
}

proc gui_setup_body {w} {
	global web_conf
	frame $w.hits

	foreach entry {1 2 3 4} color {#bcffff #fefe00 #fed2fe #00aafe} {
		frame $w.hits.$entry -background $color
		frame $w.hits.$entry.host
		frame $w.hits.$entry.req

		label $w.hits.${entry}.host.txt -text "$entry:"
		label $w.hits.${entry}.req.txt -text "$entry:"

		label $w.hits.${entry}.host.hostent -width 60 -background $color -relief sunken
		label $w.hits.${entry}.req.reqent -width 60 -background $color -relief sunken

		pack $w.hits.${entry}.host.txt $w.hits.${entry}.host.hostent -side left
		pack $w.hits.${entry}.req.txt $w.hits.${entry}.req.reqent -side left

		pack $w.hits.${entry}.host
		pack $w.hits.${entry}.req
		pack $w.hits.${entry}
	}

	pack $w.hits -side top -fill x
	pack $w

}

proc gui_setup_footer {w} {
	global web_conf _guiShowError

	set _guiShowError 1

	frame $w.top -width 475
	frame $w.bottom -width 475

	frame $w.top.left -width 237
	label $w.top.left.hits -text "Hits: "
	label $w.top.left.numhits -width 15 -textvariable web_conf(numhits)

	frame $w.top.right -width 238
	label $w.top.right.error -text "Show errors: "
	checkbutton $w.top.right.errorchk -variable _guiShowError

	pack $w.top.left.hits $w.top.left.numhits -side left
	pack $w.top.right.error $w.top.right.errorchk -side left
	pack $w.top.left $w.top.right -side left

	label $w.bottom.clk -text "[clock format [clock seconds]]" -justify left
	button $w.bottom.exit -command "exit" -text "EXIT" -background red

	pack $w.top.left -side top -fill x
	pack $w.top.right -side top -fill x
	pack $w.top -side top -fill x

	pack $w.bottom.clk $w.bottom.exit -side left
	pack $w.bottom
	pack $w

}

# procs called from web.tcl
proc gui_init_interface {} {
	global web_conf
	set web_conf(wHandle) ".nws"
	set w $web_conf(wHandle)

	wm withdraw .
	toplevel $w
	wm title $w $web_conf(Server)
	wm geometry $w -0+0

	frame $w.header -width 550
	frame $w.body -width 550 -relief groove
	frame $w.footer -width 550

	# setup header
	if {[catch {image create photo neoimg -file nws.gif -width 350 -height 72} result] == 0} {
		label $w.header.title -image neoimg
		pack $w.header.title -side left
		pack $w.header -side top
	}

	# setup body
	gui_setup_body $w.body

	# setup footer
	gui_setup_footer $w.footer
	update_clock $w.footer.bottom.clk
}

proc gui_sendout_request {socket host uri} {
	global web_conf
	upvar #0 web_$web_conf(currentSock) array
	set w $web_conf(wHandle)

	incr web_conf(numhits)
	roll_hits $host $uri
}

proc gui_finish_session {socket} {
}

proc gui_toplevel_error {socket result} {
	global _guiShowError

	if {$_guiShowError} {
	}
}

proc gui_handle_bgerror {string errorCode errorInfo} {
	global _guiShowError

	if {$_guiShowError} {
		destroy .lab
		label .lab -text $errorInfo -background bisque ; pack .lab
		button .exit -text "Exit" -command exit ; pack .exit
	}	
}

proc gui_handle_document_error {sock errorstr} {
	global _guiShowError errorCode errorInfo

	if {$_guiShowError} {
		set w .errordlg

		destroy .errordlg
		toplevel $w
		wm title $w "NeoWebScript Error"
		wm geometry $w +200+200

		frame $w.t -bd 2 -relief raised
		message $w.t.info -text $errorInfo -background #80ff80

		pack $w.t.info -side top
		pack $w.t -side top -fill x

		frame $w.b -bd 2
		button $w.b.dismiss -command {destroy .errordlg} -text "Dismiss" -background bisque -foreground black
		pack $w.b.dismiss -side top -fill x -expand 1
		pack $w.b -side top -fill x
	}
}
