# Carnet : a simple addressbook written in tcl/tk
# Copyright (C) 1996 Nocera Luciano
# Revision: $Id: accents.tcl,v 1.2 1997/03/11 21:45:40 lnocera Exp $
# State: Exp
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

# insert or remove accentuated characters in a text
#
#
# Use:
# AccentsBind $widget 
# to set bindings for accents a text widget
#
# AccentsUnBind $widget
# to remove bindings for accents on a text widget
#

proc AccentsBind {t} {
    global accents
    
    bindtags $t "[bindtags $t] accents"
    
    AccentsBindCompose
    AccentsBindRemove
}

proc AccentsUnBind {t} {
    global accents
    
    # remove accents form the bindings
    set old [bindtags $t]
    set length [expr [llength $old ] -2]
    set new [lrange $old 0  $length]

    bindtags $t "$new"
}

proc AccentsCompose { w letter } {
    global accents
    
    $w delete "insert -2 char" insert
    $w insert insert $letter
}

proc AccentsRemove { w letter } {
    global accents
    
    $w delete "insert -2 char" insert
    $w insert insert $letter
}

proc AccentsBindCompose {} {
    global accents
    
    #  
    bind accents <A><apostrophe> {AccentsCompose %W "\301"}
    bind accents <E><apostrophe> {AccentsCompose %W "\311"}
    bind accents <I><apostrophe> {AccentsCompose %W "\315"}
    bind accents <O><apostrophe> {AccentsCompose %W "\323"}
    bind accents <U><apostrophe> {AccentsCompose %W "\332"}
    bind accents <Y><apostrophe> {AccentsCompose %W "\335"}
    
    # 
    bind accents <a><apostrophe> {AccentsCompose %W "\341"}
    bind accents <e><apostrophe> {AccentsCompose %W "\351"}
    bind accents <i><apostrophe> {AccentsCompose %W "\355"}
    bind accents <o><apostrophe> {AccentsCompose %W "\363"}
    bind accents <u><apostrophe> {AccentsCompose %W "\372"}
    bind accents <y><apostrophe> {AccentsCompose %W "\375"}

    #  
    bind accents <A><grave> {AccentsCompose %W "\300"}
    bind accents <E><grave> {AccentsCompose %W "\310"}
    bind accents <I><grave> {AccentsCompose %W "\314"}
    bind accents <O><grave> {AccentsCompose %W "\322"}
    bind accents <U><grave> {AccentsCompose %W "\331"}
    
    # 
    bind accents <a><grave> {AccentsCompose %W "\340"}
    bind accents <e><grave> {AccentsCompose %W "\350"}
    bind accents <i><grave> {AccentsCompose %W "\354"}
    bind accents <o><grave> {AccentsCompose %W "\362"}
    bind accents <u><grave> {AccentsCompose %W "\371"}

    # 
    bind accents <A><quotedbl> {AccentsCompose %W "\304"}
    bind accents <E><quotedbl> {AccentsCompose %W "\313"}
    bind accents <I><quotedbl> {AccentsCompose %W "\317"}
    bind accents <O><quotedbl> {AccentsCompose %W "\326"}
    bind accents <U><quotedbl> {AccentsCompose %W "\334"}

    # 
    bind accents <a><quotedbl> {AccentsCompose %W "\344"}
    bind accents <e><quotedbl> {AccentsCompose %W "\353"}
    bind accents <i><quotedbl> {AccentsCompose %W "\357"}
    bind accents <o><quotedbl> {AccentsCompose %W "\366"}
    bind accents <u><quotedbl> {AccentsCompose %W "\374"}
    bind accents <y><quotedbl> {AccentsCompose %W "\377"}

    # 
    bind accents <C><comma> {AccentsCompose %W "\307"}
    bind accents <c><comma> {AccentsCompose %W "\347"}

    # 
    # bind accents <A><ring> {AccentsCompose %W "\305"}
    # bind accents <a><ring> {AccentsCompose %W "\345"}

    # 
    bind accents <A><asciicircum> {AccentsCompose %W "\302"}
    bind accents <E><asciicircum> {AccentsCompose %W "\312"}
    bind accents <I><asciicircum> {AccentsCompose %W "\316"}
    bind accents <O><asciicircum> {AccentsCompose %W "\324"}
    bind accents <U><asciicircum> {AccentsCompose %W "\333"}

    # 
    bind accents <a><asciicircum> {AccentsCompose %W "\342"}
    bind accents <e><asciicircum> {AccentsCompose %W "\352"}
    bind accents <i><asciicircum> {AccentsCompose %W "\356"}
    bind accents <o><asciicircum> {AccentsCompose %W "\364"}
    bind accents <u><asciicircum> {AccentsCompose %W "\373"}

    #  
    bind accents <N><asciitilde> {AccentsCompose %W "\321"}
    bind accents <n><asciitilde> {AccentsCompose %W "\361"}
}

proc AccentsBindRemove {} {
    global accents
    
    # remove accents
    
    #  
    bind accents <A><apostrophe><apostrophe> {AccentsRemove %W "A'"}
    bind accents <E><apostrophe><apostrophe> {AccentsRemove %W "E'"}
    bind accents <I><apostrophe><apostrophe> {AccentsRemove %W "I'"}
    bind accents <O><apostrophe><apostrophe> {AccentsRemove %W "O'"}
    bind accents <U><apostrophe><apostrophe> {AccentsRemove %W "U'"}
    bind accents <Y><apostrophe><apostrophe> {AccentsRemove %W "Y'"}
    
    # 
    bind accents <a><apostrophe><apostrophe> {AccentsRemove %W "a'"}
    bind accents <e><apostrophe><apostrophe> {AccentsRemove %W "e'"}
    bind accents <i><apostrophe><apostrophe> {AccentsRemove %W "i'"}
    bind accents <o><apostrophe><apostrophe> {AccentsRemove %W "o'"}
    bind accents <u><apostrophe><apostrophe> {AccentsRemove %W "u'"}
    bind accents <y><apostrophe><apostrophe> {AccentsRemove %W "y'"}

    #  
    bind accents <A><grave><grave> {AccentsRemove %W "A`"}
    bind accents <E><grave><grave> {AccentsRemove %W "E`"}
    bind accents <I><grave><grave> {AccentsRemove %W "I`"}
    bind accents <O><grave><grave> {AccentsRemove %W "O`"}
    bind accents <U><grave><grave> {AccentsRemove %W "U`"}
    
    # 
    bind accents <a><grave><grave> {AccentsRemove %W "a`"}
    bind accents <e><grave><grave> {AccentsRemove %W "e`"}
    bind accents <i><grave><grave> {AccentsRemove %W "i`"}
    bind accents <o><grave><grave> {AccentsRemove %W "o`"}
    bind accents <u><grave><grave> {AccentsRemove %W "u`"}

    # 
    bind accents <A><quotedbl><quotedbl> {AccentsRemove %W "A\""}
    bind accents <E><quotedbl><quotedbl> {AccentsRemove %W "E\""}
    bind accents <I><quotedbl><quotedbl> {AccentsRemove %W "I\""}
    bind accents <O><quotedbl><quotedbl> {AccentsRemove %W "O\""}
    bind accents <U><quotedbl><quotedbl> {AccentsRemove %W "U\""}

    # 
    bind accents <a><quotedbl><quotedbl> {AccentsRemove %W "a\""}
    bind accents <e><quotedbl><quotedbl> {AccentsRemove %W "e\""}
    bind accents <i><quotedbl><quotedbl> {AccentsRemove %W "i\""}
    bind accents <o><quotedbl><quotedbl> {AccentsRemove %W "o\""}
    bind accents <u><quotedbl><quotedbl> {AccentsRemove %W "u\""}
    bind accents <y><quotedbl><quotedbl> {AccentsRemove %W "y\""}

    # 
    bind accents <C><comma><comma> {AccentsRemove %W "C,"}
    bind accents <c><comma><comma> {AccentsRemove %W "c,"}

    # 
    # bind accents <A><ring> {AccentsCompose %W "A"}
    # bind accents <a><ring> {AccentsCompose %W "a="}

    # 
    bind accents <A><asciicircum><asciicircum> {AccentsRemove %W "A^"}
    bind accents <E><asciicircum><asciicircum> {AccentsRemove %W "E^"}
    bind accents <I><asciicircum><asciicircum> {AccentsRemove %W "I^"}
    bind accents <O><asciicircum><asciicircum> {AccentsRemove %W "O^"}
    bind accents <U><asciicircum><asciicircum> {AccentsRemove %W "U^"}

    # 
    bind accents <a><asciicircum><asciicircum> {AccentsRemove %W "a^"}
    bind accents <e><asciicircum><asciicircum> {AccentsRemove %W "e^"}
    bind accents <i><asciicircum><asciicircum> {AccentsRemove %W "i^"}
    bind accents <o><asciicircum><asciicircum> {AccentsRemove %W "o^"}
    bind accents <u><asciicircum><asciicircum> {AccentsRemove %W "u^"}

    #  
    bind accents <N><asciitilde><asciitilde> {AccentsRemove %W "N~"}
    bind accents <n><asciitilde><asciitilde> {AccentsRemove %W "n~"}
}

 