# Carnet : a simple addressbook written in tcl/tk
# Copyright (C) 1996 Nocera Luciano
# Revision: $Id: app.tcl,v 1.3 1997/03/14 18:09:19 lnocera Exp lnocera $
# State: Exp
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

proc Init {} {
    # initialize carnet
    global INTERNAL CONFIG RECORD
    
    # create and pack the menubar
    set mf [frame .$INTERNAL(NAME) -class "$INTERNAL(NAME)"]
    pack [CommandFrame .$INTERNAL(NAME)] -side top -fill x
    # the log bar
    pack [LogFrame $mf] -fill x
    # the dataframe
    set f [frame $mf.data -relief raised -bd 2 -height 5]
    pack [DataFrame  $f] [SearchFrame $f] [AlphaFrame $f] \
	-padx 2 -pady 2 -fill both -side left -expand true
    pack $f -expand true -fill both
    # the button frame
    ToolFrame $mf
    ToggleLogBar
    ToggleAlphaBar
    ToggleTollBar
    ToggleXScrollBar
    ToggleYScrollBar
    # bindings on .
    bind . <Alt-r> {focus $RECORD(NAME)}
    bind . <Alt-d> {DeleteRecord}
    bind . <Alt-c> {ResetRecord}
    bind . <Alt-u> {Update}
    bind . <Alt-s> {Save 1}
    bind . <Alt-l> {ClearAndSearch}

    # same bindings on meta key
    bind . <Meta-r> {focus $RECORD(NAME)}
    bind . <Meta-d> {DeleteRecord}
    bind . <Meta-c> {ResetRecord}
    bind . <Meta-u> {Update}
    bind . <Meta-s> {Save 1}
    bind . <Meta-l> {ClearAndSearch}
    pack $mf -expand true -fill both
}

proc ToolFrame {p} {
    # the log frame 
    global RECORD SEARCH CONFIG INTERNAL
    
    set f [frame $p.toolbar -relief raised -bd 2]
    button $f.update -text "Insert/Update" -underline 7 -command {Update}
    button $f.delete -text "Delete Current" -underline 0 -command {DeleteRecord}
    button $f.clear -text "New" -underline 0 -command {ResetRecord}
    button $f.select -text "Select" -underline 2 -command { ClearAndSearch }
    button $f.save -text "Save Database" -underline 0 -command {Save 1}
    pack $f.select $f.clear $f.update $f.delete $f.save -side left -expand true
    return $f
}

proc ToggleTollBar {} {
    global CONFIG

    if { $CONFIG(TOOLBAR_ON) } { 
	pack .carnet.toolbar -fill x
    } else { 
	pack forget .carnet.toolbar
	.carnet.toolbar config -height 0
    }
}

proc LogFrame {p} {
    global RECORD SEARCH CONFIG INTERNAL
    
    set f [frame $p.logbar -relief raised -bd 2 -width 40]
    message $f.message -justify left -width 800 -textvariable INTERNAL(MESSAGE)
    message $f.title -justify left -width 800 -textvariable INTERNAL(TITLE)
    pack $f.message -side right
    pack $f.title -side left
    return $f
}

proc ToggleXScrollBar {} {
    global CONFIG
    
    wm geometry . ""
    if { $CONFIG(XSCROLLBAR_ON) } {
	foreach i {name company email phone address notes} {
	    pack .carnet.data.data.$i.$i.xscroll -side bottom -fill x
	}
	foreach i {phone address notes} {
	    .carnet.data.data.$i.$i.text config -wrap none
	}
    } else {
	foreach i {name company email phone address notes} {
	    pack forget .carnet.data.data.$i.$i.xscroll
	}
	foreach i {phone address notes} {
	    .carnet.data.data.$i.$i.text config -wrap word
	}
    }
}

proc ToggleYScrollBar {} {
    global CONFIG
    
    wm geometry . ""
    if { $CONFIG(YSCROLLBAR_ON) } {
	foreach i {phone address notes} {
	    pack .carnet.data.data.$i.$i.yscroll.yscroll -fill y -expand true
	}
    } else {
	foreach i {phone address notes} {
	    pack forget .carnet.data.data.$i.$i.yscroll.yscroll
	    .carnet.data.data.$i.$i.yscroll config -width 1
	}
    }
}

proc ToggleLogBar {} {
    global CONFIG
    
    wm geometry . ""
    if { $CONFIG(LOGBAR_ON) } {
	pack .carnet.logbar.message  -side left
	pack .carnet.logbar.title -side right
    } else {
	pack forget .carnet.logbar.message
	pack forget .carnet.logbar.title
	.carnet.logbar config -height 1
    }
}

proc AlphaFrame {p} {
    # the log frame 
    global RECORD 
    
    wm geometry . ""
    set f [frame $p.alphabar -relief raised -bd 2 -height 5]
    set f1 [frame $f.f1]
    foreach i {a b c d e f g h i j k l m} {
	button $f1.$i -text "$i" -command "SearchRecord exact $i" \
	    -width 1 -height 1
	pack $f1.$i -side top -expand true -fill both
    }
    set f2 [frame $f.f2]
    foreach i {n o p q r s t u v w x y z} {
	button $f2.$i -text "$i" -command "SearchRecord exact $i" \
	    -width 1 -height 1
	pack $f2.$i -side top -expand true -fill both
    }
    pack $f1 $f2 -side left -expand true -fill both
    return $f
}

proc ToggleAlphaBar {} {
    global CONFIG
    
    wm geometry . ""
    if { $CONFIG(ALPHABAR_ON) } {
	pack .carnet.data.alphabar -padx 2 -pady 2 -side right -fill both -expand true
    } else {
	pack forget .carnet.data.alphabar
    }
}

proc CommandFrame {p} {
    # the menubar
    global RECORD SEARCH COMMAND INTERNAL
    
    set f [frame $p.$INTERNAL(NAME)command -relief raised -bd 2]
    set COMMAND(FRAME) $f
    menubutton $f.file -text File -underline 0
    $f.file config -menu [MenuFile  $f.file.m]
    menubutton $f.edit -text Record -underline 0
    $f.edit config -menu [MenuEdit $f.edit.m]
    menubutton $f.database -text Database -underline 1
    $f.database config -menu [MenuDatabase $f.database.m]
    menubutton $f.options -text Options -underline 0
    $f.options config -menu [MenuOptions $f.options.m]
    menubutton $f.tools -text Tools -underline 0
    $f.tools config -menu [MenuTools $f.tools.m]
    menubutton $f.help -text Help -underline 0
    $f.help config -menu [MenuHelp $f.help.m]
    pack $f.file $f.edit $f.database $f.options $f.tools \
	-side left -fill x -padx 10
    pack $f.help -side right -padx 10
    return $f
}

proc SearchFrame {p} {
    # the search frame
    global RECORD SEARCH CONFIG
    
    set w0 [expr $CONFIG(LIST_WIDTH) - 8]
    set w1 $CONFIG(LIST_WIDTH)
    set h2 13
    set f [frame $p.search -relief raised -bd 2 -height 5]
    set SEARCH(FRAME) $f
    set sel [frame $f.sel]
    set SEARCH(ENTRY_BUTTON) [button  $sel.select -text "Select : " \
				  -underline 2 -command { SearchRecord }]
    set SEARCH(ENTRY) [text $sel.entry -width $w0 -height 1]
    pack $sel.select $sel.entry -side left -fill x
    frame $f.search
    set SEARCH(LIST) [listbox $f.search.search -width $w1 -height $h2\
			  -selectmode single \
			  -yscrollcommand [list $f.search.yscroll set]]
    scrollbar $f.search.yscroll -orient vertical \
	-command [list $f.search.search yview]
    pack $f.search.yscroll -side right -fill y -expand true
    pack $f.search.search -side left -fill y -expand true
    pack $sel -side top -fill y
    pack $f.search -fill y -expand true
    bind $SEARCH(ENTRY) <Tab>      {SearchRecord ; break}
    bind $SEARCH(ENTRY) <Return>   {SearchRecord ; break} ;# act as an entry
    bind $SEARCH(ENTRY) <Control-Tab>     {continue}
    bind $SEARCH(ENTRY) <Shift-Tab>     {continue}
    bindtags $SEARCH(ENTRY) "[bindtags $SEARCH(ENTRY)] isearch"
    bind isearch <Alt-c>           {ResetRecord}
    bind isearch <Tab>             {break}
    bind $SEARCH(LIST)  <space>   { ShowRecordUsingLabel }
    bind $SEARCH(LIST) <Double-1> { ShowRecordUsingLabel }
    bind $SEARCH(LIST) <Button-1> {focus $SEARCH(LIST)}
    if { $CONFIG(USE_ACCENTS) } {
	AccentsBind $SEARCH(ENTRY) ;# accents
    }
    return $f
}

proc XDataEntry {name p} {
    global CONFIG
    
    set w0 8
    set w2 $CONFIG(ENTRY_WIDTH)

    set type [string tolower $name]
    
    set f [frame $p.$type -bd 2 -relief raised]
    set f1 [frame $f.$type]
    label $f.label -text $name -width $w0 -anchor e
    text $f1.text -width $w2 -height 1 -wrap none \
	-xscrollcommand [list $f1.xscroll set]
    scrollbar $f1.xscroll -orient horizontal -command [list $f1.text xview]
    pack $f.label -side left
    pack $f1.xscroll -side bottom -fill x
    pack $f1.text -fill x -expand true
    pack $f1 -fill x -expand true

    return $f
}

proc XYDataEntryS {name p} {
    global CONFIG

    set w0 8
    set w2 $CONFIG(ENTRY_WIDTH)
    set w3 $CONFIG(ENTRY_HEIGHT)
    
    set type [string tolower $name]
    
    set f [frame $p.$type -bd 2 -relief raised]
    set f1 [frame $f.$type]
    label $f.label -text $name -width $w0 -anchor e
    text $f1.text -width $w2 -height $w3 -wrap none\
	-yscrollcommand [list $f1.yscroll.yscroll set] \
	-xscrollcommand [list $f1.xscroll set]
    scrollbar $f1.xscroll -orient horizontal -command [list $f1.text xview]
    frame $f1.yscroll
    scrollbar $f1.yscroll.yscroll -orient vertical -command [list $f1.text yview]
    pack $f.label -side left
    pack $f1.xscroll -side bottom -fill x
    pack $f1.yscroll.yscroll -fill y -expand true
    pack $f1.yscroll -side right -fill y -expand true
    pack $f1.text -fill both -expand true
    pack $f1 -fill both -expand true
    return $f
}

proc XYDataEntry {name p} {
    global CONFIG

    set w0 8
    set w2 $CONFIG(ENTRY_WIDTH)
    set w3 $CONFIG(ENTRY_HEIGHT)
    
    set type [string tolower $name]
    
    set f [frame $p.$type -bd 2 -relief raised]
    set f1 [frame $f.$type]
    label $f.label -text $name -width $w0 -anchor e
    text $f1.text -width $w2 -height $w3 -wrap none \
	-yscrollcommand [list $f1.yscroll.yscroll set] \
	-xscrollcommand [list $f1.xscroll set]
    scrollbar $f1.xscroll -orient horizontal -command [list $f1.text xview]
    frame $f1.yscroll
    scrollbar $f1.yscroll.yscroll -orient vertical -command [list $f1.text yview]
    pack $f.label -side left
    pack $f1.xscroll -side bottom -fill x
    pack $f1.yscroll.yscroll -fill y -expand true
    pack $f1.yscroll -side right -fill y
    pack $f1.text -fill both -expand true
    pack $f1 -fill both -expand true
    return $f
}

proc DataFrame {p} {
    # the data frame
    global RECORD SEARCH INTERNAL CONFIG
    
    set w0 8
    
    set f [frame $p.data]
    set one [XDataEntry "Name" $f]
    set RECORD(NAME) $one.name.text
    set two [XDataEntry "Company" $f]
    set RECORD(COMPANY) $two.company.text
    set three [XDataEntry "Email" $f]
    set RECORD(EMAIL) $three.email.text
    
    set four [XYDataEntry "Phone" $f]
    set RECORD(PHONE) $four.phone.text
    set five [XYDataEntry "Address" $f]
    set RECORD(ADDRESS) $five.address.text
    set six [XYDataEntry "Notes" $f]
    set RECORD(NOTES) $six.notes.text

    set seven [frame $f.private -bd 2 -relief raised]
    set RECORD(LABEL_PRIVATE) [label $seven.label \
				   -text "Private" -width $w0 -anchor e]
    checkbutton $seven.private -variable RECORD(PRIVATE)
    pack $seven.label $seven.private -side left 
    set RECORD(EXTERNAL) [label $seven.label2 -text "" -width $w0]
    pack $seven.label2 -side right

    pack $one $two $three $four $five $six $seven -fill both -expand true
    
    # force NAME COMPANY EMAIL to be restricted to 1 line
    foreach i {NAME COMPANY EMAIL} {bind $RECORD($i) <Return> { break ;}}
    # accents 
    if { $CONFIG(USE_ACCENTS) } {
	foreach i {NAME COMPANY EMAIL \
		       PHONE ADDRESS NOTES} {
	    AccentsBind $RECORD($i)
	}
    }
    return $f
}

proc MenuFile {name} {
    # the file menu in the menubar
    set m [menu $name]
    $m add command -label "save database\t" -command {Save 1} -underline 0
    $m add command -label "print...\t" -command {Print} -underline 0
    $m add command -label "load external...\t" -command {
	set BROWSE(TITLE) "Select a database file to load"
	set BROWSE(NAME) "$INTERNAL(NAME): Load External"
	set file [BrowseInit]
	if { $file != {}} { Load "external" $file }} -underline 0
    $m add command -label "incorporate...\t" -command {
	set BROWSE(TITLE) "Select a database file to incorporate"
	set BROWSE(NAME) "$INTERNAL(NAME): Incorporate"
	set file [BrowseInit]
	if { $file != {}} {
	    Load "public" $file
	    set INTERNAL(SAVE) 1
	}} -underline 0
    $m add command -label "reload\t" -command {Reload} -underline 0
    $m add command -label "backup\t" -command {Backup} -underline 0
    $m add separator
    # $m add command -label "exit\t" -command {Exit} -underline 0
    $m add command -label "quit\t" -command {Quit} -underline 0
    return $m
}

proc MenuOptions {name} {
    # the option menu in the menubar
    global INTERNAL CONFIG
    
    set m [menu $name]
    $m add command -label "preferences..." -command "Preferences" 
    $m add cascade -label "appearance..." -menu $m.m
    $m add command -label "anniversaries..." \
	-command "ScheduleAnniversaries" 
    # submenu List
    set sm [menu $name.m]
    $sm add command -label "entry size..." -command "EntriesSize"
    $sm add separator
    $sm add checkbutton -command { ToggleXScrollBar } \
	-variable CONFIG(XSCROLLBAR_ON) -label "toggle horizontal scrollbars"
    $sm add checkbutton -command { ToggleYScrollBar } \
	-variable CONFIG(YSCROLLBAR_ON) -label "toggle vertical scrollbars"
    $sm add separator
    $sm add checkbutton -command { ToggleTollBar } \
	-variable CONFIG(REMEMBER_GEOMETRY) -label "remeber placement"
    $sm add checkbutton -command { ToggleTollBar } \
	-variable CONFIG(TOOLBAR_ON) -label "toggle tool bar on/off"
    $sm add checkbutton -command { ToggleLogBar } \
	-variable CONFIG(LOGBAR_ON) -label "toggle log bar on/off"
    $sm add checkbutton -command { ToggleAlphaBar } \
	-variable CONFIG(ALPHABAR_ON) -label "toggle alphabet bar on/off"
    return $m
}
proc MenuTools {name} {
    # the option menu in the menubar
    global INTERNAL CONFIG
    
    set m [menu $name]
    $m add command -label "mail" -command "InvokeMail {}" 
    $m add command -label "finger" \
	-command "StartMe {Finger} {Email:} InvokeFinger" 
    $m add command -label "open url" \
	-command "StartMe {Browse URL} {Open Location:} InvokeBrowser" 
    $m add command -label "open ftp" \
	-command "StartMe {Open Ftp} {Ftp:} InvokeFtp"
    $m add command -label "open file" \
	-command "StartMe {Open File} {File:} InvokeEditor"
    $m add command -label "dial number" \
	-command "StartMe {Dial number} {Phone Number:} InvokePhone"
    return $m
}
proc MenuEdit {name} {
    # the edit menu in the menubar
    set m [menu $name]
    $m add command -label "new\t" -command {ResetRecord} -underline 0
    $m add command -label "insert/update\t" -command {Update} -underline 7
    $m add command -label "delete current\t" -command {DeleteRecord} -underline 0
    $m add command -label "select\t" -command {ClearAndSearch} -underline 2
    return $m
}
proc MenuHelp {name} {
    global INTERNAL
    set m [menu $name]
    $m add command -label "about $INTERNAL(NAME)..." -command {Help about}
    $m add command -label "$INTERNAL(NAME) WWW Page" \
	-command {InvokeBrowser $INTERNAL(WWW_HOME_PAGE)}
    $m add command -label "warranty..." -command {Help warranty}
    $m add command -label "license..." -command {Help license}
    $m add separator
    $m add command -label "demo..." -command { ShowDemo }
    $m add cascade -label "info on..." -menu $m.info
    
    # submenu
    set sm [menu $name.info]
    $sm add command -label "context..." -command {Help context}
    $sm add command -label "highlight..." -command {Help highlight}
    $sm add command -label "bindings..." -command {Help keys}
    $sm add command -label "accents..." -command {Help accents}
    $sm add command -label "customization..." -command {Help customization}
    $sm add command -label "import..." -command {Help import}
    $sm add command -label "backup..." -command {Help backup}
    
    $m add separator
    $m add command -label "send bug report" \
	-command {SimpleMail $INTERNAL(MAINTAINER_MAIL) \
		      "$INTERNAL(NAME) BUG REPORT"}
    return $m
}
proc MenuDatabase {name} {
    set m [menu $name]
    $m add radiobutton -variable INTERNAL(DATABASE) -label "all" \
	-command {
	    ClearRecord
	    SearchRecord
	}
    $m add radiobutton -variable INTERNAL(DATABASE) -label "public" \
	-command {
	    ClearRecord
	    SearchRecord
	}
    $m add radiobutton -variable INTERNAL(DATABASE) -label "private" \
	-command {
	    ClearRecord
	    SearchRecord
	}
    $m add radiobutton -variable INTERNAL(DATABASE) -label "external" \
	-command {
	    ClearRecord
	    SearchRecord
	}
    return $m
}
# eof