# Carnet : a simple addressbook written in tcl/tk
# Copyright (C) 1996 Nocera Luciano
# Revision: $Id: proc.tcl,v 1.3 1997/03/14 18:09:19 lnocera Exp lnocera $
# State: Exp
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

#
# 
#######################################################################
# patch for exmh: create a button "addCarnet". When a mail is 
# displayed scan the file for the From: field and write the name to 
# ~/.carnet/import

#
# usage : just manage to source this code in exmh... I tried to do it 
# properly but I failed :^) If you find it out let me know. For the
# moment I've copied exmh in my home directory and added 
#
# souce "path/carnet-exmh.tcl" at the end of the file
#
# where path is the path to carnet-exmh.tcl!
#

set carnet_import_dir [glob "~/"]
set carnet_import_dir "$carnet_import_dir.carnet/import"
set carnet_button_name "addCarnet"
proc Mh_PrintMailInfo {} {
    global exmh msg mhProfile carnet_import_dir

    if [MsgOk $msg(id) m] {
	if {[catch {glob $mhProfile(path)/$exmh(folder)/$msg(id)} file] \
		== 0} {
	    if [catch {exec egrep "^From:" $file | head -1} \
		    from] {
		Exmh_Status "Can't parse From field in mail."
		return
	    }
	} else {
	    Exmh_Status "Can't read mail."
	    return
	}
	
	if { $from != "" } {
	    # nuke the From:
	    regsub "^From:" $from "" from
	    # write to .carnet/import
	    if {[catch {
		exec echo $from | cat >> $carnet_import_dir } \
		     err]} {
		Exmh_Status "Can't write in ~/.carnet/import. $err "
	    } else {
		Exmh_Status "carnet: imported $from."
	    }
	}
    } else {
	Exmh_Status "Select a message first."
	return
    }
}
# this is to wait fot the window to be created
after 100 {
    set b [button .mid.right.bot.carnet]
    pack .mid.right.bot.carnet
    $b config -text $carnet_button_name -command "Mh_PrintMailInfo"
}
