;;; -*- Mode:Emacs-Lisp -*-

;;; Adapted from BBDB by Jamie Zawinski for carnet. Thanks Jamie!

;;; This file is part of the Insidious Big Brother Database (aka BBDB),
;;; copyright (c) 1991, 1992 Jamie Zawinski <jwz@netscape.com>.
;;; Interface to RMAIL.  See bbdb.texinfo.
;;; last change  8-sep-92.

;;; The Insidious Big Brother Database is free software; you can redistribute
;;; it and/or modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 1, or (at your
;;; option) any later version.
;;;
;;; BBDB is distributed in the hope that it will be useful, but WITHOUT ANY
;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
;;; FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
;;; details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Emacs; see the file COPYING.  If not, write to
;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;; load this file from within xemacs:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; rmail hack a la bbdb for carnet
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; (load-file (expand-file-name "/somepath/carnet-rmail.el"))
;; (carnet-insinuate-vm)
;; 
;; or 
;; 
;; (require 'carnet-vm)
;; (carnet-insinuate-vm)
;;
;; depending on if carnet-vm.el is in your emacs lisp path.
;; then use ":" to insert the name/email in the database

(require 'rmail)
(if (not (fboundp 'rmail-make-summary-line)) (load-library "rmailsum"))

(defvar carnet-import-dir "~/.carnet/import")
(defvar mailrc-file "~/.mailrc")

(defun carnet/rmail-update-record ()
  "returns the record corresponding to the current RMAIL message, creating or
modifying it as necessary.  A record will be created if 
bbdb/mail-auto-create-p is non-nil, or if OFFER-TO-CREATE is true and
the user confirms the creation."
  (if (and (boundp 'rmail-buffer) rmail-buffer)
      (set-buffer rmail-buffer))
  (if rmail-current-message
      (save-excursion
	(let ((from (mail-fetch-field "from")) name net)
	  (if from
	      (progn
		(shell-command
		 (format "echo \"%s\" | cat >> %s"
			 (mail-fetch-field "from")
			 carnet-import-dir))
		(message "%s imported into carnet" (mail-fetch-field "from"))))))))

(defun carnet/get-record ()
  (interactive)
  (carnet/rmail-update-record))

(defun carnet-insinuate-rmail ()
  "Call this function to hook CARNET into RMAIL."
  
  (define-key rmail-mode-map ":" 'carnet/get-record))

(provide 'carnet-rmail)
