;;; -*- Mode:Emacs-Lisp -*-

;;; Adapted from BBDB by Jamie Zawinski for carnet. Thanks Jamie!

;;; This file is part of the Insidious Big Brother Database (aka BBDB),
;;; copyright (c) 1991, 1992 Jamie Zawinski <jwz@netscape.com>.
;;; Interface to RMAIL.  See bbdb.texinfo.
;;; last change  8-sep-92.

;;; The Insidious Big Brother Database is free software; you can redistribute
;;; it and/or modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 1, or (at your
;;; option) any later version.
;;;
;;; BBDB is distributed in the hope that it will be useful, but WITHOUT ANY
;;; WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
;;; FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
;;; details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Emacs; see the file COPYING.  If not, write to
;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;; load this file from within xemacs:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; vm hack a la bbdb for carnet
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; (load-file (expand-file-name "/somepath/carnet-vm.el"))
;; (carnet-insinuate-vm)
;; 
;; or 
;; 
;; (require 'carnet-vm)
;; (carnet-insinuate-vm)
;;
;; depending on if carnet-vm.el is in your emacs lisp path.
;; then use ":" to insert the name/email in the database

(require 'vm)
(if (not (fboundp 'vm-record-and-change-message-pointer))
    (load-library "vm-motion"))
(if (not (fboundp 'vm-su-from))
    (load-library "vm-summary"))
(or (boundp 'vm-mode-map)
    (load-library "vm-vars"))

(defvar carnet-import-dir "~/.carnet/import")
(defvar carnet-user-mail-names nil
  "*A regular expression identifying the addresses that belong to you.
If a message from an address matching this is seen, the BBDB record for
the To: line will be shown instead of the one for the From: line.  If
this is nil, it will default to the value of (user-login-name).")

(defmacro carnet-user-mail-names ()
  "Returns a regexp matching the address of the logged-in user"
  '(or carnet-user-mail-names
    (setq carnet-user-mail-names
     (concat "\\b" (regexp-quote (user-login-name)) "\\b"))))

(defun carnet/vm-get-from (msg)
  (setq msg (vm-real-message-of msg))
  ;; Unfortunately the first arm of this if doesn't work because VM gloms
  ;; the various names and addresses of multi-recipient messages together
  ;; into one un-extractable mess.  We could use just the parts before the
  ;; first comma in each string, but that loses when a user has a comma in
  ;; their name ("Jr." etc).
    ;; Bad, VM isn't using mail-extr, so we need to find the folder buffer
    ;; and parse out the From: field ourselves...
    (save-excursion
      (save-restriction
	;; Select the buffer containing the message.
	;; Needed to handle VM virtual folders.
	(set-buffer (vm-buffer-of msg))
	(widen)
	(narrow-to-region (vm-start-of msg) (vm-end-of msg))
	(let ((from (mail-fetch-field "from")))
	  (if (or (null from)
		  (string-match (carnet-user-mail-names)
				;; mail-strip-quoted-names is too broken!
				;;(mail-strip-quoted-names from)
				(or (car (cdr (mail-extract-address-components
					       from)))
				    "")))
	      ;; if logged in user sent this, use recipients.
	      (setq from (or (mail-fetch-field "to") from)))
	  from)))
;    )
  )

(defun carnet/vm-update-record ()
  "Returns the record corresponding to the current VM message, 
creating or modifying it as necessary.  A record will be created if 
bbdb/mail-auto-create-p is non-nil, or if OFFER-TO-CREATE is true and
the user confirms the creation."
  (save-excursion
    (vm-select-folder-buffer)
    (vm-check-for-killed-summary)
    (vm-error-if-folder-empty)
    (let ((msg (car vm-message-pointer))
	  (inhibit-local-variables nil) ; vm binds this to t...
	  (enable-local-variables t)    ; ...or vm bind this to nil.
	  (inhibit-quit nil))  ; vm damn well better not bind this to t!
      ;; this doesn't optimize the case of moving thru a folder where
      ;; few messages have associated records.
      ;; (or (bbdb-message-cache-lookup msg nil) ; nil = current-buffer
      (and msg
	   (let ((from (carnet/vm-get-from msg)))
	     (if from
		 (progn
		   (shell-command
		    (format "echo \"%s\" | cat >> %s"
			    from
			    carnet-import-dir))
		   (message "%s imported into carnet" from))))))))

(defun carnet/get-record ()
  (interactive)
  (carnet/vm-update-record))

(defun carnet-insinuate-vm ()
  "Call this function to hook CARNET into VM."
  (define-key vm-mode-map ":" 'carnet/get-record))

(provide 'carnet-vm)
