# Carnet : a simple addressbook written in tcl/tk
# Copyright (C) 1996 Nocera Luciano
# Revision: $Id: simplemail.tcl,v 1.1 1997/03/11 21:38:49 lnocera Exp $
# State: Exp
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

# how to handle errors

set ErrorIgnore {
    { {^grab failed} {^bad window} }
}
proc tkerror { msg } {
    global errorInfo INTERNAL ErrorIgnore

    foreach pat $ErrorIgnore {
	if [regexp $pat $msg] {
	    puts $msg
	    return
	}
    }
    set font fixed
    set base ".errorInfo"
    set title "Error Info"
    if [info exists errorInfo] {
	set savedErrorInfo $errorInfo
    } else {
	set savedErrorInfo {no errorInfo}
    }
    if {[string length $savedErrorInfo] > 20} {
	set msg [concat [string range $msg 0 60] ...]
    }
    if [catch {
	if { [tk_dialog .delete Error "Error: $msg" \
		  error 0 "Dismiss" \
		  "Mail to $INTERNAL(MAINTAINER_MAIL)"] } {
	    if [info exists INTERNAL(MAINTAINER_MAIL)] {
		SimpleMail $INTERNAL(MAINTAINER_MAIL) \
		    "CARNET BUG REPORT" \
		    {} {} "$savedErrorInfo
_____________________

If any add comments here after: 
"
	    }
	}
    } oops] {
	set msg [concat $msg "($name: " $oops ")" ]
   }

    if {[string length $msg] > 20} {
	set msg [concat [string range $msg 0 30] ...]
    }
#     if [catch {tkerror $msg}] {
# 	puts stderr "tkrror: $msg"
# 	puts stderr "*** TCL Trace ***"
# 	puts stderr $savedErrorInfo
#     }
}


