# Carnet : a simple addressbook written in tcl/tk
# Copyright (C) 1996 Nocera Luciano
# Revision: $Id: ext.tcl,v 1.2 1997/03/11 21:45:40 lnocera Exp $
# State: Exp
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

proc Preferences {} {
    
    global FORMAT CONFIG RECORD INTERNAL
    global valprefs
    
    if [winfo exists .preferences] {
	focus .preferences
    } else {
	toplevel .preferences

	wm resizable .preferences 0 0
	wm title .preferences "$INTERNAL(NAME) preferences"
	wm iconname .preferences "$INTERNAL(NAME) preferences"
	
	# the title
	set f [frame .preferences.title -relief raised -bd 2]
	label $f.label -text "Preferences"
	pack $f.label -fill x -pady 5 -padx 5
	pack $f -fill x

	# save
	set f [frame .preferences.save -relief raised -bd 2]
	label $f.label -text "Save" -width 20
	checkbutton $f.val -variable CONFIG(AUTOSAVE) -text "Autosave"
	scale $f.scale -orient horizontal -length 100 -from 1 -to 5 \
	    -variable CONFIG(BACKUP_LEVEL) -label "Backup Level"
	pack $f.label -side left -anchor e -pady 5 -padx 5
	pack $f.val $f.scale -side left -pady 5 -padx 5
	pack $f -fill x
	
	# turn on accents 
	set f [frame .preferences.accents -relief raised -bd 2]
	label $f.label -text "Use Accents" -width 20
	pack $f.label -side left -anchor e -pady 5 -padx 5
	checkbutton $f.val -variable CONFIG(USE_ACCENTS) -command {
	    if {$CONFIG(USE_ACCENTS)} {
		# set the accents bindings
		AccentsBind $SEARCH(ENTRY) ;# accents
		foreach i {NAME COMPANY EMAIL \
			       PHONE ADDRESS NOTES} {
		    AccentsBind $RECORD($i)
		}
	    } else {
		# remove accents bindings
		AccentsUnBind $SEARCH(ENTRY) ;# accents
		foreach i {NAME COMPANY EMAIL \
			       PHONE ADDRESS NOTES} {
		     AccentsUnBind $RECORD($i)
		}
	    }
	}
	pack $f.val -side left -pady 5 -padx 5
	pack $f -fill x

	# search option
	set f [frame .preferences.search -relief raised -bd 2]
	label $f.label -text "Search mode" -width 20
	pack $f.label -side left -anchor e -pady 5 -padx 5
	radiobutton $f.b1 -variable CONFIG(SEARCH) \
	    -value "regexp" -text "regexp"
	radiobutton $f.b2 -variable CONFIG(SEARCH) \
	    -value "exact" -text "exact"
	radiobutton $f.b3 -variable CONFIG(SEARCH) \
	    -value "global" -text "global"

	checkbutton $f.b4 -variable CONFIG(SEARCH_INTERACTIVE) \
	    -text "interactive" -command {
		if {$CONFIG(SEARCH_INTERACTIVE)} {
		    bind isearch <Key>            {SearchRecord}
		    $SEARCH(ENTRY_BUTTON) config -state disabled
		} else {
		    bind isearch <Key>             {}
		    $SEARCH(ENTRY_BUTTON) config -state normal
		}
	    }

	checkbutton $f.b5 -variable CONFIG(SEARCH_CASE) \
	    -text "case sensitive (global only)"
	
	pack $f.b5 $f.b4  -side bottom -pady 5 -padx 5 -anchor w
	pack $f.b1 $f.b2 $f.b3 -side left -pady 5 -padx 5
	pack $f -fill x 

	# date format
	set f [frame .preferences.date -relief raised -bd 2]
	label $f.label -text "Date format" -width 20
	pack $f.label -side left -anchor e -pady 5 -padx 5
	radiobutton $f.b1 -variable CONFIG(DATE_FORMAT) \
	    -value "+%m/%d/%y" -text "month/day/year"
	radiobutton $f.b2 -variable CONFIG(DATE_FORMAT) \
	    -value "+%d/%m/%y" -text "day/month/year"
	pack $f.b1 $f.b2 -side left -pady 5 -padx 5
	pack $f -fill x 


	# anniversary color
	set f [frame .preferences.anniv -relief raised -bd 2]
	label $f.label -text "Anniversary color" -width 20
	entry $f.valc -textvariable CONFIG(ANNIVERSARY_HIGHLIGHT_COLOR)
	pack $f.label -side left -anchor e -pady 5 -padx 5
	pack $f.valc -fill x -expand yes  -pady 5 -padx 5
	pack $f -fill x

	# file editor
	set f [frame .preferences.filed -relief raised -bd 2]
	set f1 [frame .preferences.filed.f1]
	label $f1.label -text "Editor command" -width 20
	pack $f1.label -side left -anchor e -pady 5 -padx 5
	
	set f2 [frame .preferences.filed.f2]
	entry $f2.val -textvariable CONFIG(EDITOR_COMMAND) -width 40
	pack $f2.val -pady 5 -padx 5
	label $f2.labelc -text "color" -width 18
	pack $f2.labelc -anchor w -side left -padx 5
	entry $f2.valc -textvariable CONFIG(FILE_HIGHLIGHT_COLOR)
	pack $f2.valc -fill x -expand yes  -pady 5 -padx 5

	pack $f1 $f2 -side left -expand true -fill both
	pack $f -fill x

	# web browser
	set f [frame .preferences.web -relief raised -bd 2]
	set f1 [frame .preferences.web.f1]
	label $f1.label -text "Browser command" -width 20
	pack $f1.label -side left -anchor e -pady 5 -padx 5
	
	set f2 [frame .preferences.web.f2]
	entry $f2.val -textvariable CONFIG(BROWSER_COMMAND) -width 40
	pack $f2.val -pady 5 -padx 5
	label $f2.labelc -text "color" -width 18
	pack $f2.labelc -anchor w -side left -padx 5
	entry $f2.valc -textvariable CONFIG(BROWSER_HIGHLIGHT_COLOR)
	pack $f2.valc -fill x -expand yes  -pady 5 -padx 5

	pack $f1 $f2 -side left -expand true -fill both
	pack $f -fill x

	# mail facilities
	set f [frame .preferences.mail -relief raised -bd 2]
	set f1 [frame .preferences.mail.f1]
	label $f1.label -text "Mail command" -width 20
	pack $f1.label -side left -anchor e -pady 5 -padx 5
	
	set f2 [frame .preferences.mail.f2]
	entry $f2.val -textvariable CONFIG(MAIL_COMMAND) -width 40
	pack $f2.val -pady 5 -padx 5
	label $f2.labelc -text "color" -width 18
	pack $f2.labelc -anchor w -side left -padx 5
	entry $f2.valc -textvariable CONFIG(MAIL_HIGHLIGHT_COLOR)
	pack $f2.valc -fill x -expand yes  -pady 5 -padx 5

	pack $f1 $f2 -side left -expand true -fill both
	pack $f -fill x

	# phone facilities
	set f [frame .preferences.phone -relief raised -bd 2]
	set f1 [frame .preferences.phone.f1]
	label $f1.label -text "Phone command" -width 20
	pack $f1.label -side left -anchor e -pady 5 -padx 5
	
	set f2 [frame .preferences.phone.f2]
	entry $f2.val -textvariable CONFIG(PHONE_COMMAND) -width 40
	pack $f2.val -pady 5 -padx 5
	label $f2.labelc -text "color" -width 18
	pack $f2.labelc -anchor w -side left -padx 5
	entry $f2.valc -textvariable CONFIG(PHONE_HIGHLIGHT_COLOR)
	pack $f2.valc -fill x -expand yes  -pady 5 -padx 5

	pack $f1 $f2 -side left -expand true -fill both
	pack $f -fill x

	# ftp facilities
	set f [frame .preferences.ftp -relief raised -bd 2]
	set f1 [frame .preferences.ftp.f1]
	label $f1.label -text "FTP command" -width 20
	pack $f1.label -side left -anchor e -pady 5 -padx 5
	
	set f2 [frame .preferences.ftp.f2]
	entry $f2.val -textvariable CONFIG(FTP_COMMAND) -width 40
	pack $f2.val -pady 5 -padx 5
	label $f2.labelc -text "color" -width 18
	pack $f2.labelc -anchor w -side left -padx 5
	entry $f2.valc -textvariable CONFIG(FTP_HIGHLIGHT_COLOR)
	pack $f2.valc -fill x -expand yes  -pady 5 -padx 5

	pack $f1 $f2 -side left -expand true -fill both
	pack $f -fill x
	
	# a button frame
	set f [frame .preferences.buttons -relief raised -bd 2]
	set f2 [frame $f.ok -relief sunken -bd 2]
	button $f2.ok -text "Set Preferences" -command {
	    if { $INTERNAL(CURRENT_KEY) != ""} {
		SaveOptions
		ShowRecord [GetCurrentKey]
	    }
	}
	pack $f2.ok -padx 5 -pady 5
	button $f.abort -text "Dismiss" -command {set valprefs 0}

	pack $f2 $f.abort -padx 5 -pady 5 -side left -expand true
	pack $f -fill x
	focus $f2.ok 

	# help bindings
	bind .preferences <Any-F1>      {Help [winfo containing %X %Y] %X %Y}
	bind .preferences <Any-Help>    {Help [winfo containing %X %Y] %X %Y}
	bind .preferences <Shift-Button-3> {Help [winfo containing %X %Y] %X %Y}
	
	# the rest of the stuff
	tkwait variable valprefs
	grab release .preferences
	# update idletasks
	catch {destroy .preferences}
	SaveOptions
    }
}

proc StartMe {title label action {defarg ""}} {
    
    global FORMAT CONFIG RECORD INTERNAL
    global startme_wait arg
    
    set arg $defarg
    if [winfo exists .preferences] {
	focus .startme
    } else {
	toplevel .startme

	# some magic
	set w0 20
	set w1 38

	wm resizable .startme 0 0
	wm title .startme "$INTERNAL(NAME) $title"
	wm iconname .startme "$INTERNAL(NAME) $title"
	
	# the title
	set f [frame .startme.title -relief raised -bd 2]
	label $f.label -text $title
	pack $f.label -fill x -pady 5 -padx 5
	pack $f -fill x

	# a frame to define where to startme
	set f [frame .startme.where -relief raised -bd 2]
	label $f.label -text $label -width $w0
	pack $f.label -side left -anchor e -pady 5 -padx 5
	entry $f.output -textvariable arg -width $w1
	pack $f.output -side left -pady 5 -padx 5
	pack $f -fill x
	
	# a button frame
	set f [frame .startme.buttons -relief raised -bd 2]
	set f2 [frame $f.ok -relief sunken -bd 2]
	button $f2.ok -text "Ok" -command {set startme_wait 1}
	pack $f2.ok -padx 5 -pady 5
	button $f.abort -text "Dismiss" -command {set startme_wait 0}

	pack $f2 $f.abort -padx 5 -pady 5 -side left -expand true
	pack $f -fill x
	focus .startme.where.output

	# help bindings
	bind .startme <Any-F1>      {Help [winfo containing %X %Y] %X %Y}
	bind .startme <Any-Help>    {Help [winfo containing %X %Y] %X %Y}
	bind .startme <Shift-Button-3> {Help [winfo containing %X %Y] %X %Y}
	
	bind .startme.where.output <Return> {set startme_wait 1}
	
	# the rest of the stuff
	tkwait variable startme_wait
	if { $startme_wait } { $action $arg }
	grab release .startme
	update idletasks
	catch {destroy .startme}
    }
}

proc EntriesSize {} {
    
    global FORMAT CONFIG RECORD INTERNAL
    global valsize
    
    if [winfo exists .entrs] {
	focus .entrs
    } else {
	toplevel .entrs

	wm resizable .entrs 0 0
	wm title .entrs "$INTERNAL(NAME) resize"
	wm iconname .entrs "$INTERNAL(NAME) resize"
	
	# the title
	set f [frame .entrs.title -relief raised -bd 2]
	label $f.label -text "Resize" 
	pack $f.label -fill x -pady 5 -padx 5
	pack $f -fill x

	set f [frame .entrs.sizeme -relief raised -bd 2]
	# resize entries
	set f1 [frame $f.h]
	label $f1.label -text "Entry width" -width 20
	scale $f1.scale -orient horizontal -length 267 -from 20 -to 100 \
	    -command SetEntriesWidth -variable CONFIG(ENTRY_WIDTH)
	
	set f2 [frame $f.v]
	label $f2.label -text "Entry height" -width 20
	scale $f2.scale -orient horizontal -length 267 -from 3 -to 20 \
	    -command SetEntriesHeight -variable CONFIG(ENTRY_HEIGHT)

	set f3 [frame $f.lw]
	label $f3.label -text "List width" -width 20
	scale $f3.scale -orient horizontal -length 267 -from 20 -to 100 \
	    -command SetSearchListWidth -variable CONFIG(LIST_WIDTH)
	
	pack $f1.label -side left -anchor e -pady 5 -padx 5
	pack $f1.scale -side left -pady 5 -padx 5
	pack $f2.label -side left -anchor e -pady 5 -padx 5
	pack $f2.scale -side left -pady 5 -padx 5
	pack $f3.label -side left -anchor e -pady 5 -padx 5
	pack $f3.scale -side left -pady 5 -padx 5
	pack $f1 -fill x
	pack $f2 -fill x
	pack $f3 -fill x
	pack $f -fill x
	
	# a button frame
	set f [frame .entrs.buttons -relief raised -bd 2]
	set f2 [frame $f.ok -relief sunken -bd 2]
	button $f2.ok -text "Ok" -command {set valsize 1}
	pack $f2.ok -padx 5 -pady 5
	pack $f2 -padx 5 -pady 5 -side left -expand true
	pack $f -fill x
	focus $f2.ok 

	# the rest of the stuff
	tkwait variable valsize
	
	grab release .entrs
	if {$valsize == 1} {
	    SaveOptions
	    catch {destroy .entrs}
	} else {
	    catch {destroy .entrs}
	}
    }

		  
}

proc ScheduleAnniversaries {} {
    
    global FORMAT CONFIG RECORD INTERNAL
    global valanniv htime
    
    if [winfo exists .anniv] {
	focus .anniv
    } else {
	toplevel .anniv

	wm resizable .anniv 0 0
	wm title .anniv "$INTERNAL(NAME): Schedule Anniversaries"
	wm iconname .anniv "$INTERNAL(NAME) : Schedule Anniversaries"
	
	# the title
	set f [frame .anniv.title -relief raised -bd 2]
	label $f.label -text "Warnings for today's anniversaries:" 
	pack $f.label -fill x -pady 5 -padx 5
	pack $f -fill x

	set f [frame .anniv.sizeme -relief raised -bd 2]

	# set in hours
	set htime [expr $CONFIG(ANNIVERSARY_WARNINGS_DELAY) / 3600000]
	set f1 [frame $f.h]
	label $f1.label -text "Warn Every: (hours)" -width 20
	scale $f1.scale -orient horizontal -length 267 -from 1 -to 24 \
	    -variable htime

	pack $f1.label -side left -anchor e -pady 5 -padx 5
	pack $f1.scale -side left -pady 5 -padx 5
	pack $f1 -fill x
	pack $f -fill x
	
	# a button frame
	set f [frame .anniv.buttons -relief raised -bd 2]
	set f2 [frame $f.ok -relief sunken -bd 2]
	button $f2.ok -text "Ok" -command {set valanniv 1}
	pack $f2.ok -padx 5 -pady 5
	pack $f2 -padx 5 -pady 5 -side left -expand true
	pack $f -fill x
	focus $f2.ok 

	# the rest of the stuff
	tkwait variable valanniv
	
	grab release .anniv
	if {$valanniv == 1} {
	    set CONFIG(ANNIVERSARY_WARNINGS_DELAY) [expr $htime * 3600000]
	    SaveOptions
	    catch {destroy .anniv}
	} else {
	    catch {destroy .anniv}
	}
    }

		  
}

proc SetSearchListWidth {val} {
    global SEARCH CONFIG
    wm geometry . ""    
    $SEARCH(LIST) config -width $val
    $SEARCH(ENTRY) config -width [expr $val - 8]
}

proc SetEntriesHeight {val} {
    global RECORD CONFIG
    set CONFIG(GEOMETRY) "" 
    foreach item {PHONE ADDRESS NOTES} {
	$RECORD($item) config -height [expr $val]
    }
}

proc SetEntriesWidth {val} {
    global RECORD CONFIG
    set CONFIG(GEOMETRY) ""
    foreach item {NAME COMPANY EMAIL} {
	$RECORD($item) config -width $val
    }
    foreach item {PHONE ADDRESS NOTES} {
	$RECORD($item) config -width [expr $val - 3]
    }
}	
