# Carnet : a simple addressbook written in tcl/tk
# Copyright (C) 1996 Nocera Luciano
# Revision: $Id: help.tcl,v 1.3 1997/03/14 18:09:19 lnocera Exp lnocera $
# State: Exp
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

#----------------------------------------------------------------------#
# Help on context                                                      #
#----------------------------------------------------------------------#


proc HelpMessage {title msg {wtitle {}}} {
    
    global INTERNAL
    
    if [winfo exists .help] {
	.help.f2.text configure -state normal
	.help.f2.text delete 1.0 end
	.help.f2.text insert insert $msg
	.help.f.title config -text $title
	.help.f2.text configure -state disabled
    } else {
	set t [toplevel .help]
	# wm resizable .help 0 0
	wm minsize .help 579 229
	
	frame .help.f -relief raised -bd 2
	label .help.f.title -text $title -width 50
	pack .help.f.title -fill x -expand true
	pack .help.f -side top -fill x
	
	frame .help.f2 -relief raised -bd 2
	text .help.f2.text -wrap word -height 10 \
	    -yscrollcommand [list .help.f2.yscroll set]
	scrollbar .help.f2.yscroll -orient vertical \
		   -command [list .help.f2.text yview]
	pack .help.f2.yscroll -side right -fill y
	pack .help.f2.text -side left -fill both -expand true
	pack .help.f2 -fill both -expand true
	
	# a button frame
	frame .help.buttons -relief raised -bd 2
	frame .help.buttons.ok -relief sunken -bd 2
	button .help.buttons.ok.ok -text "Ok" -command {destroy .help}
	pack .help.buttons.ok -padx 5 -pady 5
	pack .help.buttons.ok.ok -padx 5 -pady 5 -expand true
	pack .help.buttons  -fill x
	focus .help.buttons.ok.ok
	
	.help.f2.text insert insert $msg
	.help.f2.text configure -state disabled
    }
    
    # set the title
    if { $wtitle != {} } {
	wm title .help $wtitle
    } else {
	wm title .help "$INTERNAL(NAME) help"
    }
}

proc Help {topic {x 0} {y 0}} {
    global helpTopics helpCmds 
    if {$topic == ""} return 
    while {[info exists helpCmds($topic)]} { 
	set topic [eval $helpCmds($topic)] 
    } 
    if [info exists helpTopics($topic)] {
	set msg $helpTopics($topic)
    } else {
	set msg "Sorry, but no help is available for this topic"
    }
    HelpMessage "Information on $topic:" $msg
}

# bindings on .
bind . <Any-F1>      {Help [winfo containing %X %Y] %X %Y}
bind . <Any-Help>    {Help [winfo containing %X %Y] %X %Y}
bind . <Shift-Button-3> {Help [winfo containing %X %Y] %X %Y}

# Help text and commands below:
set helpTopics(.carnetcommand.file) {

This is the "file" menu.  It can be used to invoke some overall
operations (load an external database, reload or save the local
databases, print the database and exit).

}
set helpTopics(.carnetcommand.edit) {

This is the "Record" menu.  It can be used to modify or insert record.

}
set helpTopics(.carnetcommand.options)  {

This is the "option" menu.  It can be used to set general preferences
and to define the application appearance.

}
set helpTopics(.carnetcommand.database)  {

This is the "database" menu.  It can be used to select what database 
have to be displayed. You can choose to display private records only, public 
records only or external records only. In the default mode all the records 
are shown.
}
set helpTopics(.carnetcommand.help) {

This is the "help" menu. It provides help on this application.

}
set helpTopics(.carnetcommand) {

This is the command bar of the application.

} 
set helpTopics(.carnet.logbar) {

This is the log bar. It gives comments on what is going on. The log
bar can be hidden from the option menu.

}
set helpCmds(.carnet.logbar.title)  {set topic .carnet.logbar}
set helpCmds(.carnet.logbar.message)  {set topic .carnet.logbar}

set helpTopics(.carnet.data.data.name) {

In this field you should type the person's name, or nothing if it is a
company.

}
set helpCmds(.carnet.data.data.name.name.text) {set topic .carnet.data.data.name}
set helpCmds(.carnet.data.data.name.label) {set topic .carnet.data.data.name}

set helpTopics(.carnet.data.data.company) {

In this field you should type the company's name, This field have to
be filled if no person's name is given.

}
set helpCmds(.carnet.data.data.company.company.text) {set topic .carnet.data.data.company}
set helpCmds(.carnet.data.data.company.label) {set topic .carnet.data.data.company}

set helpTopics(.carnet.data.data.email) {

In this field you should type the person/company's email

}
set helpCmds(.carnet.data.data.email.email.text) {set topic .carnet.data.data.email}
set helpCmds(.carnet.data.data.email.label) {set topic .carnet.data.data.email}

set helpTopics(.carnet.data.data.phone) {

In this field you should type the person/company's phone

}
set helpCmds(.carnet.data.data.phone.phone.text) {set topic .carnet.data.data.phone}
set helpCmds(.carnet.data.data.phone.label) {set topic .carnet.data.data.phone}

set helpTopics(.carnet.data.data.address) {

In this field you should type the person/company's address

}
set helpCmds(.carnet.data.data.address.address.text) {set topic .carnet.data.data.address}
set helpCmds(.carnet.data.data.address.label) {set topic .carnet.data.data.address}

set helpTopics(.carnet.data.data.notes) {

In this field you should type the person/company's notes

}
set helpCmds(.carnet.data.data.notes.notes.text) {set topic .carnet.data.data.notes}
set helpCmds(.carnet.data.data.notes.label) {set topic .carnet.data.data.notes}

set helpTopics(.carnet.data.data.private)       {

You should use this check button to notify if you want this record to
be readable by others or not.

}
set helpCmds(.carnet.data.data.private.private) {set topic .carnet.data.data.private}
set helpCmds(.carnet.data.data.private.label)   {set topic .carnet.data.data.private}
set helpCmds(.carnet.data.data.private.label2)   {set topic .carnet.data.data.private}

set helpTopics(.carnet.data.search.sel)           {

In this field you should type the name (or a selection pattern) of the
person or company to search. If nothing is given all the records are
listed in the list-box below.

}
set helpCmds(.carnet.data.search.sel.select) {set topic .carnet.data.search.sel}
set helpCmds(.carnet.data.search.sel.entry) {set topic .carnet.data.search.sel}

set helpTopics(.carnet.data.search.search.search)   {

This list-box display the names of the persons or companies that match
the selection pattern of the "Select" entry. Double-Click on a record
to display it's contents.

}
set helpTopics(.carnet.data.alphabar) {

This toolbar provides aphabetic access to the records.  This tool-bar can 
be hidden from the option menu.
}
foreach i {a b c d e f g h i j k l m} {
    set helpCmds(.carnet.data.alphabar.f1.$i) {set topic .carnet.data.alphabar}
}
foreach i {n o p q r s t u v w x y z} {
    set helpCmds(.carnet.data.alphabar.f2.$i) {set topic .carnet.data.alphabar}
}

set helpTopics(.carnet.toolbar) {

This toolbar provides quick access to the main functions used to
update the database. The tool-bar can be hidden from the option menu.

}
set helpTopics(.carnet.toolbar.search) {

Resets the selection pattern and display in the list-box the entire
database.

}
set helpTopics(.carnet.toolbar.clear)  {

Resets the record fields. You should use this command prior to insert
a new record.

}
set helpTopics(.carnet.toolbar.update) {

Update the database from the currently displayed record entire
database. You should use this command after any changes on a record.

}
set helpTopics(.carnet.toolbar.delete) {

Posts a dialog box asking if you want to delete the currently
displayed record.

}
set helpTopics(.carnet.toolbar.save)   {

Save the database. You can use this function at any moment. Note that
an auto-save switch can be set in the option preferences menu in
order to automatically save any changes on the database.

} 

set helpTopics(about) "

$INTERNAL(NAME) is an address-book written in tcl/tk.

$INTERNAL(NAME) $RCS(REVISION), Copyright (C) 1996 Nocera Luciano
$INTERNAL(NAME) comes with ABSOLUTELY NO WARRANTY; for details invoke
`warranty' under the Help menu. This is free software, and you are 
welcome to redistribute it under certain conditions; invoke `license' 
under the Help menu for details.

"
set helpTopics(backup) "

$INTERNAL(NAME) automatically backup both private and public databases
to prevent any information lossage. You can also force a backup from
the \"File\" menu. You can set the backup level in the \"option
preferences menu\". If The backup level is set to 3, files named
file.bck_2 file.bck_1 file.bck_0 are created, where \"file\" are both
db.public or db.private. When a backup is done file \"file\" is moved
to file.bck_2, file.bck_2 is moved to file.bck_1, and so on. Backups
are done only if the database is modified, when you \"quit\"
$INTERNAL(NAME). If you think that your database is corrupted, exit
from $INTERNAL(NAME) without saving, then proceed as follow:

1) Select a correct version of the database, running $INTERNAL(NAME)
with the -f option:

prompt$ $INTERNAL(NAME) -f $INTERNAL(DBPUBLIC_NAME).bck_2

(-f prevents any save action on the loaded databases)

2) copy the right backuped file to the database file:

$ cp $INTERNAL(DBPUBLIC_NAME).bck_2 $INTERNAL(DBPUBLIC_NAME)

Stages 1 and 2 shoud be repetead for both $INTERNAL(DBPUBLIC_NAME) and
$INTERNAL(DBPRIVATE_NAME) before to restart $INTERNAL(NAME) without
the -f option.

"
set helpTopics(highlight) "

When displayed, each record field is parsed for EMAIL, FTP and HHTP
addresses, PHONE numbers and FILES.  The following colors are used for
those items:

---------------------------------------------------------------------
$CONFIG(MAIL_HIGHLIGHT_COLOR) for valid mail addresses :
                    name@address.domain
---------------------------------------------------------------------
$CONFIG(FTP_HIGHLIGHT_COLOR) for valid ftp files:
                    ftp://ftp.address
---------------------------------------------------------------------
$CONFIG(BROWSER_HIGHLIGHT_COLOR) for valid http files:
                    http://address
---------------------------------------------------------------------
$CONFIG(PHONE_HIGHLIGHT_COLOR) for valid phone number:
ONE digit numbers: +33 16 1 123456

TWO digits numbers (at least 6 numbers): 12 12 12 ; 12.12.12 ;
12-12-12 ; 12 12 123 ; 12.12.123 ; 12-12-123 12 12 1234 ;
12.12.1234 ; 12-12-1234 

THREE digits numbers: (at least 6 numbers)
123 123 ; 123.123 ; 123-123 ; 123 123 123 ; 123.123.123 ; 123-123-123
; 123 123 1234 ; 123.123.1234 ; 123-123-1234 ...

Any of the above forms may be prefixed by a valid prefix of the form:

(country prefix) (region prefix) number:

+33 16 1 123 123 ; 16 1 12-12-12 ; 369 333-4444
---------------------------------------------------------------------
$CONFIG(FILE_HIGHLIGHT_COLOR) for valid files:
                      file:/path/fileordirectory

---------------------------------------------------------------------
ACTIONS ARE INVOKED WHEN AN ITEM IS SELECTED WITH MOUSE <BUTTON-1> or 
MOUSE <BUTTON-3>. To can change the default settings using the
\"option preferences menu\". Invoke the Help on context from within
the preference form for more details.
"

set helpTopics(warranty) {
    			    NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.}

set helpTopics(license) {
		    GNU GENERAL PUBLIC LICENSE
		       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
                          59 Temple Place - Suite 330
                          Boston, MA 02111-1307, USA.
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

			    Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

		    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

			    NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

		     END OF TERMS AND CONDITIONS

	    How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) 19yy  <name of author>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.

Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

    Gnomovision version 69, Copyright (C) 19yy name of author
    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c' for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a "copyright disclaimer" for the program, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the program
  `Gnomovision' (which makes passes at compilers) written by James Hacker.

  <signature of Ty Coon>, 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.

}

set helpTopics(context) {

Simply move the mouse over the window you're curious about and press
Help or F1 or Shift-Button-3.  You can do this anytime.

}
set helpTopics(import) "

From within Vm, Rmail or exmh you can import names and emails directely
into $INTERNAL(NAME).

---------------------------------------------------------------------

For Vm and Rmail: 
-----------------

You would use one of the files included in the $INTERNAL(NAME)
distribution:

$INTERNAL(LIB_PATH)/carnet-vm.el
$INTERNAL(LIB_PATH)/carnet-rmail.el


These emacs lisp files are originally form BBDB and are patched to be
used for $INTERNAL(NAME). To use the import mechanism, you just have
to load one of these files from within your .emacs like:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; vm hack a la bbdb for carnet
;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(require 'carnet-vm)
(carnet-insinuate-vm)

or 

(load-file (expand-file-name \"$INTERNAL(LIB_PATH)/carnet-vm.el\"))
(carnet-insinuate-vm)

depending on if carnet-vm.el is in your emacs lisp path or not. Use
\":\" when a mail is displayed and the name and the address will be
imported into $INTERNAL(NAME) when a search action is attempted.

For exmh:
---------

Just load into exmh the file $INTERNAL(LIB_PATH)/carnet-exmh.tcl and
exmh will display a button to import names/addresses into
$INTERNAL(NAME). To load $INTERNAL(LIB_PATH)/carnet-exmh.tcl copy exmh
in your $env(HOME)/bin/ directory and add at the end of the file:

source \"$INTERNAL(LIB_PATH)/carnet-exmh.tcl\"

Then use your local version of exmh. (There should be a nicer way to
do using the exmh user hacking library directory ... if you discover
how please let me know!).

"
set helpTopics(keys) "

The following accelerator keys are defined for this application 
(in addition to those already available for tk):

Alt+F:\t\tEnter file menu 
Alt+E:\t\tEnter edit menu
Alt+O:\t\tEnter options menu 
Alt+H:\t\tEnter help menu 

Alt+L:\t\tMove to the selection pattern entry
Alt+C:\t\tClear the record area
Alt+R:\t\tSwitch to the first entry in the record area
Alt+U:\t\tUpdate the currently displayed record
Alt+D:\t\tDelete the currently displayed record
Alt+S:\t\tSave the database

Alt+L Alt+C Alt+R Alt+U Alt+D Alt+S are also binded equivalently with
the Meta key

In the selection entry:
Return:\t\tSearch for the given pattern
Tab:\t\tSearch for the given pattern
Alt+L:\t\tSearch for the given pattern

In the listbox:
space:\t\tShow selected record
Double-1\tShow selected record

See also \"accentuated characters\" in the \"Help\" menu
"

# help on the preferences menu
set helpTopics(.preferences.auto) {

Autosave saves automatically changes on disk before to quit. If
auto-save is disabled you will be warned to save before you quit.

}

set helpCmds(.preferences.auto.label) {set topic .preferences.auto}
set helpCmds(.preferences.auto.val)   {set topic .preferences.auto}

set helpTopics(.preferences.search) {

The search mode variable is used when searching for a person/company
name or pattern. Three search modes are available, namely "regexp" and
"exact" and "global". Both "regexp" and "exact" are keyword based
search modes. Recall that a key for a given record is build upon the
name field or upon the company field if the name is missing. "global"
allows to search for any record containing a given pattern.

"regexp" searches using tcl regular expressions based on record keys:

	a search on for the record "Albert Einstein" can be achieved
	using a search pattern: "*albert*" or simply "albert" (* are
        added at the beginning and at the end automatically), or 
	"eins". 

"exact" is used to search for exact spelling based on record keys:

	for the previous example to search "Albert Einstein" you have
	to  set the search pattern to "alb" (match every record
        which name or company start with "alb"). If you search for 
	"ein" you will not find "Albert Einstein". This is the search
	mode used in the alphabet-bar.

"global" is used to search for records containing a given
	 expression. Only for this search mode you can choose to use
	it in a case sensitive fashion.

	if you search for "e = mc2" and if the string "e = mc2" is
	present in the record of "Albert Einstein" it will be listed 
	in the selection-box or displayed depending if it is the only
	record that matches this pattern.

All three modes support interactiveness. If interactive is on the
list of records matching the search pattern will be updated every time
a new character is inserted.
}

set helpCmds(.preferences.search.label) {set topic .preferences.search}
set helpCmds(.preferences.search.b1)   {set topic .preferences.search} 
set helpCmds(.preferences.search.b2)   {set topic .preferences.search}
set helpCmds(.preferences.search.b3)   {set topic .preferences.search}
set helpCmds(.preferences.search.b4)   {set topic .preferences.search}
set helpCmds(.preferences.search.b5)   {set topic .preferences.search}

set helpTopics(.preferences.web) {

Define the browser used to visualize an url. You can either use
one of the following:

WITOUTH KEYWORD:
netscape

WITH THE URL KEYWORD:
mybrowser URL

}
set helpCmds(.preferences.web.f1) {set topic .preferences.web}
set helpCmds(.preferences.web.f1.label) {set topic .preferences.web}
set helpCmds(.preferences.web.f2) {set topic .preferences.web}
set helpCmds(.preferences.web.f2.val) {set topic .preferences.web}
set helpCmds(.preferences.web.f2.labelc) {set topic .preferences.web}
set helpCmds(.preferences.web.f2.valc) {set topic .preferences.web}

set helpTopics(.preferences.mail) {

Define the mail editor used for mail composition. You can either use
one of the following:

WITOUTH KEYWORD:
SimpleMail			for the carnet mail facility
netscape			for netscape-mail

WITH THE EMAIL KEYWORD:
to use xemacs put (gnuserv-start ()) in your .emacs and use gnudoit:
gnudoit '(progn (mail-other-frame) (mail-to) (insert "EMAIL")) (next-line 1)'
xterm -e elm EMAIL		for elm

An empty string defaults to SimpleMail
}
set helpCmds(.preferences.mail.f1) {set topic .preferences.mail}
set helpCmds(.preferences.mail.f1.label) {set topic .preferences.mail}
set helpCmds(.preferences.mail.f2) {set topic .preferences.mail}
set helpCmds(.preferences.mail.f2.val) {set topic .preferences.mail}
set helpCmds(.preferences.mail.f2.labelc) {set topic .preferences.mail}
set helpCmds(.preferences.mail.f2.valc) {set topic .preferences.mail}

set helpTopics(.preferences.phone) {

Define the command used to dial phone numbers. 

WITH THE PHONE KEYWORD:
dialprogram PHONE

If you set just to "dialprogram" phone number will be hilighted but no
action will be attached to the Mouse Button-1 or Button-3 events.
}
set helpCmds(.preferences.phone.f1) {set topic .preferences.phone}
set helpCmds(.preferences.phone.f1.label) {set topic .preferences.phone}
set helpCmds(.preferences.phone.f2) {set topic .preferences.phone}
set helpCmds(.preferences.phone.f2.val) {set topic .preferences.phone}
set helpCmds(.preferences.phone.f2.labelc) {set topic .preferences.phone}
set helpCmds(.preferences.phone.f2.valc) {set topic .preferences.phone}

set helpTopics(.preferences.ftp) {

Define the program used to open an ftp address. You can either use
one of the following:

WITOUTH KEYWORD:
netscape

WITH THE FTP KEYWORD:
xterm -e ftp FTP
if you use ange ftp tthe following should work:
gnudoit '(progn (find-file-other-frame "anonymous@FTP"))'

}

set helpCmds(.preferences.ftp.f1) {set topic .preferences.ftp}
set helpCmds(.preferences.ftp.f1.label) {set topic .preferences.ftp}
set helpCmds(.preferences.ftp.f2) {set topic .preferences.ftp}
set helpCmds(.preferences.ftp.f2.val) {set topic .preferences.ftp}
set helpCmds(.preferences.ftp.f2.labelc) {set topic .preferences.ftp}
set helpCmds(.preferences.ftp.f2.valc) {set topic .preferences.ftp}

set helpTopics(.preferences.filed) {

Define the editor that will be used to open a files. You can use
either one of the following settings:

WITOUTH KEYWORD:
netscape			to use netscape

WITH THE FILE KEYWORD:
gnuclient "FILE"      	        to use the xemacs server 
				(put (gnuserv-start ()) in your .emacs)
xterm -e vi FILE		start an xterm and edit with vi
xterm -e less FILE		start an xterm and edit with less
}

set helpCmds(.preferences.filed.f1) {set topic .preferences.filed}
set helpCmds(.preferences.filed.f1.label) {set topic .preferences.filed}
set helpCmds(.preferences.filed.f2) {set topic .preferences.filed}
set helpCmds(.preferences.filed.f2.val) {set topic .preferences.filed}
set helpCmds(.preferences.filed.f2.labelc) {set topic .preferences.filed}
set helpCmds(.preferences.filed.f2.valc) {set topic .preferences.filed}

set helpTopics(.preferences)  {

This is the general preferences menu.

}
set helpCmds(.preferences.title.label) {set topic .preferences}
set helpCmds(.preferences.title) {set topic .preferences}
set helpTopics(.preferences.buttons)  {

This is the general preferences menu.

}
set helpTopics(.preferences.buttons.ok.ok)  {

This is the general preferences menu.

}
set helpTopics(.preferences.buttons.abort)  {

This is the general preferences menu.

}

# help on the print menu
set helpTopics(.print)  {

This is the print facilities interface.

}
set helpCmds(.print.title.label) {set topic .print}
set helpCmds(.print.title) {set topic .print}
set helpTopics(.print.buttons)  {

This is the general print menu.

}
set helpTopics(.print.buttons.ok.ok)  {

This is the general print menu.

}
set helpTopics(.print.buttons.ok)  {

This is the general print menu.

}
set helpTopics(.print.buttons.abort)  {

This is the general print menu.

}

set helpTopics(.print.where)  {

Define the output file name.

}
set helpCmds(.print.where.label)  {set topic .print.where}
set helpCmds(.print.where.file)  {set topic .print.where}

set helpTopics(.print.format)  {

Define the output format.

}
set helpCmds(.print.format.label)  {set topic .print.format}
set helpCmds(.print.format.normal)  {set topic .print.format}
set helpCmds(.print.format.latex)  {set topic .print.format}

set helpTopics(.print.what)  {

Define the record's fields that have to be printed.

}
set helpCmds(.print.what.label)  {set topic .print.what}
set helpCmds(.print.what.email)  {set topic .print.what}
set helpCmds(.print.what.phone)  {set topic .print.what}
set helpCmds(.print.what.address)  {set topic .print.what}
set helpCmds(.print.what.notes)  {set topic .print.what}

set helpTopics(.print.database)  {

Define what kind of records have to be printed:\n\nCurrent Record\t
prints the currently displayed record\nAll Public\t\tprints all the
public records\nAll Private\tprints all the private
records\nAll\t\tprints all the records (i.e. public private and
external).

}
set helpCmds(.print.database.label)  {set topic .print.database}
set helpCmds(.print.database.current)  {set topic .print.database}
set helpCmds(.print.database.public)  {set topic .print.database}
set helpCmds(.print.database.private)  {set topic .print.database}
set helpCmds(.print.database.all)  {set topic .print.database}

# help on mail
set helpTopics(.simplemail)  {

This is a simple mail interface.

}
set helpCmds(.simplemail.buttons) {set topic .simplemail}
set helpCmds(.simplemail.buttons.ok.ok) {set topic .simplemail}
set helpCmds(.simplemail.buttons.ok) {set topic .simplemail}
set helpCmds(.simplemail.buttons.abort) {set topic .simplemail}
set helpCmds(.simplemail.head) {set topic .simplemail}
set helpCmds(.simplemail.command) {set topic .simplemail}
set helpCmds(.simplemail.command.edit) {set topic .simplemail}
set helpCmds(.simplemail.command.file) {set topic .simplemail}

set helpTopics(.simplemail.head.text) {

This field contains the message to send.

}
set helpCmds(.simplemail.head.text.yscroll) {set topic .simplemail}
set helpCmds(.simplemail.head.text.text) {set topic .simplemail}

set helpTopics(.simplemail.head.bcc) {

This field contains the identity of additional recipients of the
message. The contents of this field are not included in the copies of
the message sent to the primary and secondary recipients. Some systems
may choose to include the text of the "Bcc" field only in the
author(s)'s copy, while others may also include it in the text sent to
all those indicated in the "Bcc" list.

}
set helpCmds(.simplemail.head.bcc.bcc) {set topic .simplemail.head.bcc}
set helpCmds(.simplemail.head.bcc.label) {set topic .simplemail.head.bcc}

set helpTopics(.simplemail.head.cc) {

This field contains the identity of the secondary (informational)
recipients of the message.

}
set helpCmds(.simplemail.head.cc.cc) {set topic .simplemail.head.cc}
set helpCmds(.simplemail.head.cc.label) {set topic .simplemail.head.cc}

set helpTopics(.simplemail.head.subject) {

This field intend to provide a summary, or indicate the nature, of the
message.

}
set helpCmds(.simplemail.head.subject.subject) {set topic .simplemail.head.subject}
set helpCmds(.simplemail.head.subject.label) {set topic .simplemail.head.subject}

set helpTopics(.simplemail.head.to) {

This field contains the identity of the primary recipients of the
message.

}
set helpCmds(.simplemail.head.to.to) {set topic .simplemail.head.to}
set helpCmds(.simplemail.head.to.label) {set topic .simplemail.head.to}

set helpTopics(customization) "
    
    To customize carnet you can:

    * sourced tcl/tk code from ~/.$INTERNAL(NAME)/custom. 
      ~/.$INTERNAL(NAME)/custom is sourced by $INTERNAL(NAME) once the
      normal starting operations have been successfully terminated.

    * use ~/.Xdefaults

    note that ~/.Xdefaults is loaded first, consequently the code in
    ~/.$INTERNAL(NAME)/custom may hide definitions in ~/.Xdefaults

___________________________________________________________________________

		Customization using ~/.$INTERNAL(NAME)/custom
___________________________________________________________________________


    Use tcl/tk commands. Here is some examples:

.carnet.data config -background gray70
.carnet.logbar config -background gray70
.carnet.logbar.message config -background gray70
.carnet.toolbar config -background gray70

    will set the background color to \"gray70\" for the frame
    .carnet.data

tk_setPalette SteelBlue1

    set the palette color of carnet to SteelBlue1

    One way to search for widget's names is to use the \"help on
    context\" (see the Help menu for more information). You may also
    set some appropriate bind such as:

bind . <F2> \{ 
     # set w to the window over the mouse
     set w \[winfo containing %X %Y\]
     # display a message in the logbar
     Message \"window name is \$w\"
\}

    Note that $INTERNAL(NAME)/custom is parsed after the interface is
    initialized, so you can overload functions. For example to confirm
    for quit just add a dialog box in the Quit function (from
    $INTERNAL(LIB_PATH)/proc.tcl):

proc Quit \{\} \{
    SaveOptions
    if \[CheckTouch\] \{ return \}
    # backup the the database
    if \{$INTERNAL(MODIFIED)\} \{ Backup \}
    if \[CheckSave\]  \{
         # ask to confirm before to quit
         if \[tk_dialog .delete \{Confirm Action\} \\
		 \{Really quit?\} \\
		 questhead 0  \"No\" \"Yes\" \] \{ exit \}
		 \}
\}

   Here is another example showing how to define a popup-menu. It uses
   MenuEdit a function defined in $INTERNAL(LIB_PATH)/app.tcl to
   define a menu (the edit menu). The bind command is used to bind
   this menu to the Button-3 modifier:

MenuEdit .mymenu
.mymenu config -tearoff 0 ;# remove tearoff
bind . <Button-3> \"tk_popup .mymenu %X %Y\"
.mymenu config -background gray70 ;# set the menu background to gray70

___________________________________________________________________________
   

		Customization using ~/.XDEFAULTS
___________________________________________________________________________


    Here is some simple commands to place in your ~/.Xdefaults showing
    how to customize colors and fonts. Update with 

    xrdb -load ~/.Xdefaults

    before to restart $INTERNAL(NAME)

! .Xdefaults customization for carnet
*carnet*background			: turquoise
! buttons in the menubar
*carnet*file*background			: LightSlateBlue
*carnet*edit*background			: LightSlateBlue
*carnet*options*background		: LightSlateBlue
*carnet*help*background			: LightSlateBlue

! the select button
*carnet*select*background		: LightSlateBlue

! the logbar color
*carnet*logbar*background		: violet

! the toolbar color
*carnet*toolbar*background		: violet

! change some toolbar buttons color
*carnet*toolbar*delete*background	: SlateBlue
*carnet*toolbar*update*background	: SlateBlue

! all the labels background
*carnet*label*background	: gray70

! the name and company colors
*carnet*data*name.name*background	: LightSlateBlue
*carnet*data*name.label*background	: blue
*carnet*data*company.company*background : LightSlateBlue
*carnet*data*company.label*background	: blue
*carnet*data*name.name*foreground	: white
*carnet*data*name.label*foreground	: white
*carnet*data*company.company*foreground : white
*carnet*data*company.label*foreground	: white

! data fonts 
*carnet*data*data*font : -*-courier-bold-r-*-*-*-160-*-*-*-*-iso8859-*

! search list colors
*carnet*data*search*search*foreground	: white
*carnet*data*search*search*background	: blue
"

set helpTopics(accents) {

    Accentuated characters can be inserted everywhere using special
    sequences. To insert "" you just have to type "a^". If you want
    to insert "a^" you have to insert a second "^" just after "",
    i.e. type "a^^".  Here is the list of supported accentuated
    characters and related bindings:

    CHARACTER   SEQUENCE	REMOVE SEQUENCE
    		A'		A''
    		E'		E''
    		I'		I''
    		O'		O''
    		U'		U''
    		Y'		Y''
    		a'		a''
    		e'		e''
    		i'		i''
    		o'		o''
    		u'		u''
    		y'		y''
    		A`		A``
    		E`		E``
    		I`		I``
    		o`		o``
    		U`		U``
    		a`		a``
    		e`		e``
    		i`		i``
    		o`		o``
    		u`		u``
    		A"		A""
    		E"		E""
    		I"		I""
    		O"		O""
    		U"		U""
    		a"		a""
    		e"		e""
    		i"		i""
    		o"		o""
    		u"		u""
    		y"		y""
    		C,		C,,
    		c,		c,,
    		A^		A^^
    		E^		E^^
    		I^		I^^
    		O^		O^^
    		U^		U^^
    		a^		a^^
    		e^		e^^
    		i^		i^^
    		o^		o^^
    		u^		u^^
    		N~		N~~
    		n~		n~~

}

