# Carnet : a simple addressbook written in tcl/tk
# Copyright (C) 1996 Nocera Luciano
# Revision: $Id: print.tcl,v 1.1 1997/03/11 21:38:49 lnocera Exp $
# State: Exp
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

#######################################################################
# Print toplevel                                                       #
#######################################################################

proc Print {} {
    
    global FORMAT CONFIG INTERNAL
    global valprint
    
    if [winfo exists .print] {
	focus .print
    } else {
	toplevel .print
	
	# some magic
	set w0 20
	set w1 38

	wm resizable .print 0 0
	wm title .print "$INTERNAL(NAME) print"
	wm iconname .print "$INTERNAL(NAME) print"
	
	# the title
	set f [frame .print.title -relief raised -bd 2]
	label $f.label -text "Print settings"
	pack $f.label -fill x -pady 5 -padx 5
	pack $f -fill x
	
	# a frame to define where to print
	set f [frame .print.where -relief raised -bd 2]
	label $f.label -text "Output file " -width $w0
	pack $f.label -side left -anchor e -pady 5 -padx 5
	entry $f.output -textvariable CONFIG(PRINT_FILE) -width $w1
	pack $f.output -side left -pady 5 -padx 5
	button $f.browse -text "Browse" \
	    -command {set Browse(DIR) CONFIG(PRINT_FILE)
set BROWSE(TITLE) {Select the output file}
set BROWSE(NAME) {Output File}
set file [BrowseInit]
if { $file != "" } { set CONFIG(PRINT_FILE) $file}}
	pack $f.browse -side left -pady 5 -padx 5
	pack $f -fill x 
	
	# a frame to define how to print
	set f [frame .print.format -relief raised -bd 2]
	label $f.label -text "Output format " -width $w0
	pack $f.label -side left -anchor e -pady 5 -padx 5
	radiobutton $f.latex -text "Latex" \
	    -variable CONFIG(PRINT_FORMAT) -value latex \
	    -command {
		regsub ".\[a-z\]*$" \
		    $CONFIG(PRINT_FILE) "\.tex" CONFIG(PRINT_FILE)
	    }
	radiobutton $f.normal -text "Ascii" \
	    -variable CONFIG(PRINT_FORMAT) -value ascii \
	    -command {
		regsub ".\[a-z\]*$" \
		    $CONFIG(PRINT_FILE) "\.ascii" CONFIG(PRINT_FILE)
	    }
	radiobutton $f.ps -text "Postcript" \
	    -variable CONFIG(PRINT_FORMAT) -value ps \
	    -command {
		regsub ".\[a-z\]*$" \
		    $CONFIG(PRINT_FILE) "\.ps" CONFIG(PRINT_FILE)
	    }
	
	pack $f.normal $f.ps $f.latex -side left -pady 5 -padx 5
	pack $f -fill x 
	
	# a frame to define what fields have to be printed
	set f [frame .print.what -relief raised -bd 2]
	label $f.label -text "Fields to print" -width $w0
	pack $f.label -side left -anchor ne -pady 5 -padx 5
	foreach i {Email Phone Address Notes} {
	    set ui [string toupper $i]
	    set li [string tolower $i]
	    checkbutton $f.$li -text $i -variable CONFIG(PRINT_$ui)
	    pack $f.$li -side top -pady 5 -padx 5 -anchor nw
	}
	pack $f -fill x
	
	# a frame to define what database to print
	set f [frame .print.database -relief raised -bd 2]
	label $f.label -text "Database" -width $w0
	pack $f.label -side left -anchor ne -pady 5 -padx 5
	
	radiobutton $f.private -text "All Private" \
	    -variable CONFIG(PRINT_WHAT) \
	    -value "private"
	radiobutton $f.public -text "All Public" \
	    -variable CONFIG(PRINT_WHAT) \
	    -value "public"
	radiobutton $f.current -text "Current Record" \
	    -variable CONFIG(PRINT_WHAT) \
	    -value "current"
	radiobutton $f.all -text "All" \
	    -variable CONFIG(PRINT_WHAT) \
	    -value "all"
	
	pack $f.current $f.public $f.private $f.all\
	    -side left -pady 5 -padx 5 -anchor nw
	# make sure config option is correctely setted
	
	pack $f -fill x
	
	# a button frame
	set f [frame .print.buttons -relief raised -bd 2]
	set f2 [frame $f.ok -relief sunken -bd 2]
	button $f2.ok -text "Print" -command {set valprint 1}
	pack $f2.ok -padx 5 -pady 5
	button $f.abort -text "Abort" -command {set valprint 0}

	pack $f2 $f.abort -padx 5 -pady 5 -side left -expand true
	pack $f -fill x
	focus $f2.ok 
	
	# help bindings
	bind .print <Any-F1>      {Help [winfo containing %X %Y] %X %Y}
	bind .print <Any-Help>    {Help [winfo containing %X %Y] %X %Y}
	bind .print <Shift-Button-3> {Help [winfo containing %X %Y] %X %Y}
	
	# the rest of the stuff
	tkwait variable valprint
	
	grab release .print
	catch {destroy .print}

	if { $valprint == 1 } {
	    
	    switch -- $CONFIG(PRINT_FORMAT) {
		"ascii" PrintAscii
		"latex" PrintLatex
		"ps"    PrintPs
	    }
	}
    }
}

proc PrintAscii {} {
    
    global FORMAT CONFIG DATABASE INTERNAL
    
    # define the target to print
    if {$CONFIG(PRINT_WHAT) == "current" } {
	set key  [GetCurrentKey]
	if {$key == ""} { 
	    tk_dialog .delete {Print Failed} \
			 "Print failed: no current record: select a record and retry" \
		{} 0  "Ok"
	    return
	}
    } else {
	# private or public
	set key  [lsort [array names DATABASE]]
    }
    
    # try to open the output file
    set file $CONFIG(PRINT_FILE)
    if [catch {open $file w} dbf] {
	Message "Couldn't open $file !"
	return
    }
    
    # print the header
    puts $dbf "=========================================================="
    puts $dbf "$INTERNAL(NAME) output"
    puts $dbf "printed records are    : $CONFIG(PRINT_WHAT) records"
    puts $dbf "date                   : [exec date +%D]"
    puts $dbf "file format            : $CONFIG(PRINT_FORMAT)"
    puts $dbf "=========================================================="
    puts $dbf "\n\n"
    puts $dbf "=========================================================="

    set letter ""
    foreach k $key {
	
	# define if the current record have to be printed
	set priv [lindex $DATABASE($k) 6]
	set record ""
	switch -- $CONFIG(PRINT_WHAT) {
	    "private" {if { $priv == "private" } {set record $DATABASE($k)} }
	    "public"  {if { $priv == "public" } {set record $DATABASE($k)}}
	    default   {set record $DATABASE($k)}
	}
	if {$record != ""} {    
	    set newletter [string toupper [string index [lindex $k 0] 0]]
	    if {$newletter != $letter} {
		set letter $newletter
		puts $dbf "                          $letter "
		puts $dbf "=========================================================="
	    }
	    set name [lindex $record 0]
	    set company [lindex $record 1]
	    set email  [lindex $record 2]
	    set phone [lindex $record 3]
	    set address [lindex $record 4]
	    set notes [lindex $record 5]
	    
	    puts -nonewline $dbf $name
	    puts $dbf "   --    $company"
	    if {$CONFIG(PRINT_EMAIL)} {puts $dbf $email}
	    if {$CONFIG(PRINT_PHONE)} {puts $dbf $phone}
	    if {$CONFIG(PRINT_ADDRESS)} {puts $dbf $address}
	    if {$CONFIG(PRINT_NOTES)} {puts $dbf $notes}
	
	    puts $dbf "=========================================================="
	}
    }
    
    # print the tail
    puts $dbf "=========================================================="
    puts $dbf "END OF FILE"
    puts $dbf "=========================================================="
	
    close $dbf
    PrintNotify
}

proc PrintNotify {} {
    Message "Print done"
    tk_dialog .delete {Print Done} \
	"Print done" \
	{} 0  "Ok"
}

proc PrintLatex {} {
    
    global FORMAT CONFIG DATABASE INTERNAL
    
    # define the target to print
    if { $CONFIG(PRINT_WHAT) == "current" } {
	set key  [GetCurrentKey]
	if { $key == "" } { 
	    tk_dialog .delete {Print Failed} \
		"Print failed: no current record, select a record and retry" \
		{} 0  "Ok"
	    return
	}
    } else {
	# private or public
	set key  [lsort [array names DATABASE]]
    }
    
    # try to open the output file
    set file $CONFIG(PRINT_FILE)
    if [catch {open $file w} dbf] {
	Message "Couldn't open $file !"
	return
    }
    
    # print the header
    set date [exec date]
    puts $dbf "% $INTERNAL(NAME)\n% printed records are $CONFIG(PRINT_WHAT)\n% date $date\n% file format : $CONFIG(PRINT_FORMAT)\n% use latex and dvips to generate a postscript file"
    puts $dbf "\\documentclass\[10pt\]{article}\n\\usepackage{isolatin1}\n\\unitlength 1cm\n\\parindent 0cm\n\\setlength{\\topmargin}{-0.5in}\n\\setlength{\\textheight}{9.2in}\n\\setlength{\\textwidth}{16cm}\n\\setlength{\\oddsidemargin}{0.0in}\n\\setlength{\\evensidemargin}{\\oddsidemargin}\n\\setlength{\\parskip}{0.50cm}\n\\setlength{\\parindent}{0in}\n\n\\newenvironment{people}{%\n\\begin{tabular}{l}\\begin{minipage}{8cm}}\n{\\end{minipage}\\end{tabular}\\hspace*{5mm}}\n\n\\begin{document}\n\\sloppy\n\\mbox{}\\hrulefill\\mbox{}\n\\begin{figure}\[htbp\]\n\\begin{picture}(8,2)(0,0)\n\\put(0,2.0){\\Large \\bf $INTERNAL(NAME) }\n\\put(0,1.0){{\\bf printed records are\\,:} $CONFIG(PRINT_WHAT) records}\n\\put(0,0.5){{\\bf date \\,: \$ $date \$} }\n\\end{picture}\n\\end{figure}\n\n\\mbox{}\\hrulefill\\mbox{}\n\{\\small"
    set letter ""
    set nb 0
    
    foreach k $key {
	
	# define if the current record have to be printed
	set priv [lindex $DATABASE($k) 6]
	set record ""
	switch -- $CONFIG(PRINT_WHAT) {
	    "private" {if { $priv == "private" } {set record $DATABASE($k)} }
	    "public"  {if { $priv == "public" } {set record $DATABASE($k)}}
	    default   {set record $DATABASE($k)}
	}	
	if {$record != ""} {
	    
	    set newletter [string toupper [string index [lindex $k 0] 0]]
	    incr nb 1
	    
	    if { $newletter != $letter} {
		set letter $newletter
                puts $dbf "\n\n{\\Large {\\bf $letter \~\~\~}}\\mbox{}\\hrulefill\\mbox{}\n\n"
	        set nb 0
	    }
	    
	    if {$nb == 2} {
		puts $dbf "\n"
		set nb 0
	    }
	    
	    set name [lindex $record 0]
	    set company [lindex $record 1]
	    set email  [lindex $record 2]
	    set phone [lindex $record 3]
	    set address [lindex $record 4]
	    set notes [lindex $record 5]
	    
	    # appropriately quotes some symbols
	    # & symbol
	    set item {&}
	    regsub -all "$item" $name "\\\\$item" name
	    regsub -all "$item" $company "\\\\$item" company
	    regsub -all "$item" $email "\\\\$item" email
	    regsub -all "$item" $phone "\\\\$item" phone
	    regsub -all "$item" $address "\\\\$item" address
	    regsub -all "$item" $notes "\\\\$item" notes

	    # dollar in a line
	    set item {\\$}
	    regsub -all "$item" $name "\\$item" name
	    regsub -all "$item" $company "\\$item" company
	    regsub -all "$item" $email "\\$item" email
	    regsub -all "$item" $phone "\\$item" phone
	    regsub -all "$item" $address "\\$item" address
	    regsub -all "$item" $notes "\\$item" notes

	    # last dollar in a line
	    set item {\\$$}
	    regsub -all "$item" $name "\\\\$" name
	    regsub -all "$item" $company "\\\\$item" company
	    regsub -all "$item" $email "\\\\$item" email
	    regsub -all "$item" $phone "\\\\$item" phone
	    regsub -all "$item" $address "\\\\$item" address
	    regsub -all "$item" $notes "\\\\$item" notes
	    # _ 
	    set item {_}
	    regsub -all "$item" $name "\\\\_" name
	    regsub -all "$item" $company "\\\\_" company
	    regsub -all "$item" $email "\\\\_" email
	    regsub -all "$item" $phone "\\\\_" phone
	    regsub -all "$item" $address "\\\\_" address
	    regsub -all "$item" $notes "\\\\_" notes
	    set item {\#}
	    regsub -all "$item" $name "\\\#" name
	    regsub -all "$item" $company "\\\#" company
	    regsub -all "$item" $email "\\\#" email
	    regsub -all "$item" $phone "\\\#" phone
	    regsub -all "$item" $address "\\\#" address
	    regsub -all "$item" $notes "\\\#" notes
	    
	    puts $dbf "\\begin{people}"
	    puts -nonewline $dbf "\\textbf{$name}"
	    puts $dbf "   --    \\textbf{$company}\\\\"
	    if {$CONFIG(PRINT_EMAIL)} {
		if {$email != ""} {
		    puts $dbf "\\texttt{$email}\\\\"
		}
	    }
	    # split multilines in single lines to print
	    if {$CONFIG(PRINT_PHONE)} {
		if {$phone != ""} {
		    foreach line [split $phone "\n"] {
			puts $dbf "\\textit{$line}\\\\"
		    }
		}
	    }
	    
	    if {$CONFIG(PRINT_ADDRESS)} {
		if {$address != "" } {
		    foreach line [split $address "\n"] {
			puts $dbf "\\textit{$line}\\\\"
		    }
		}
	    }
	    if {$CONFIG(PRINT_NOTES)} {
		if {$notes != ""} {
		    foreach line [split $notes "\n"] {
			puts $dbf "\\textit{$line}\\\\"
		    }
		}
	    }
	    
	puts $dbf "\\end{people}"
	}
    }
    
    # print the tail
    puts $dbf "\}\n\\end{document}%\n%END OF FILE"
    close $dbf
    PrintNotify
}

proc PrintPs {} {
    global FORMAT CONFIG DATABASE INTERNAL
    global pscont pspage

    # define the target to print
    if { $CONFIG(PRINT_WHAT) == "current" } {
	set key  [GetCurrentKey]
	if { $key == "" } { 
	    tk_dialog .delete {Print Failed} \
		"Print failed: no current record, select a record and retry" \
		{} 0  "Ok"
	    return
	}
    } else {
	# private or public
	set key  [lsort [array names DATABASE]]
    }
    
    # try to open the output file
    set file $CONFIG(PRINT_FILE)
    if [catch {open $file w} dbf] {
	Message "Couldn't open $file !"
	return
    }
    
    # print the header
    set date [exec date]
    puts $dbf "%!PS-Adobe-1.0
%%Title: $INTERNAL(NAME)
%%Creator: $INTERNAL(NAME)
%%CreationDate: [exec date +%D]
%% DocumentFonts: Helvetica Helvetica-Bold Courier Courier-Bold Courier-Oblique Courier-BoldOblique
%%Pages: (atend)
%%EndComments

/Duplex false def
/PrintHeader true def
/PrintHeaderFrame true def
/ShowNofN true def
/LeftMargin 72 def
/RightMargin 72 def
/BottomMargin 36 def
/TopMargin 72 def
/PrintWidth 468 def
/PrintHeight 684 def
/LineHeight 11.29 def
% ISOLatin1Encoding stolen from ps_init.ps in GhostScript 2.6.1.4:
% If the ISOLatin1Encoding vector isn't known, define it.
/ISOLatin1Encoding where { pop } {
% Define the ISO Latin-1 encoding vector.
% The first half is the same as the standard encoding,
% except for minus instead of hyphen at code 055.
/ISOLatin1Encoding
StandardEncoding 0 45 getinterval aload pop
    /minus
StandardEncoding 46 82 getinterval aload pop
%*** NOTE: the following are missing in the Adobe documentation,
%*** but appear in the displayed table:
%*** macron at 0225, dieresis at 0230, cedilla at 0233, space at 0240.
% x
    /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef
    /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef
    /dotlessi /grave /acute /circumflex /tilde /macron /breve /dotaccent
    /dieresis /.notdef /ring /cedilla /.notdef /hungarumlaut /ogonek /caron
% x
    /space /exclamdown /cent /sterling
	/currency /yen /brokenbar /section
    /dieresis /copyright /ordfeminine /guillemotleft
	/logicalnot /hyphen /registered /macron
    /degree /plusminus /twosuperior /threesuperior
	/acute /mu /paragraph /periodcentered
    /cedilla /onesuperior /ordmasculine /guillemotright
	/onequarter /onehalf /threequarters /questiondown
% x
    /Agrave /Aacute /Acircumflex /Atilde
	/Adieresis /Aring /AE /Ccedilla
    /Egrave /Eacute /Ecircumflex /Edieresis
	/Igrave /Iacute /Icircumflex /Idieresis
    /Eth /Ntilde /Ograve /Oacute
	/Ocircumflex /Otilde /Odieresis /multiply
    /Oslash /Ugrave /Uacute /Ucircumflex
	/Udieresis /Yacute /Thorn /germandbls
% x
    /agrave /aacute /acircumflex /atilde
	/adieresis /aring /ae /ccedilla
    /egrave /eacute /ecircumflex /edieresis
	/igrave /iacute /icircumflex /idieresis
    /eth /ntilde /ograve /oacute
	/ocircumflex /otilde /odieresis /divide
    /oslash /ugrave /uacute /ucircumflex
	/udieresis /yacute /thorn /ydieresis
256 packedarray def
} ifelse

/reencodeFontISO { %def
  dup
  length 5 add dict			% Make a new font (a new dict
					% the same size as the old
					% one) with room for our new
					% symbols.

  begin					% Make the new font the
					% current dictionary.


    { 1 index /FID ne
      { def } { pop pop } ifelse
    } forall				% Copy each of the symbols
					% from the old dictionary to
					% the new except for the font
					% ID.

    /Encoding ISOLatin1Encoding def	% Override the encoding with
					% the ISOLatin1 encoding.

    % Use the font's bounding box to determine the ascent, descent,
    % and overall height; don't forget that these values have to be
    % transformed using the font's matrix.
    FontBBox
    FontMatrix transform /Ascent exch def pop
    FontMatrix transform /Descent exch def pop
    /FontHeight Ascent Descent sub def

    % Define these in case they're not in the FontInfo (also, here
    % they're easier to get to.
    /UnderlinePosition 1 def
    /UnderlineThickness 1 def

    % Get the underline position and thickness if they're defined.
    currentdict /FontInfo known {
      FontInfo

      dup /UnderlinePosition known {
	dup /UnderlinePosition get
	0 exch FontMatrix transform exch pop
	/UnderlinePosition exch def
      } if

      dup /UnderlineThickness known {
	/UnderlineThickness get
	0 exch FontMatrix transform exch pop
	/UnderlineThickness exch def
      } if

    } if

    currentdict				% Leave the new font on the
					% stack

    end					% Stop using the font as the
					% current dictionary.

    definefont				% Put the font into the font
					% dictionary

    pop					% Discard the returned font.
} bind def

/Font {
  findfont exch scalefont reencodeFontISO
} def

/F {					% Font select
  findfont
  dup /Ascent get /Ascent exch def
  dup /Descent get /Descent exch def
  dup /FontHeight get /FontHeight exch def
  dup /UnderlinePosition get /UnderlinePosition exch def
  dup /UnderlineThickness get /UnderlineThickness exch def
  setfont
} def

/FG /setrgbcolor load def

/bg false def
/BG {
  dup /bg exch def
  { mark 4 1 roll ] /bgcolor exch def } if
} def

/dobackground {				% width --
  currentpoint
  gsave
    newpath
    moveto
    0 Ascent rmoveto
    dup 0 rlineto
    0 Descent Ascent sub rlineto
    neg 0 rlineto
    closepath
    bgcolor aload pop setrgbcolor
    fill
  grestore
} def

/dobackgroundstring {			% string --
  stringwidth pop
  dobackground
} def

/dounderline {				% fromx fromy --
  currentpoint
  gsave
    UnderlineThickness setlinewidth
    4 2 roll
    UnderlinePosition add moveto
    UnderlinePosition add lineto
    stroke
  grestore
} def

/eolbg {
  currentpoint pop
  PrintWidth LeftMargin add exch sub dobackground
} def

/eolul {
  currentpoint exch pop
  PrintWidth LeftMargin add exch dounderline
} def

/SL {					% Soft Linefeed
  bg { eolbg } if
  ul { eolul } if
  currentpoint LineHeight sub LeftMargin exch moveto pop
} def

/HL /SL load def			% Hard Linefeed

/sp1 { currentpoint 3 -1 roll } def

% Some debug
/dcp { currentpoint exch 40 string cvs print (, ) print = } def
/dp { print 2 copy
   exch 40 string cvs print (, ) print = } def

/S {
  bg { dup dobackgroundstring } if
  ul { sp1 } if
  show
  ul { dounderline } if
} def

/W {
  ul { sp1 } if
  ( ) stringwidth			% Get the width of a space
  pop					% Discard the Y component
  mul					% Multiply the width of a
					% space by the number of
					% spaces to plot
  bg { dup dobackground } if
  0 rmoveto
  ul { dounderline } if
} def

/BeginDSCPage {
  /vmstate save def
} def

/BeginPage {
  PrintHeader {
    PrintHeaderFrame { HeaderFrame } if
    HeaderText
  } if
  LeftMargin
  BottomMargin PrintHeight add
  moveto				% move to where printing will
					% start.
} def

/EndPage {
  bg { eolbg } if
  ul { eolul } if
  showpage				% Spit out a page
} def

/EndDSCPage {
  vmstate restore
} def

/ul false def

/UL { /ul exch def } def

/h0 14 /Helvetica-Bold Font
/h1 12 /Helvetica Font

/h1 F

/HeaderLineHeight FontHeight def
/HeaderDescent Descent def
/HeaderPad 2 def

/SetHeaderLines {
  /HeaderOffset TopMargin 2 div def
  /HeaderLines exch def
  /HeaderHeight HeaderLines HeaderLineHeight mul HeaderPad 2 mul add def
  /PrintHeight PrintHeight HeaderHeight sub def
} def

/HeaderFrameStart {
  LeftMargin BottomMargin PrintHeight add HeaderOffset add
} def

/HeaderFramePath {
  PrintWidth 0 rlineto
  0 HeaderHeight rlineto
  PrintWidth neg 0 rlineto
  0 HeaderHeight neg rlineto
} def

/HeaderFrame {
  gsave
    0.4 setlinewidth
    HeaderFrameStart moveto
    1 -1 rmoveto
    HeaderFramePath
    0 setgray fill
    HeaderFrameStart moveto
    HeaderFramePath
    gsave 0.9 setgray fill grestore
    gsave 0 setgray stroke grestore
  grestore
} def

/HeaderStart {
  HeaderFrameStart
  exch HeaderPad add exch
  HeaderLineHeight HeaderLines 1 sub mul add HeaderDescent sub HeaderPad add
} def

/strcat {
  dup length 3 -1 roll dup length dup 4 -1 roll add string dup
  0 5 -1 roll putinterval
  dup 4 2 roll exch putinterval
} def

/pagenumberstring {
  PageNumber 32 string cvs
} def

/HeaderText {
  HeaderStart moveto

  HeaderLinesRight HeaderLinesLeft
  Duplex PageNumber 1 and 0 eq and { exch } if

  {
    aload pop
    exch F
    gsave
      dup xcheck { exec } if
      show
    grestore
    0 HeaderLineHeight neg rmoveto
  } forall

  HeaderStart moveto

   {
    aload pop
    exch F
    gsave
      dup xcheck { exec } if
      dup stringwidth pop
      PrintWidth exch sub HeaderPad 2 mul sub 0 rmoveto
      show
    grestore
    0 HeaderLineHeight neg rmoveto
  } forall
} def

/ReportFontInfo {
  2 copy
  /t0 3 1 roll Font
  /t0 F
  /lh FontHeight def
  /sw ( ) stringwidth pop def
  /aw (01234567890abcdefghijklmnopqrstuvwxyz) dup length exch
  stringwidth pop exch div def
  /t1 12 /Helvetica-Oblique Font
  /t1 F
  72 72 moveto
  gsave
    (For ) show
    128 string cvs show
    ( ) show
    32 string cvs show
    ( point, the line height is ) show
    lh 32 string cvs show
    (, the space width is ) show
    sw 32 string cvs show
    (,) show
  grestore
  0 FontHeight neg rmoveto
  (and a crude estimate of average character width is ) show
  aw 32 string cvs show
  (.) show
  showpage
} def

% 10 /Courier ReportFontInfo
/f0 10 /Courier Font
/f1 10 /Courier-Bold Font
/f2 10 /Courier-Oblique Font
%%EndPrologue

%%Page: 1 1
BeginDSCPage
/PageNumber 1 def
/HeaderLinesLeft \[
  \[ /h0 ($INTERNAL(NAME)) \]
  \[ /h1 ($file) \]
\] def
/HeaderLinesRight \[
   \[ /h0 /pagenumberstring load \]
\[ /h1 ([exec date +%D]) \]
\] def
2 SetHeaderLines
BeginPage
/f0 F
false BG
0.0 0.0 0.0 FG
false UL
"
    set letter ""
    set pspage 1
    set pscont 0

    foreach k $key {
	# define if the current record have to be printed
	set priv [lindex $DATABASE($k) 6]
	set record ""
	switch -- $CONFIG(PRINT_WHAT) {
	    "private" {if { $priv == "private" } {set record $DATABASE($k)} }
	    "public"  {if { $priv == "public" } {set record $DATABASE($k)}}
	    default   {set record $DATABASE($k)}
	}	
	if {$record != ""} {
	    set newletter [string toupper [string index [lindex $k 0] 0]]
	    if { $newletter != $letter} {
		set letter $newletter
		regsub -all {\(} $letter "\\(" letter
		regsub -all {\)} $letter "\\(" letter
                PutsPs $dbf "/f0 F\nfalse BG\nfalse UL\nHL\n0.8 0.8 0.8 true BG
( $letter)S\nHL\n/f0 F\nfalse BG\n0.0 0.0 0.0 FG\nfalse UL\nHL\n"
	    }
	    
	    set name [lindex $record 0]
	    set company [lindex $record 1]
	    set email  [lindex $record 2]
	    set phone [lindex $record 3]
	    set address [lindex $record 4]
	    set notes [lindex $record 5]

	    # _ 
	    set item {\(}
	    regsub -all "$item" $name "\\(" name
	    regsub -all "$item" $company "\\(" company
	    regsub -all "$item" $email "\\(" email
	    regsub -all "$item" $phone "\\(" phone
	    regsub -all "$item" $address "\\(" address
	    regsub -all "$item" $notes "\\(" notes
	    set item {\)}
	    regsub -all "$item" $name "\\)" name
	    regsub -all "$item" $company "\\)" company
	    regsub -all "$item" $email "\\)" email
	    regsub -all "$item" $phone "\\)" phone
	    regsub -all "$item" $address "\\)" address
	    regsub -all "$item" $notes "\\)" notes

	    PutsPs $dbf "/f1 F\n1.0 1.0 1.0 true BG\n($name)S"
            puts $dbf "/f1 F\n1.0 1.0 1.0 true BG\n(--)S"
            puts $dbf "/f1 F\n1.0 1.0 1.0 true BG\n($company)S\nHL"
	    if {$CONFIG(PRINT_EMAIL)} {
		if {$email != ""} {
		    PutsPs $dbf "/f2 F\n1.0 1.0 1.0 true BG\n($email)S\nHL"
		}
	    }
            puts -nonewline $dbf "/f0 F\nfalse BG"
	    # split multilines in single lines to print
	    if {$CONFIG(PRINT_PHONE)} {
		if {$phone != ""} {
		    foreach line [split $phone "\n"] {
			PutsPs $dbf "($line)S\nHL"
		    }
		}
	    }
	    
	    if {$CONFIG(PRINT_ADDRESS)} {
		if {$address != "" } {
		    foreach line [split $address "\n"] {
			PutsPs $dbf "($line)S\nHL"
		    }
		}
	    }
	    if {$CONFIG(PRINT_NOTES)} {
		if {$notes != ""} {
		    foreach line [split $notes "\n"] {
			PutsPs $dbf "($line)S\nHL"
		    }
		}
	    }
	    
	puts $dbf "/f0 F\nfalse BG\nHL"
	}
    }
    
    # print the tail
    puts $dbf "EndPage\nEndDSCPage\n%%Trailer\n%%Pages: $pspage\n"
    close $dbf
    PrintNotify
}

proc PutsPs {where what} { 
    global INTERNAL
    global pscont pspage

    incr pscont 1
    if {$pscont > 40} {
	incr pspage 1
	set pscont 1
	puts $where "
EndPage
EndDSCPage

%%Page: $pspage $pspage
BeginDSCPage
/PageNumber $pspage def
/HeaderLinesLeft \[
  \[ /h0 ($INTERNAL(NAME)) \]
  \[ /h1 (-)\]
\] def
/HeaderLinesRight \[
   \[ /h0 /pagenumberstring load \]
\[ /h1 ([exec date +%D]) \]
\] def
2 SetHeaderLines
BeginPage
/f0 F
false BG
0.0 0.0 0.0 FG
false UL"
    }
    puts $where $what
}


