# Carnet : a simple addressbook written in tcl/tk
# Copyright (C) 1996 Nocera Luciano
# Revision: $Id: simplemail.tcl,v 1.1 1997/03/11 21:38:49 lnocera Exp $
# State: Exp
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

# simple mail interface

proc SimpleMail {{to {}} {subject {}} {cc {}} {bcc {}} {text {}}} {
    
    global env MAIL CONFIG

    if [info exists env(USER)] {
	set user $env(USER)
    } elseif [info exists env(LOGNAME)] {
	set user $env(LOGNAME)
    } else {
	set user [exec whoami]
    }

    if [winfo exists .simplemail] {
	focus .simplemail
    } else {
	toplevel .simplemail
	wm minsize .simplemail 597 511

	set f [frame .simplemail.command -relief raised -bd 2]
	set MAIL(command) $f

	# file menu
	menubutton $f.file -text File -underline 0
	$f.file config -menu $f.file.m
	menu  $f.file.m
	$f.file.m add command -label "Send\t" \
	    -command {set MAIL(send) 1} -underline 0
	$f.file.m add command -label "Quit (abort message)" \
	    -underline 0 \
	    -command { SimpleMailAbort }
	
	# mode menu
	menubutton $f.edit -text Edit -underline 0
	$f.edit config -menu $f.edit.m
	menu $f.edit.m
    	$f.edit.m add command -label "Go to Field:\t" 
	$f.edit.m add separator
	$f.edit.m add command -label "To:\t" -command {focus $MAIL(to)} -underline 0
	$f.edit.m add command -label "Subject:\t" -command {focus $MAIL(subject)} -underline 0
	$f.edit.m add command -label "CC:\t" -command {focus $MAIL(cc)} -underline 0
	$f.edit.m add command -label "BCC:\t" -command {focus $MAIL(bcc)} -underline 0
	$f.edit.m add command -label "Message:\t" -command {focus $MAIL(text)} -underline 0
	$f.edit.m add separator
	$f.edit.m add command -label "Sign Message\t" -command {SimpleMailSign} -underline 0
	$f.edit.m add command -label "Insert File...\t" -command {SimpleMailInsert} -underline 0
	
	# help menu
	button $f.help -text Help -command SimpleMailHelp -underline 0 -relief flat
	
	pack $f.file  $f.edit -side left -fill x -padx 10
	pack $f.help -side right -padx 10
	pack $f -side top -fill x
	
	# the mail entries
	set w0 9
	set f [frame .simplemail.head -relief raised -bd 2]

	set f1 [frame $f.to]
	label $f1.label -text "To:" -width $w0 -anchor e -underline 0
	set MAIL(to) [entry $f1.to]
	pack $f1.label -side left 
	pack $MAIL(to) -fill x -expand true

	set f2 [frame $f.subject]
	label $f2.label -text "Subject:" -width $w0 -anchor e -underline 0
	set MAIL(subject) [entry $f2.subject]
	pack $f2.label -side left 
	pack $MAIL(subject) -fill x -expand true
	
	set f3 [frame $f.cc]
	label $f3.label -text "CC:" -width $w0 -anchor e -underline 0
	set MAIL(cc) [entry $f3.cc]
	pack $f3.label -side left 
	pack $MAIL(cc) -fill x -expand true
	
	set f4 [frame $f.bcc]
	label $f4.label -text "BCC:" -width $w0 -anchor e -underline 0
	set MAIL(bcc) [entry $f4.bcc]
	pack $f4.label -side left 
	pack $MAIL(bcc) -fill x -expand true
	
	set f5 [frame $f.text]
	label $f5.label -text "Message:" -width 10 -anchor e -underline 0
	set MAIL(text) [text $f5.text -wrap word \
			    -yscrollcommand [list $f5.yscroll set]]
	scrollbar $f5.yscroll -orient vertical -command [list $f5.text yview]
	pack $f5.label
	pack $f5.yscroll -side right -fill y
	pack $f5.text -fill both -expand true 
	
	pack $f1 $f2 $f3 $f4 -fill x
	pack $f5 -expand true -fill both
	pack $f -expand true -fill both

	# a button frame
	set f [frame .simplemail.buttons -relief raised -bd 2]
	set f2 [frame $f.ok -relief sunken -bd 2]
	button $f2.ok -text "Send Mail" -command {set MAIL(send) 1}
	pack $f2.ok
	button $f.abort -text "Abort" -command { SimpleMailAbort }
	pack $f2 $f.abort -side left -expand true
	pack $f -fill x
	focus $f2.ok 
	
	# create the mail
	$MAIL(to) insert insert "$to"
	# $MAIL(cc) insert insert "$user"
	$MAIL(cc) insert insert $cc
	$MAIL(bcc) insert insert $bcc
	$MAIL(subject) insert insert $subject
	
	if { $text != {} } {
	    $MAIL(text) insert insert $text
	    $MAIL(text) see end
	    focus $MAIL(text)
	} else {
	    focus $MAIL(subject)
	}

	# .simplemail help on context bindings
	bind .simplemail <Any-F1>      {Help [winfo containing %X %Y] %X %Y}
	bind .simplemail <Any-Help>    {Help [winfo containing %X %Y] %X %Y}
	bind .simplemail <Shift-Button-3> {Help [winfo containing %X %Y] %X %Y}

	bind .simplemail <Control-c><Control-c> {set MAIL(send) 1}
	bind .simplemail <Alt-q> {
	    if [tk_dialog .delete {Confirm Action} \
		    "Really abort composition ?" \
		    {} 0  "No" "Yes"] {
		set MAIL(send) 0
	    }}
	
	bind .simplemail <Alt-t> "focus $MAIL(to)"
	bind .simplemail <Alt-s> "focus $MAIL(subject)"
	bind .simplemail <Alt-c> "focus $MAIL(cc)"
	bind .simplemail <Alt-b> "focus $MAIL(bcc)"
	bind .simplemail <Alt-m> "focus $MAIL(text)"
	
	if { $CONFIG(USE_ACCENTS) } {
	    AccentsBind $MAIL(subject) ;# accents
	    AccentsBind $MAIL(text) ;# accents
	}
	
	# the rest of the stuff
	tkwait variable MAIL(send)
	
	grab release .simplemail

	if {$MAIL(send) == 1} {
	    
	    # get current fields
	    regsub -all "," [$MAIL(to) get] " " to
	    set subject [$MAIL(subject) get]
	    regsub -all ","  [$MAIL(cc) get] " " cc
	     regsub -all ","  [$MAIL(bcc) get] " " bcc
	    set text [$MAIL(text) get 1.0 end]
	    destroy .simplemail
	    
	    # send the mail
	    if [catch {eval {exec echo "To: $to
Subject: $subject
Cc: $cc
Bcc: $bcc

$text
." | $MAIL(mailcommand) $to $cc $bcc}} err] {
		tk_dialog .delete {Send failed} \
		    "Send failed: $err. Message saved in ~/dead.letter" \
		    {} 0  "Ok"
		eval {exec echo "To: $to 
Subject: $subject 
CC: $cc 
BCC: $bcc 
-------------------
$text 
" | cat > $env(HOME)/dead.letter}
	    }
	} else {
	    destroy .simplemail
	}
    }
}


proc SimpleMailHelp {} {

    tk_dialog .delete {SimpleMail Help} \
	"Simple Mail Interface: for more information use the help on context (move the mouse over the window you're curious about and press the Help or F1 or Shift-Button-3 keys)." \
	info 0  "Ok"
}

proc SimpleMailInsert {} {

    global MAIL
    
    set file [BrowseInit]
    if {$file != {}} {
	if [catch {open $file r} fh] {
	    tk_dialog .delete {Load failed} \
		"SimpleMail: Couldn't open $file." \
		error 0  "Ok"
	} else {
	    set contents [read $fh]
	    $MAIL(text) insert insert $contents
	    close $fh
	} 
    }
}

proc SimpleMailSign {} {

    global MAIL env
    
    
    set file "$env(HOME)/.signature"
    
    if [file exists $file] {
	if [catch {open $file r} fh] {
	    tk_dialog .delete {Load failed} \
		"SimpleMail: Couldn't open $file." \
		error 0  "Ok"
	} else {
	    set contents [read $fh]
	    set index [$MAIL(text) index insert]
	    $MAIL(text) insert insert "\n"
	    $MAIL(text) insert insert $contents
	    # don't know how to move to index
	    $MAIL(text) see $index
	    close $fh
	} 
    } else {
	tk_dialog .delete {Load failed} \
		"SimpleMail: $file doesn't exist." \
	    error 0  "Ok"
    }
}

proc SimpleMailAbort {} {
    global MAIL
    if ![tk_dialog .delete {Confirm Action} \
	    "Really abort composition ?" \
	    {} 0  "Yes" "No"] { set MAIL(send) 0 }
}