/*
 *  Michael K Ganley
 *  Copyright 1997
 *  Super simple C + Tk
 *  Tk4.1
 *  Tcl7.5
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <tk.h>

typedef int (Tcl_myAppInitProc) _ANSI_ARGS_((int argc, char **argv, Tcl_Interp *interp ));

void Tk_myMain _ANSI_ARGS_((int argc, char **argv, Tcl_myAppInitProc *appInitProc));
int Tcl_myAppInit _ANSI_ARGS_((int argc, char **argv, Tcl_Interp *interp ));
int getSumExampleCmd _ANSI_ARGS_((ClientData, Tcl_Interp *, int, char **));

static Tcl_Interp *interp;	
static int alive = 1;

/*
 *
 * main --
 *
 */
main(int argc, char *argv[]) 
{
    Tk_myMain( argc, argv, Tcl_myAppInit);
	return(0);
}


/*
 *
 * Tk_myMain ----
 *
 */
void Tk_myMain( int argc, char **argv, Tcl_myAppInitProc *myappInitProc )
{

Tcl_FindExecutable( argv[0] );
interp = Tcl_CreateInterp();

if( ( *myappInitProc )( argc, argv, interp ) != TCL_OK ) 
    {
	fprintf( stderr, "\nUnexpected application error!" );
    }

Tcl_Exit(0);

}


/*
 *
 * Tcl_myAppInit --
 * 
 */
int Tcl_myAppInit( int argc, char *argv[], Tcl_Interp *interp )
{

	int		    retcode;
	Tk_Window	mainWindow;
	int			share2 = 0;

	if( Tcl_Init(interp) == TCL_ERROR ) {
		fprintf(stderr, "Tcl_Init failed: %s\n", interp->result);
		exit(1);
	}

	if( Tk_Init(interp) == TCL_ERROR ) {
		fprintf(stderr, "Tk_Init failed: %s\n", interp->result);
		exit(1);
	}

	/* register your own commands */
	Tcl_CreateCommand( interp, "getSumExample", getSumExampleCmd,
		(ClientData) NULL, (void (*) ()) NULL);


	mainWindow = Tk_MainWindow(interp);

	Tcl_LinkVar( interp, "alive", ( char * )&alive, TCL_LINK_INT );
	Tcl_LinkVar( interp, "share2", ( char * )&share2, TCL_LINK_INT );
	
	retcode = Tcl_EvalFile( interp, "simple.tk" );

	if(retcode != TCL_OK) {
		fprintf(stderr, "\nGUI: Initialization ERROR: ");
		fprintf(stderr, "%s\n", interp->result);
		exit(1);
	}

	/* main loop */

	do {

		Tcl_DoOneEvent(TK_DONT_WAIT);

		/* illustrate activity occuring between C and GUI */
		share2++;
		if( share2 == 1000000 )
			{
			share2 = 0;
			}

		} while( alive == 1 );
		 

	return(0);

}

/*
 *
 * Get sum example command 
 *
 */
int getSumExampleCmd _ANSI_ARGS_((ClientData clientData, 
	Tcl_Interp *interp, int argc, char **argv))
{
	double		var1;
	double  	var2;

	/* get passed parameters to sum */

	if( Tcl_GetDouble( interp, argv[1], &var1 ) != TCL_OK )
		{
		return TCL_ERROR;
		}

	if( Tcl_GetDouble( interp, argv[2], &var2 ) != TCL_OK )
		{
		return TCL_ERROR;
		}

	sprintf( interp->result, "%f", var1+var2 );
	return TCL_OK ;

}



/* eof */

