# --- database.tcl --- Procedures that modify the database based on queries

package require secret1 1.0

set MentalStates { Dispondent Confident Elated Serene Depressed Angry Vengeful Euphoric }
set Desires { "Love and affection" "Respect" "Honesty" "Attention" "Money" "Loyalty" }
set Persons { "Bill" "Monica" "Hillary" "Ken" "Saddam" "Linda" }

# Some constants to make the code easier to read and understand..

global Bill Monica Saddam Hillary Ken Linda

set Bill 0
set Monica 1
set Hillary 2
set Ken 3
set Saddam 4
set Linda 5

# Create a fondest desire

proc FondestDesire { desire object } {

	global Desires Persons

	return [format "%s from %s" [lindex $Desires $desire] [lindex $Persons $object]]
	}

# A small database for use by the service

set Database(monica,phonenumber) "1-806-555-1212"
set Database(monica,bestfriend) [lindex $Persons $Bill]
set Database(monica,fondestdesire) [FondestDesire 0 $Bill]
set Database(monica,mentalstate) [lindex $MentalStates 0]
set Database(bill,phonenumber) "1-602-555-1212"
set Database(bill,bestfriend) [lindex $Persons $Hillary]
set Database(bill,fondestdesire) [FondestDesire 1 $Saddam]
set Database(bill,mentalstate) [lindex $MentalStates 1]
set Database(saddam,phonenumber) "011-05-43928"
set Database(saddam,fondestdesire) [FondestDesire 1 $Bill]
set Database(saddam,bestfriend) [lindex $Persons $Monica]
set Database(saddam,mentalstate) [lindex $MentalStates 2]
set Database(hillary,phonenumber) "1-405-555-1212"
set Database(hillary,fondestdesire) [FondestDesire 1 $Monica]
set Database(hillary,bestfriend) [lindex $Persons $Linda]
set Database(hillary,mentalstate) [lindex $MentalStates 3]

# Generate a key to the database

proc Key { topic item } {

	return [format "%s,%s" [string tolower $topic] [string tolower $item]]
	}

# Change a value in the database

proc SetItem { name item value } {

	global Database

	set record [Key $name $item]

	if  [info exists Database($record)] {
		if { $Database($record) != $value } {
			set Database($record) $value
			}
		}
	}

# Update the database to make this demo a little more interesting...

proc UpdateDatabase { user topic item } {

	global Database Bill Monica Saddam Hillary Ken Linda

	set user [string tolower $user]
	set topic [string tolower $topic]
	set item [string tolower $item]

			switch -exact -- $user {
		bill { HandleBill $topic $item }
		monica { HandleMonica $topic $item }
		hillary { HandleHillary $topic $item }
		saddam { HandleSaddam $topic $item }
		linda { HandleLinda $topic $item }
		ken { HandleKen $topic $item }
		default { puts stdout "User $user not known" }
		}
	}

# Handle bill

proc HandleBill { topic item } {

	global Database Bill Monica Saddam Hillary Ken Linda

		switch -exact -- $topic {
			monica {	switch -exact -- $item {
						phonenumber { SetItem monica mentalstate Elated }
						mentalstate { SetItem monica mentalstate Euphoric }
						fondestdesire { SetItem monica mentalstate Depressed }
						bestfriend { SetItem monica mentalstate Dispondent }
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
							}
						}
			hillary	{ switch -exact -- $item {
						phonenumber { 	SetItem hillary mentalstate Curious
											SetItem monica mentalstate Worried
											SetItem monica bestfriend Linda
											}
						mentalstate { 	SetItem hillary mentalstate Suspicious
											SetItem monica mentalstate Jealous
											SetItem hillary bestfriend Saddam
											}
						fondestdesire {	SetItem hillary mentalstate Interested
												SetItem monica bestfriend Ken
												SetItem monica mentalstate Vengeful
												}
						bestfriend { SetItem hillary mentalstate Incredulous
										 SetItem hillary fondestdesire "Respect from Bill"
										 SetItem hillary bestfriend Linda
										 SetItem monica mentalstate Depressed
										 }
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
							}
						}
			saddam { switch -exact -- $item {
						phonenumber { 	SetItem saddam mentalstate Euphoric
											SetItem saddam bestfriend Ken
											SetItem saddam fondestdesire "Respect from somebody" }
						mentalstate { SetItem saddam mentalstate Arrogant }
						fondestdesire { SetItem saddam mentalstate Conciliatory }
						bestfriend { 	SetItem saddam mentalstate Alarmed
											SetItem hillary mentalstate Confused
											SetItem bill mentalstate Sly
											}
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
						}
					}
			default { puts stdout "Topic $topic not supported for $user" }
				}
		}

# Handle monica

proc HandleMonica { topic item } {

	global Database Bill Monica Saddam Hillary Ken Linda

		switch -exact -- $topic {
			bill { switch -exact -- $item {
						phonenumber {  SetItem bill mentalstate "Guardedly optimistic"
											SetItem hillary mentalstate Vengeful
											}
						mentalstate { 	SetItem bill mentalstate Elated
											}
						fondestdesire { SetItem bill mentalstate Secure
											 SetItem bill fondestdesire [FondestDesire 0 $Monica]
											 }
						bestfriend { SetItem bill bestfriend Monica
										 SetItem saddam mentalstate Omnipotent
										 }
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
							}
						}
			hillary { switch -exact -- $item {
						phonenumber { 	SetItem bill mentalstate Appalled
											SetItem saddam mentalstate Disquieted
											}
						mentalstate { 	SetItem bill mentalstate Worried
											SetItem monica mentalstate Confident
											}
						fondestdesire { SetItem bill mentalstate Horrified
											 SetItem bill fondestdesire [FondestDesire 5 $Hillary]
											 }
						bestfriend { 	SetItem hillary mentalstate "On Guard"
											SetItem monica fondestdesire [FondestDesire 1 $Linda]
											}
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
							}
						}
			saddam { switch -exact -- $item {
						phonenumber { 	SetItem bill mentalstate Alarmed
											SetItem saddam mentalstate Elated
											SetItem hillary mentalstate Relieved
											}
						mentalstate { 	SetItem monica mentalstate Confused
											SetItem hillary mentalstate Vengeful
											SetItem bill mentalstate Insulted
											}
						fondestdesire { 	SetItem monica fondestdesire [FondestDesire 0 $Saddam]
												SetItem hillary fondestdesire [FondestDesire 1 $Saddam]
												SetItem bill fondestdesire [FondestDesire 0 $Hillary]
												}
						bestfriend { 	SetItem saddam mentalstate Worried
											SetItem hillary mentalstate Smug
											SetItem bill mentalstate Anxious
											SetItem bill fondestdesire [FondestDesire 5 $Monica]
											SetItem saddam fondestdesire [FondestDesire 5 $Linda]
											}
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
						}
					}
			default { puts stdout "Topic $topic not supported for $user" }
				}
		}

# Handle Hillary

proc HandleHillary { topic item } {

	global Database Bill Monica Saddam Hillary Ken Linda

		switch -exact -- $topic {
			bill { switch -exact -- $item {
						phonenumber { 	SetItem bill fondestdesire [FondestDesire 5 $Monica]
											SetItem monica fondestdesire [FondestDesire 5 $Bill]
											SetItem saddam mentalstate Apprehensive
											}
						mentalstate { 	SetItem saddam mentalstate Cautious
											SetItem bill mentalstate Relieved
											SetItem monica mentalstate Fustrated
											}
						fondestdesire {	SetItem bill mentalstate Egoiste
												SetItem saddam mentalstate Depressed
												 }
						bestfriend { 	SetItem monica mentalstate Curious
											SetItem bill mentalstate Worried
											SetItem bill bestfriend Saddam
											SetItem hillary bestfriend Ken
											}
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
							}
						}
			saddam { switch -exact -- $item {
						phonenumber { 	SetItem saddam mentalstate Exhuberant
											SetItem bill mentalstate Dispondent
											SetItem bill bestfriend Ken
											SetItem hillary bestfriend Monica
											}
						mentalstate { 	SetItem saddam mentalstate Amused
											SetItem hillary mentalstate Angry
											SetItem hillary bestfriend Bill
											SetItem monica bestfriend Linda
											}
						fondestdesire { 	SetItem saddam mentalstate Shrewd
												SetItem saddam bestfriend Bill
												SetItem saddam fondestdesire [FondestDesire 0 $Bill]
												}
						bestfriend { 	SetItem bill mentalstate Panic
											SetItem bill bestfriend Ken
											SetItem monica bestfriend Bill
											}
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
							}
						}
			monica { switch -exact -- $item {
						phonenumber { 	SetItem bill mentalstate Desperate
											SetItem monica mentalstate Distressed
											SetItem hillary bestfriend Linda
											SetItem saddam bestfriend Ken
											}
						mentalstate { 	SetItem bill mentalstate Agonized
											SetItem hillary mentalstate Smug
											SetItem hillary bestfriend Ken
											SetItem monica mentalstate Aghast
											}
						fondestdesire { 	SetItem monica fondestdesire [FondestDesire 0 $Hillary]
												SetItem bill fondestdesire [FondestDesire 5 $Hillary]
												SetItem bill bestfriend Saddam
												}
						bestfriend { 	SetItem hillary mentalstate Vengeful
											SetItem saddam mentalstate Worried
											SetItem bill mentalstate Liberated
											}
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
						}
					}
			default { puts stdout "Topic $topic not supported for $user" }
				}
		}

# Handle saddam

proc HandleSaddam { topic item } {

	global Database Bill Monica Saddam Hillary Ken Linda

		switch -exact -- $topic {
			bill	{ switch -exact -- $item {
						phonenumber { 	SetItem bill mentalstate Dispondent
											SetItem monica mentalstate Lonely
											SetItem hillary mentalstate Fustrated
											}
						mentalstate { 	SetItem bill mentalstate Amused
											SetItem saddam mentalstate Angry
											SetItem saddam bestfriend Linda
											SetItem monica bestfriend Linda
											}
						fondestdesire { 	SetItem bill mentalstate Cagey
												SetItem bill bestfriend Saddam
												SetItem hillary mentalstate Disquiet
												}
						bestfriend { }
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
							}
						}
			monica { switch -exact -- $item {
						phonenumber { 	SetItem bill mentalstate Alarmed
											SetItem monica bestfriend Bill
											}
						mentalstate { }
						fondestdesire { }
						bestfriend { }
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
							}
						}
			hillary { switch -exact -- $item {
						phonenumber { 	SetItem hillary mentalstate Flattered
											SetItem hillary fondestdesire [FondestDesire 1 $Saddam]
											SetItem bill mentalstate Jealousy
											SetItem bill fondestdesire [FondestDesire 0 $Hillary]
											}
						mentalstate { }
						fondestdesire { }
						bestfriend { }
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
						}
					}
			default { puts stdout "Topic $topic not supported for $user" }
				}
		}

# Handle Linda

proc HandleLinda { topic item } {

	global Database Bill Monica Saddam Hillary Ken Linda

		switch -exact -- $topic {
			bill { switch -exact -- $item {
						phonenumber { 	SetItem bill mentalstate Aghast
											SetItem bill bestfriend Ken
											}
						mentalstate { }
						fondestdesire { }
						bestfriend { }
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
							}
						}
			hillary { switch -exact -- $item {
						phonenumber { 	SetItem hillary mentalstate Shocked
											SetItem hillary bestfriend Ken
											}
						mentalstate { 	}
						fondestdesire { }
						bestfriend { }
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
							}
						}
			monica { switch -exact -- $item {
						phonenumber { 	SetItem monica mentalstate Betrayed
											SetItem hillary mentalstate Vindicated
											SetItem bill mentalstate Anguish
											}
						mentalstate { }
						fondestdesire { }
						bestfriend { }
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
							}
						}
			saddam { switch -exact -- $item {
						phonenumber { 	puts stdout "Saddam Phone"
											SetItem saddam mentalstate Incredulous
											SetItem monica mentalstate Confused
											SetItem monica bestfriend Ken
											SetItem hillary bestfriend Linda
											}
						mentalstate { 	SetItem saddam mentalstate Appoplexique
											SetItem saddam bestfriend Ken
											SetItem hillary bestfriend Linda
											}
						fondestdesire { }
						bestfriend { }
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
						}
					}
			default { puts stdout "Topic $topic not supported for $user" }
				}
		}

# Handle Ken

proc HandleKen { topic item } {

	global Database Bill Monica Saddam Hillary Ken Linda

	switch -exact -- $topic {
			bill { switch -exact -- $item {
						phonenumber { 	SetItem bill mentalstate Anger
											SetItem bill bestfriend Saddam
											SetItem hillary bestfreind Linda
											}
						mentalstate { }
						fondestdesire { }
						bestfriend { }
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
							}
						}
			hillary { switch -exact -- $item {
						phonenumber { 	SetItem hillary mentalstate Amused
											SetItem bill mentalstate Amused
											SetItem monica mentalstate Amused
											SetItem saddam mentalstate Confused
											}
						mentalstate { 	SetItem hillary mentalstate Incredulous
											SetItem bill mentalstate Amazed
											}
						fondestdesire {set Database (hillary fondestdesire "Respect from Ken"
											set Database (bill fondestdesire "Loyalty from Hillary"
											set Database (monica fondestdesire "Loyalty from Ken"
											 }
						bestfriend { 	SetItem bill mentalstate Wary
											SetItem hillary mentalstate Angry
											SetItem monica mentalstate Relieved
											}
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
							}
						}
			monica { switch -exact -- $item {
						phonenumber { 	SetItem monica mentalstate Frightened
											SetItem bill mentalstate Uneasy
											SetItem bill fondestdesire [FondestDesire 5 $Monica]
											}
						mentalstate { 	SetItem bill mentalstate Agitated
											SetItem hillary mentalstate Happy
											SetItem saddam mentalstate Worried
											}
						fondestdesire { SetItem monica fondestdesire "Love and affection from Ken"
											SetItem bill mentalstate Depressed
											SetItem hillary mentalstate Elated
											}
						bestfriend { 	SetItem bill mentalstate Terrified
											SetItem hillary mentalstate Puzzeled
											SetItem saddam mentalstate Smug
											}
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
							}
						}
			saddam { switch -exact -- $item {
						phonenumber { 	SetItem bill mentalstate Elated
											SetItem saddam mentalstate Astounded
											SetItem hillary bestfriend Bill
											SetItem monica mentalstate Oblivious
											}
						mentalstate { 	SetItem saddam mentalstate Incredulous
											SetItem saddam fondestdesire "Respect from Ken"
											SetItem hillary bestfriend Bill
											SetItem bill bestfriend Monica
											}
						fondestdesire {SetItem bill mentalstate Alarmed
											SetItem hillary mentalstate Agressive
											SetItem monica mentalstate Lonely
											SetItem saddam mentalstate Thoughtfull
											 }
						bestfriend { SetItem saddam mentalstate Angry
										SetItem bill mentalstate Relieved
										SetItem hillary mentalstate Suspicious
										SetItem monica mentalstate Betrayed
										}
						default { puts stdout "Item $item not supported for topic $topic and user $user" }
						}
					}
			default { puts stdout "Topic $topic not supported for $user" }
				}
	}
