# --- events.tcl --- Skeletons for dde event handlers.

package require dde 2.0

# The following procs are skeletons for various events that can be generated
# by the dde 2.0 package. If an event occurs and a proc with the appropriate
# name is found in the server interp, then the event proc will ba executed with
# the indicated parameters.

# Implementation of register event handler

proc DdeRegisterEvent { service instance } {

# Your code goes here

     }

# Implementation of unregister event handler

proc DdeUnregisterEvent { service instance } {

# Your code goes here

     }

# Implementation of an error event handler

proc DdeErrorEvent { service topic item format type status convst error } {

# Your code goes here

     }

# Implementation of a monitor event. The first parameter is the type of monitor
# event that occurred, the second parameter is the name of the global array that
# holds the event data. Until the 'Lock' element of the global array is cleared
# to false, no new events of the same type will be recorded. If such events
# do occur before the 'Lock' is reset, then the 'Drop Count' element of the
# global array will be incremented. The dde server will reset the 'Drop Count'
# whenever it stores new data into the global array.

proc DdeMonitorEvent { type var }

     upvar #0 $var ptr;

     if { $ptr(Drop Count) } {
          puts stdout [format "Number of events of type %d dropped is %d" $type $ptr(Drop Count]
          }
     set ptr(Lock) false

# Your code goes here

     }

# Implementation of a connection event. This event occurs when a connection is
# confirmed with a client.

proc DdeConnectEvent { service topic user password machine application } {

# Your code goes here

     }

# In

# Implementation of a disconnect event. This event occurs when a connection is
# terminated.

proc DdeDisconnectEvent { service topic user password machine application } {

# Your code goes here

     }

# Implementation of an advise start event.

proc DdeAdviseStartEvent { service topic item fmt user } {

# Your code goes here

     }

# Implementation of an advise stop event

proc DdeAdviseStopEvent { service topic item fmt user } {

# Your code goes here

     }

# Implementation of a request event. This handler is called before the server
# acts on the request, so you can prepare your data in a manner the server likes!

proc DdeRequestEvent { service topic item fmt user } {

# Your code goes here

     }

# Implementation of an action complete event

proc DdeActCompleteEvent { service topic item fmt user } {

# Your code goes here

     }

# Implementation of a poke event

proc DdePokeEvent { service topic item fmt user value } {

# Your code goes here

     }




