# --- excelcmd.tcl --- Demonstration of remote control of Excel from Tcl/Tk

# Copyright(C) I.B.Findleton, 1998. All Rights Reserved.

# This demonstration shows how to send a file containing a list of Excel macros to
# the Excel DDE service.

load dde
package require dde 2.0

# Excel must be running for this script to be used

set list [string tolower [dde services]]
if  { [lsearch $list excel] == -1 } {
	set ExcelServerExists 0
} else {
	set ExcelServerExists 1
	}

source $tcl_library/dde/brackets.tcl

global FileName Editor Dirty save saveas quit open run new

# Get the lase file name used by this applicatin from the WIN.INI file.

set FileName [profile -operation get -default "" -section "ExcelCmd" -entry "File Name"]
if { ![file exists $FileName] } { set FileName "" }

set Dirty 0

# Get the next line from an input stream

proc GetNextLine { $fd } {

	set line ""

	if { [eof $fd] == 0 } {
		gets $fd line
		set line [string trim $line]
		}
	return $line
	}

# Extract a string that should be a Tcl command

proc TclString { line } {

	set len [string length $line]

	if { $len } {
		return "[string range $line 1 [expr $len - 1]]\n"
		}
	return "\n"
	}


# Build the list of commands in a format that Excel likes. See the Microsoft Excel
# User's Guide for some sparse details on this format!

proc BuildCommandString { f } {

	set fd [open $f "r"]
	set tmp [open $f.tmp "w"]

	set result ""

	while { [eof $fd] == 0 } {
		set line [GetNextLine $fd]
		set len [string length $line]
		if { [string index $line 0] != "#" } {
			if { $len > 0 } {
				if { [string index $line 0] == "!" } {
					set Cmd ""
					while { eof[$fd] == 0 && [string index $line 0] == "!" } {
						append Cmd TclString $line
						set line [GetNextLine $fd]
						}
					eval $Cmd
					append result [format "\[%s\]" $line]
				} else {
					append result [format "\[%s\]" $line]
					}
				}
			}
		}

	close $fd

	return $result
	}

# Set the state of the buttons

proc SetButtonState {} {

	global Dirty save saveas quit run open new FileName
	global ExcelServerExists

	if { $Dirty } {
		$save config -state normal
		$saveas config -state normal
		$run config -state disabled
		$new config -state disabled
	} else {
		$new config -state normal
		if { $FileName != ""  && $ExcelServerExists > 0 } {
			$run config -state normal
		} else {
			$run config -state disabled
			}
		$save config -state disabled
		$saveas config -state disabled
		}
	}

# Send the command to Excel.

proc SendToExcel { cmd } {

	set id [dde connect excel system]
	if  { $id != -1 } {
		dde exec $id $cmd
		dde disconnect $id
		return $cmd
		}
	else return "Excel not running!"
	}

# Run a command file

proc RunFile {} {

	global FileName

	if { $FileName == "" } {
		set FileName [GetOpenFileName "Choose a command file..."]
		}

	if { $FileName != ""} {
		SendToExcel [BuildCommandString $FileName]
		}
}

# Quit the application

proc Quit { } {

	destroy .all
        exit
	}

# Save a file

proc SaveFile {} {

	global Dirty FileName Editor

	if { $FileName != "" } {
		set cur 1
		set last [GetLineNumber $Editor end]
		set fd [open $FileName "w"]
		while { $cur <= $last } {
			puts -nonewline $fd [GetALine $Editor $cur]
			incr cur
			}
		close $fd
		set Dirty 0
		SetButtonState
		}
	}

# Save the file under a new name

proc SaveFileAs {} {

	set FileName [GetSaveFileName "Choose a file name..."]

	if { $FileName != "" } {
		profile -operation set -section "ExcelCmd" -entry "File Name" $FileName
		}
	Save
	}

# Get a file

proc OpenFile {} {

	global Dirty FileName Editor

	if { $Dirty } {
		SaveFile
		}
	set FileName [GetOpenFileName "Choose a command file..."]
	if { $FileName != "" } {
		profile -operation set -section "ExcelCmd" -entry "File Name" $FileName
		}
	ViewFile $Editor $FileName
	SetButtonState
	}

# Create an empty file

proc NewFile {} {

	global Editor FileName Dirty

	if { $Dirty } {
		SaveFile
		}

	set FileName ""
	$Editor.text delete 1.0 end
	}

# Trap any registration events in case Excel starts or stops...

proc DdeRegisterEvent { service instance } {

	global ExcelServerExists run FileName

	set service [string tolower $service]

	if { $service == "excel" } {
		incr ExcelServerExists
		if { $FileName != "" } {
			$run config -state normal
			}
		}
	}

# Trap any unregister events in case Excel goes away

proc DdeUnregisterEvent { service instance } {

	global ExcelServerExists run

	set service [string tolower $service]

	if { $service == "excel" } {
		set ExcelServerExists [expr $ExcelServerExists - 1]
		if { $ExcelServerExists == 0 } {
			$run config -state disabled
			}
		}
	}

destroy .all

set buttonwidth 8

set f [NewFrame .all 0]

# An entry to hold the name of the current file

set f0 [NewFrame $f.name 2 ridge]
label $f0.label -text "File Name"
entry $f0.entry -textvariable FileName -font "Fixedsys 12" -width 70 -state disabled

pack $f0.entry -side right -anchor w
pack $f0.label -side left -anchor e -fill x

# A list of buttons to carry out actions

set f1 [NewFrame $f.actions 2 ridge]
set run [button $f1.run -text "Run File" -width $buttonwidth -command { RunFile } \
					-state disabled]
button $f1.help -text "Help" -width $buttonwidth -command { help "Using Microsoft Excel" }
set quit [button $f1.exit -text "Quit" -width $buttonwidth -command { Quit }]
button $f1.view -text "View File" -width $buttonwidth -command { ViewFile }
set save [button $f1.save -text "Save" -width $buttonwidth -command { SaveFile } -state disabled]
set saveas [button $f1.saveas -text "Save As.." -width $buttonwidth -command { SaveFileAs } -state disabled]
set open [button $f1.open -text "Open File" -width $buttonwidth -command { OpenFile }]
set new [button $f1.new -text "New File" -width $buttonwidth -command { NewFile}]
pack $f1.new $f1.open $f1.run $f1.save $f1.saveas $f1.help $f1.exit -side left

# A scrolled text window to see the command files

set Editor [BracketEditor $f.view]

pack $f0 $f1 $Editor -side top -fill x

pack $f

wm title . "Tcl/Tk to Microsoft Excel Interface"
if { $FileName != "" } {
	ViewFile $Editor $FileName
	SetButtonState
	}

