# --- loaddde.tcl --- Initialization script for the dde 2.0 package

package require dde 2.0

# Initialize dde on an interpreter. This script is sourced when the 'load dde
# command is executed on an interp. It checks for the presence the 2.0 dde
# package.

wm title . [tk appname]

# Comment out the following line to supress the initiation of help

help

# Uncomment the following line to see debug messages on the interp console

# set dde_debug 1

# Implementation of the standard Tcl/Tk send command. The first argument is the
# name of the interp's appname that is to get the command, the rest of the line
# builds the command to be sent.

proc send { w args } {

	set id [dde connect Tcl $w]
	if { $id != -1 } {
		set result [eval { dde exec $id } $args]
		dde disconnect $id
		return $result
	} else {
		return "Connection to interp $w failed!"
		}
	}

# Implementation of the 'get' function of the dde 1.0 package. Note that this
# function could be used with any service that provides a return in text format.

proc get { topic item {service Tcl} } {

	set id [dde connect $service $topic]
	if { $id != -1 } {
		set result [dde request $id $item]
		dde disconnect $id
		return $result
	} else {
		return "Connection to service $service on topic $topic failed!"
		}
	}

# Implementation of the DDE PostAdvise function. If a client requests an advise
# loop on a variable known globally at this interp, the server sets up a variable
# trace that extcutes the following command whenever the variable is set or unset.
# This proc will then send the client a notification that the variable has changed
# using the 'notify' function of the dde package.

proc DdeNotifyEvent { service topic var format op } {

	dde notify $topic $var

#	Your code goes here, but you really don't need any.

	}

