# --- photocnt.tcl --- Client for the photo server

# Copyright(C) I.B.Findleton,1998. All Rights Reserved

load dde
package require dde 2.0

destroy .all

global conv

# Initialize some data values

set conv(Id) -1
set conv(Frame) ""
set conv(Window) ""
set conv(Image) ""
set conv(File) helpicon.bmp
set conv(Server) [tk appname]
set conv(ImageList) ""
set conv(Help) ""
set conv(LastMessage) ""

# Create a labeled entry

proc LabeledEntry { w name text msg { state normal } } {

	global conv

	set f [frame $w -relief ridge -borderwidth 2]
	entry $f.entry -width 30 -justify right -textvariable conv($name) -state $state \
				-font "Fixedsys 12"
	bind $f.entry <Enter> "DisplayHelp $f.entry \"$msg\""
	label $f.label -text $text
	pack $f.label -side left
	pack $f.entry -side right

	return $f
	}

# Quit the application

proc Quit {} {

	global conv

	destroy .all
	destroy $conv(Frame)
	image delete $conv(Image)

	dde disconnect
	exit
	}

# Connect to a server

proc Connect {} {

	global conv

	if { $conv(Server) != "" } {
		if { [set conv(Id) [dde connect $conv(Server) images]] != -1 } {
			.all.actions.connect config -state disabled
			.all.actions.request config -state normal
			.all.actions.list config -state normal
			.all.actions.disconnect config -state normal
			.all.server.entry config -state disabled
			.all.actions.quit config -state disabled
			set conv(LastMessage) "Connected to $conv(Server)"
		} else {
			set conv(LastMessage) "Failed to connect to $conv(Server)"
         }
		}
	}

# Disconnect from the current server

proc Disconnect {} {

	global conv

	if { $conv(Id) != -1 } {
		set conv(Id) [dde disconnect $conv(Id)]
		set conv(ImageList) ""
		.all.server.entry config -state normal
		.all.actions.connect config -state normal
		.all.actions.disconnect config -state disabled
		.all.actions.list config -state disabled
		.all.actions.request config -state disabled
		.all.actions.quit config -state normal
      set conv(LastMessage) "Disconnected from $conv(Server)"
		}
	}

# Request an image

proc Request {} {

	global conv

	if { $conv(Id) != -1 } {
		if { $conv(File) != "" } {
			if { $conv(Image) != "" } {
				catch [image delete $conv(Image)]
				}
			if { [set conv(Image) [dde request -f b $conv(Id) $conv(File)]] != "" } {
				DisplayImage
				set conv(LastMessage) "Image $conv(File) from $conv(Server) found."
			} else {
				set conv(LastMessage) "Image $conv(File) is not available"
            }
			}
		}
	}

# Display an image

proc DisplayImage {} {

	global conv

	if { $conv(Image) != "" } {
		if { $conv(Window) != "" } {
			$conv(Window) config -image $conv(Image)
		} else {
			set conv(Frame) [toplevel .display]
			set conv(Window) [label .display.window -image $conv(Image)]
			pack $conv(Window)
			}
		}
		wm title .display "Photo Image $conv(Image)"
	}

# List the images available

proc List {} {

	global conv

	if { $conv(Id) != -1 } {
		set conv(ImageList) [dde request $conv(Id) list]
		}
	}

# Find the photo server

proc FindPhotoServer {} {

	global conv

	set list [dde services]
	set length [llength $list]

	set idx 0
	while { $idx < $length } {
		set topics [dde topics [lindex $list $idx]]
		if { [lsearch $topics "images"] != -1 } {
			return [lindex $list $idx]
			}
		incr idx
		}

	set conv(LastMessage) "No photo server has been found!"

	return ""
	}

# Display a help message for a button

proc DisplayHelp { w msg } {

	global conv

	if { [lindex [$w config -state] 4] == "normal" } {
		set conv(Help) $msg
		}
	}

# Create a button that has a help message

proc TalkingButton { w msg args } {

	eval { button $w -width 10 } $args
	bind $w <Enter> "DisplayHelp $w \"$msg\""

	return $w
	}

set f0 [frame .all -relief flat -borderwidth 2]

set f1 [LabeledEntry $f0.server Server "Server Name" "Enter the name of a server"]
set f2 [LabeledEntry $f0.file File "File Name" "Enter the name of a file"]

bind $f2.entry <Return> "Request"

set f3 [frame $f0.actions -relief ridge -borderwidth 2]
TalkingButton $f3.connect "Connect to $conv(Server)" -text "Connect" -width 10 -command "Connect"
TalkingButton $f3.disconnect "Disconnect from $conv(Server)" -text "Disconnect" -width 10 -command "Disconnect" -state disabled
TalkingButton $f3.list "List the images available from $conv(Server)" -text "List Images" -width 10 -command "List" -state disabled
TalkingButton $f3.request "Fetch image $conv(File) from $conv(Server)" -text "Request" -width 10 -command "Request" -state disabled
TalkingButton $f3.quit "Quit the photo client application" -text "Quit" -width 10 -command "Quit"

bind Button <Leave> { set conv(Help) $conv(LastMessage) }
bind Entry <Leave> { set conv(Help) $conv(LastMessage) }

pack $f3.connect $f3.request $f3.list $f3.disconnect $f3.quit -side left

set f4 [frame $f0.status -relief ridge -borderwidth 2]
entry $f4.help -textvariable conv(Help) -font "Fixedsys 12" -width 50 -bg gray80 -fg blue

pack $f4.help -side left -fill x

pack $f1 $f2 $f3 $f4 -side top -fill x

pack $f0

wm title . "Photo Image Client Application"

set conv(Server) [FindPhotoServer]
