# --- photos.tcl --- Demonstration of an image server

# Copyright(C) I.B.Findleton, 1998. All Rights Reserved.

load dde
package require dde 2.0

# register a private topic for the image server

dde register [tk appname] images

# Get the base file name from a path

proc FileName { path } {

	set path [split $path /]
	set length [llength $path]
	set path [lindex $path [expr $length - 1]]
	set path [split $path .]
	return [lindex $path 0]
	}

# Install a procedure to handle requests for private topics

proc DdeRequestEvent { service topic item format user } {

	if { $topic != "images" } {
		return
		}

	if { $format == "bitmap" } {
		puts stdout "Looking for $item"
		set pic [image create photo [FileName $item] -file $item]
		return $pic
		}

	if { $item == "list" } {
		set fd [open "|dir *.bmp /w" "r"]
		set result ""
		while { [gets $fd line] } {
			append result $line
			puts stdout $line
			}
		close $fd
		return $result
		}
	}

source $tcl_library/dde/photocnt.tcl
