# --- resource.tcl --- Demonstration of the use of resources

# Copyright(C) I.B.Findleton,1998. All Rights Reserved.

# This script shows how to load and use various resource types from a script
# file.

load dde
package require dde 2.0

catch [destroy .all]
catch [destroy logo]

global resource

set resource 1

# Get the image from the resource data

proc GetImage { id { name logo }} {

	return [loadresource -format bitmap -resource $id]

	}

# Display the image in the label

proc ViewImage { w name } {

	global resource

	catch [destroy $name]
	$w config -image [GetImage $resource $name]
	}

set f0 [toplevel .all]
set f1 [frame $f0.image -borderwidth 2 -relief ridge]
label $f1.label
pack $f1.label

set f2 [frame $f0.actions -relief ridge -borderwidth 3]
button $f2.ok -text Ok -width 10 -command "destroy logo .all"
button $f2.view -text "View Image" -width 10 -command "ViewImage $f1.label logo"
entry $f2.entry -width 5 -font "Fixedsys 12" -textvariable resource -justify right
pack $f2.entry -side right -anchor w
pack $f2.ok $f2.view -side left

pack $f1 $f2 -side top -fill x

wm title $f0 "Demonstration of a resource bitmap"

