dnl --------------------------------------------------------------------
dnl This file aclocal.m4 contains macros needed by
dnl the configuration process of adabastcl.
dnl It divides into two parts:
dnl - the first is a copy of aclocal.m4 of the expect-5.18 distribution
dnl   by Don Libes (although the first line says, it is written by Rob Savoye). 
dnl   it defines two macros, which search for Tcl/Tk.
dnl - the second is the defintion of a macros, whoch body is a extract
dnl   of the configure.in file of the tcl7.5 distribution by John Osterhout.
dnl   It determines all parameters neccessary for dynamlic loading.
dnl --------------------------------------------------------------------

dnl --------------------------------------------------------------------
dnl Part 1 (from expect-5.18 by Don Libes)
dnl --------------------------------------------------------------------
dnl written by Rob Savoye <rob@cygnus.com> for Cygnus Support
dnl CYGNUS LOCAL: This gets the right posix flag for gcc
AC_DEFUN(CY_TCL_LYNX_POSIX,
[AC_REQUIRE([AC_PROG_CC])AC_REQUIRE([AC_PROG_CPP])
AC_MSG_CHECKING([to see if this is LynxOS])
AC_CACHE_VAL(ac_cv_os_lynx,
[AC_EGREP_CPP(yes,
[/*
 * The old Lynx "cc" only defines "Lynx", but the newer one uses "__Lynx__"
 */
#if defined(__Lynx__) || defined(Lynx)
yes
#endif
], ac_cv_os_lynx=yes, ac_cv_os_lynx=no)])
#
if test "$ac_cv_os_lynx" = "yes" ; then
  AC_MSG_RESULT(yes)
  AC_DEFINE(LYNX)
  AC_MSG_CHECKING([whether -mposix or -X is available])
  AC_CACHE_VAL(ac_cv_c_posix_flag,
  [AC_TRY_COMPILE(,[
  /*
   * This flag varies depending on how old the compiler is.
   * -X is for the old "cc" and "gcc" (based on 1.42).
   * -mposix is for the new gcc (at least 2.5.8).
   */
  #if defined(__GNUC__) && __GNUC__ >= 2
  choke me
  #endif
  ], ac_cv_c_posix_flag=" -mposix", ac_cv_c_posix_flag=" -X")])
  CC="$CC $ac_cv_c_posix_flag"
  AC_MSG_RESULT($ac_cv_c_posix_flag)
  else
  AC_MSG_RESULT(no)
fi
])
#
# Sometimes the native compiler is a bogus stub for gcc or /usr/ucb/cc. This
# makes configure think it's cross compiling. If --target wasn't used, then
# we can't configure, so something is wrong.
AC_DEFUN(CY_C_CROSS,
[# If we cannot run a trivial program, we must be cross compiling.
AC_MSG_CHECKING(whether cross-compiling)
AC_CACHE_VAL(ac_cv_c_cross,[
AC_TRY_RUN([
  main(){return(0);}],
  ac_cv_c_cross=no, ac_cv_c_cross=yes, ac_cv_c_cross=yes)
])
if test x"${target}" = x"${host}" -a x"${ac_cv_c_cross}" = x"yes"; then
  dnl this hack is cause the message is so long we don't call AC_MSG_ERROR
  echo "configure: error: You need to specify --target to cross compile," 1>&2;
  echo "	or the native compiler is broken" 1>&2;
  exit 1;
else
  cross_compiling=$ac_cv_c_cross
  AC_MSG_RESULT($ac_cv_c_cross)
fi
])
AC_DEFUN(CY_PATH_TCLH, [
#
# Ok, lets find the tcl source trees so we can use the headers
# Warning: transition of version 9 to 10 will break this algorithm
# because 10 sorts before 9. We also look for just tcl. We have to
# be careful that we don't match stuff like tclX by accident.
# the alternative search directory is involked by --with-tclinclude
#
no_tcl=true
AC_MSG_CHECKING(for Tcl headers)
AC_ARG_WITH(tclinclude, [  --with-tclinclude       directory where tcl headers are], with_tclinclude=${withval})
AC_CACHE_VAL(ac_cv_c_tclh,[
# first check to see if --with-tclinclude was specified
if test x"${with_tclinclude}" != x ; then
  if test -f ${with_tclinclude}/tcl.h ; then
    ac_cv_c_tclh=`(cd ${with_tclinclude}; pwd)`
  else
    AC_MSG_ERROR([${with_tclinclude} directory doesn't contain headers])
  fi
fi
# next check in private source directory
#
# since ls returns lowest version numbers first, reverse its output
if test x"${ac_cv_c_tclh}" = x ; then
  for i in \
		${srcdir}/../tcl \
		`ls -dr ${srcdir}/../tcl[[0-9]]* 2>/dev/null` \
		${srcdir}/../../tcl \
		`ls -dr ${srcdir}/../../tcl[[0-9]]* 2>/dev/null` \
		${srcdir}/../../../tcl \
		`ls -dr ${srcdir}/../../../tcl[[0-9]]* 2>/dev/null ` ; do
    if test -f $i/tcl.h ; then
      ac_cv_c_tclh=`(cd $i; pwd)`
      break
    fi
  done
fi
# finally check in a few common install locations
#
# since ls returns lowest version numbers first, reverse its output
if test x"${ac_cv_c_tclh}" = x ; then
  for i in \
		`ls -dr /usr/local/src/tcl[[0-9]]* 2>/dev/null` \
		`ls -dr /usr/local/lib/tcl[[0-9]]* 2>/dev/null` \
		/usr/local/src/tcl \
		/usr/local/lib/tcl \
		/usr/local/include \
		${prefix}/incl     \
		${prefix}/include ; do
    if test -f $i/tcl.h ; then
      ac_cv_c_tclh=`(cd $i; pwd)`
      break
    fi
  done
fi
# see if one is installed
if test x"${ac_cv_c_tclh}" = x ; then
   AC_HEADER_CHECK(tcl.h, ac_cv_c_tclh=installed, ac_cv_c_tclh="")
fi
])
if test x"${ac_cv_c_tclh}" = x ; then
  TCLHDIR="# no Tcl private headers found"
AC_MSG_ERROR([
    Can't find Tcl headers.
    If Tcl is installed, see INSTALL on how to tell
    configure where Tcl is installed.
])
fi
if test x"${ac_cv_c_tclh}" != x ; then
  no_tcl=""
  if test x"${ac_cv_c_tkh}" = x"installed" ; then
    AC_MSG_RESULT([is installed])
    TCLHDIR=""
  else
    AC_MSG_RESULT([found in ${ac_cv_c_tclh}])
    # this hack is cause the TCLHDIR won't print if there is a "-I" in it.
    TCLHDIR="-I${ac_cv_c_tclh}"
  fi
fi

AC_MSG_CHECKING([Tcl version])
rm -rf tclmajor tclminor
orig_includes="$CPPFLAGS"

if test x"${TCLHDIR}" != x ; then
  CPPFLAGS="$CPPFLAGS $TCLHDIR"
fi

AC_TRY_RUN([
#include <stdio.h>
#include "tcl.h"
main() {
	FILE *maj = fopen("tclmajor","w");
	FILE *min = fopen("tclminor","w");
	fprintf(maj,"%d",TCL_MAJOR_VERSION);
	fprintf(min,"%d",TCL_MINOR_VERSION);
	fclose(maj);
	fclose(min);
	return 0;
}],
	tclmajor=`cat tclmajor`
	tclminor=`cat tclminor`
	tclversion=$tclmajor.$tclminor
	AC_MSG_RESULT($tclversion)
	rm -f tclmajor tclminor
,
	AC_MSG_RESULT([can't happen])
,
	AC_MSG_ERROR([can't be cross compiled])
)
CPPFLAGS="${orig_includes}"

AC_PROVIDE([$0])
AC_SUBST(TCLHDIR)
])
AC_DEFUN(CY_PATH_TCLLIB, [
#
# Ok, lets find the tcl library
# First, look for one uninstalled.  
# the alternative search directory is invoked by --with-tcllib
#

if test $tclmajor -ge 8 -o \( $tclmajor -ge 7 -a $tclminor -ge 4 \) ; then
  installedtcllibroot=tcl$tclversion
else
  installedtcllibroot=tcl
fi

if test x"${no_tcl}" = x ; then
  # we reset no_tcl incase something fails here
  no_tcl=true
  AC_ARG_WITH(tcllib, [  --with-tcllib           directory where the tcl library is],
         with_tcllib=${withval})
  AC_MSG_CHECKING([for Tcl library])
  AC_CACHE_VAL(ac_cv_c_tcllib,[
  # First check to see if --with-tcllib was specified.
  # This requires checking for both the installed and uninstalled name-styles
  # since we have no idea if it's installed or not.
  if test x"${with_tcllib}" != x ; then
    if test -f "${with_tcllib}/lib$installedtcllibroot$SHLIB_SUFFIX" ; then
      ac_cv_c_tcllib=`(cd ${with_tcllib}; pwd)`/lib$installedtcllibroot$SHLIB_SUFFIX
    elif test -f "${with_tcllib}/libtcl$SHLIB_SUFFIX" ; then
      ac_cv_c_tcllib=`(cd ${with_tcllib}; pwd)`/libtcl$SHLIB_SUFFIX
    # then look for a freshly built statically linked library
    # if Makefile exists we assume its configured and libtcl will be built first.
    elif test -f "${with_tcllib}/lib$installedtcllibroot.a" ; then
      ac_cv_c_tcllib=`(cd ${with_tcllib}; pwd)`/lib$installedtcllibroot.a
    elif test -f "${with_tcllib}/libtcl.a" ; then
      ac_cv_c_tcllib=`(cd ${with_tcllib}; pwd)`/libtcl.a
    else
      AC_MSG_ERROR([${with_tcllib} directory doesn't contain libraries])
    fi
  fi
  # then check for a private Tcl library
  # Since these are uninstalled, use the simple lib name root.
  if test x"${ac_cv_c_tcllib}" = x ; then
    for i in \
		../tcl \
		`ls -dr ../tcl[[0-9]]* 2>/dev/null` \
		../../tcl \
		`ls -dr ../../tcl[[0-9]]* 2>/dev/null` \
		../../../tcl \
		`ls -dr ../../../tcl[[0-9]]* 2>/dev/null` ; do
      # first look for a freshly built dynamically linked library
      if test -f "$i/libtcl$SHLIB_SUFFIX" ; then
        ac_cv_c_tcllib=`(cd $i; pwd)`/libtcl$SHLIB_SUFFIX
	break
      # then look for a freshly built statically linked library
      # if Makefile exists we assume its configured and libtcl will be built first.
      elif test -f "$i/libtcl.a" -o -f "$i/Makefile" ; then
        ac_cv_c_tcllib=`(cd $i; pwd)`/libtcl.a
	break
      fi
    done
  fi
  # check in a few common install locations
  if test x"${ac_cv_c_tcllib}" = x ; then
    for i in `ls -d ${prefix}/lib /usr/local/lib 2>/dev/null` ; do
      # first look for a freshly built dynamically linked library
      if test -f "$i/lib$installedtcllibroot$SHLIB_SUFFIX" ; then
        ac_cv_c_tcllib=`(cd $i; pwd)`/lib$installedtcllibroot$SHLIB_SUFFIX
	break
      # then look for a freshly built statically linked library
      # if Makefile exists we assume its configured and libtcl will be built first.
      elif test -f "$i/lib$installedtcllibroot.a" -o -f "$i/Makefile" ; then
        ac_cv_c_tcllib=`(cd $i; pwd)`/lib$installedtcllibroot.a
	break
      fi
    done
  fi
  # check in a few other private locations
  if test x"${ac_cv_c_tcllib}" = x ; then
    for i in \
		${srcdir}/../tcl \
		`ls -dr ${srcdir}/../tcl[[0-9]]* 2>/dev/null` ; do
      # first look for a freshly built dynamically linked library
      if test -f "$i/libtcl$SHLIB_SUFFIX" ; then
        ac_cv_c_tcllib=`(cd $i; pwd)`/libtcl$SHLIB_SUFFIX
	break
      # then look for a freshly built statically linked library
      # if Makefile exists we assume its configured and libtcl will be built first.
      elif test -f "$i/libtcl.a" -o -f "$i/Makefile" ; then
        ac_cv_c_tcllib=`(cd $i; pwd)`/libtcl.a
	break
      fi
    done
  fi

  # see if one is conveniently installed with the compiler
  if test x"${ac_cv_c_tcllib}" = x ; then	
    orig_libs="$LIBS"
    LIBS="$LIBS -l$installedtcllibroot -lm"    
    AC_TRY_RUN([
    Tcl_AppInit()
    { exit(0); }], ac_cv_c_tcllib="-l$installedtcllibroot", ac_cv_c_tcllib=""
    , ac_cv_c_tclib="-l$installedtcllibroot")
    LIBS="${orig_libs}"
   fi
  ])
  if test x"${ac_cv_c_tcllib}" = x ; then
    TCLLIB="# no Tcl library found"
    AC_MSG_WARN(Can't find Tcl library)
  else
    TCLLIB=${ac_cv_c_tcllib}
    AC_MSG_RESULT(found $TCLLIB)
    no_tcl=
  fi
fi

AC_PROVIDE([$0])
AC_SUBST(TCLLIB)
])
AC_DEFUN(CY_PATH_TKH, [
#
# Ok, lets find the tk source trees so we can use the headers
# If the directory (presumably symlink) named "tk" exists, use that one
# in preference to any others.  Same logic is used when choosing library
# and again with Tcl. The search order is the best place to look first, then in
# decreasing significance. The loop breaks if the trigger file is found.
# Note the gross little conversion here of srcdir by cd'ing to the found
# directory. This converts the path from a relative to an absolute, so
# recursive cache variables for the path will work right. We check all
# the possible paths in one loop rather than many seperate loops to speed
# things up.
# the alternative search directory is invoked by --with-tkinclude
#
AC_MSG_CHECKING(for Tk headers)
AC_ARG_WITH(tkinclude, [  --with-tkinclude        directory where the tk headers are],
            with_tkinclude=${withval})
no_tk=true
AC_CACHE_VAL(ac_cv_c_tkh,[
# first check to see if --with-tkinclude was specified
if test x"${with_tkinclude}" != x ; then
  if test -f ${with_tkinclude}/tk.h ; then
    ac_cv_c_tkh=`(cd ${with_tkinclude}; pwd)`
  else
    AC_MSG_ERROR([${with_tkinclude} directory doesn't contain headers])
  fi
fi
# next check in private source directory
#
# since ls returns lowest version numbers first, reverse the entire list
# and search for the worst fit, overwriting it with better fits as we find them
if test x"${ac_cv_c_tkh}" = x ; then
  for i in \
		${srcdir}/../tk \
		`ls -dr ${srcdir}/../tk[[0-9]]* 2>/dev/null` \
		${srcdir}/../../tk \
		`ls -dr ${srcdir}/../../tk[[0-9]]* 2>/dev/null` \
		${srcdir}/../../../tk \
		`ls -dr ${srcdir}/../../../tk[[0-9]]* 2>/dev/null ` ; do
    if test -f $i/tk.h ; then
      ac_cv_c_tkh=`(cd $i; pwd)`
      break
    fi
  done
fi
# finally check in a few common install locations
#
# since ls returns lowest version numbers first, reverse the entire list
# and search for the worst fit, overwriting it with better fits as we find them
if test x"${ac_cv_c_tkh}" = x ; then
  for i in \
		`ls -dr /usr/local/src/tk[[0-9]]* 2>/dev/null` \
		`ls -dr /usr/local/lib/tk[[0-9]]* 2>/dev/null` \
		/usr/local/src/tk \
		/usr/local/lib/tk \
		/usr/local/include \
		${prefix}/incl     \
		${prefix}/include ; do
    if test -f $i/tk.h ; then
      ac_cv_c_tkh=`(cd $i; pwd)`
      break
    fi
  done
fi
# see if one is installed
if test x"${ac_cv_c_tkh}" = x ; then
  AC_HEADER_CHECK(tk.h, ac_cv_c_tkh=installed)
fi
])
if test x"${ac_cv_c_tkh}" != x ; then
  no_tk=""
  if test x"${ac_cv_c_tkh}" = x"installed" ; then
    AC_MSG_RESULT([is installed])
    TKHDIR=""
  else
    AC_MSG_RESULT([found in $ac_cv_c_tkh])
    # this hack is cause the TKHDIR won't print if there is a "-I" in it.
    TKHDIR="-I${ac_cv_c_tkh}"
  fi
else
  TKHDIR="# no Tk directory found"
  AC_MSG_WARN([Can't find Tk headers])
  no_tk=true
fi

# if Tk is installed, extract the major/minor version
if test x"${no_tk}" = x ; then
AC_MSG_CHECKING([Tk version])
rm -rf tkmajor tkminor
orig_includes="$CPPFLAGS"

if test x"${TCLHDIR}" != x ; then
  CPPFLAGS="$CPPFLAGS $TCLHDIR"
fi
if test x"${TKHDIR}" != x ; then
  CPPFLAGS="$CPPFLAGS $TKHDIR"
fi
if test x"${x_includes}" != x -a x"${x_includes}" != xNONE ; then
  CPPFLAGS="$CPPFLAGS -I$x_includes"
fi

AC_TRY_RUN([
#include <stdio.h>
#include "tk.h"
  main() {
	FILE *maj = fopen("tkmajor","w");
	FILE *min = fopen("tkminor","w");
	fprintf(maj,"%d",TK_MAJOR_VERSION);
	fprintf(min,"%d",TK_MINOR_VERSION);
	fclose(maj);
	fclose(min);
	return 0;
}],
	tkmajor=`cat tkmajor`
	tkminor=`cat tkminor`
	tkversion=$tkmajor.$tkminor
	AC_MSG_RESULT($tkversion)
	rm -f tkmajor tkminor
,
	AC_MSG_ERROR([
cannot compile a simple X program - suspect your xmkmf is
misconfigured and is incorrectly reporting the location of your X
include or libraries - report this to your system admin]) ,
	AC_MSG_ERROR([can't be cross compiled])
)
CPPFLAGS="${orig_includes}"
fi

AC_PROVIDE([$0])
AC_SUBST(TKHDIR)
])
dnl for some reason, AC_REQUIRE() seems to choke autoconf
AC_DEFUN(CY_PATH_TKLIB, [
dnl AC_REQUIRE(CY_PATH_TCL)
#
# Ok, lets find the tk library
# First, look for the latest private (uninstalled) copy
# Notice that the destinations in backwards priority since the tests have
# no break.
# Then we look for either .a, .so, or Makefile.  A Makefile is acceptable
# is it indicates the target has been configured and will (probably)
# soon be built.  This allows an entire tree of Tcl software to be
# configured at once and then built.
# the alternative search directory is invoked by --with-tklib
#

if test x"${no_tk}" = x ; then
  # reset no_tk incase something fails here
  no_tk="true"

  if test $tkmajor -ge 4 ; then
    installedtklibroot=tk$tkversion
  else
    installedtkllibroot=tk
  fi

  AC_ARG_WITH(tklib, [  --with-tklib            directory where the tk library is],
              with_tklib=${withval})
  AC_MSG_CHECKING([for Tk library])
  AC_CACHE_VAL(ac_cv_c_tklib,[
  # first check to see if --with-tklib was specified
  # This requires checking for both the installed and uninstalled name-styles
  # since we have no idea if it's installed or not.
  if test x"${with_tklib}" != x ; then
    if test -f "${with_tklib}/lib$installedtklibroot$SHLIB_SUFFIX" ; then
      ac_cv_c_tklib=`(cd ${with_tklib}; pwd)`/lib$installedtklibroot$SHLIB_SUFFIX
      no_tk=""
    elif test -f "${with_tklib}/libtk$SHLIB_SUFFIX" ; then
      ac_cv_c_tklib=`(cd ${with_tklib}; pwd)`/libtk$SHLIB_SUFFIX
      no_tk=""
    # then look for a freshly built statically linked library
    # if Makefile exists we assume its configured and libtk will be built
    elif test -f "${with_tklib}/lib$installedtklibroot.a" ; then
      ac_cv_c_tklib=`(cd ${with_tklib}; pwd)`/lib$installedtklibroot.a
      no_tk=""
    elif test -f "${with_tklib}/libtk.a" ; then
      ac_cv_c_tklib=`(cd ${with_tklib}; pwd)`/libtk.a
      no_tk=""
    else
      AC_MSG_ERROR([${with_tklib} directory doesn't contain libraries])
    fi
  fi
  # then check for a private Tk library
  # Since these are uninstalled, use the simple lib name root.
  if test x"${ac_cv_c_tklib}" = x ; then
    for i in \
		../tk \
		`ls -dr ../tk[[0-9]]* 2>/dev/null` \
		../../tk \
		`ls -dr ../../tk[[0-9]]* 2>/dev/null` \
		../../../tk \
		`ls -dr ../../../tk[[0-9]]* 2>/dev/null` ; do
      # first look for a freshly built dynamically linked library
      if test -f "$i/libtk$SHLIB_SUFFIX" ; then
        ac_cv_c_tklib=`(cd $i; pwd)`/libtk$SHLIB_SUFFIX
        no_tk=
	break
      # then look for a freshly built statically linked library
      # if Makefile exists we assume its configured and libtk will be built 
      elif test -f "$i/libtk.a" -o -f "$i/Makefile" ; then
        ac_cv_c_tklib=`(cd $i; pwd)`/libtk.a
        no_tk=""
 	break
      fi
    done
  fi
  # finally check in a few common install locations
  if test x"${ac_cv_c_tklib}" = x ; then
    for i in `ls -d ${prefix}/lib /usr/local/lib 2>/dev/null` ; do
      # first look for a freshly built dynamically linked library
      if test -f "$i/lib$installedtklibroot$SHLIB_SUFFIX" ; then
        ac_cv_c_tklib=`(cd $i; pwd)`/lib$installedtklibroot$SHLIB_SUFFIX
        no_tk=""
	break
      # then look for a freshly built statically linked library
      # if Makefile exists, we assume it's configured and libtcl will be built 
      elif test -f "$i/lib$installedtklibroot.a" -o -f "$i/Makefile" ; then
        ac_cv_c_tklib=`(cd $i; pwd)`/lib$installedtklibroot.a
        no_tk=""
 	break
      fi
    done
  fi
  # check in a few other private locations
  if test x"${ac_cv_c_tklib}" = x ; then
    for i in \
		${srcdir}/../tk \
		`ls -dr ${srcdir}/../tk[[0-9]]* 2>/dev/null` ; do
      # first look for a freshly built dynamically linked library
      if test -f "$i/libtk$SHLIB_SUFFIX" ; then
        ac_cv_c_tklib=`(cd $i; pwd)`/libtk$SHLIB_SUFFIX
        no_tk=""
	break
      # then look for a freshly built statically linked library
      # if Makefile exists, we assume it's configured and libtcl will be built 
      elif test -f "$i/libtk.a" -o -f "$i/Makefile" ; then
        ac_cv_c_tklib=`(cd $i; pwd)`/libtk.a
        no_tk=""
 	break
      fi
    done
  fi
  # see if one is conveniently installed with the compiler
  if test x"${ac_cv_c_tklib}" = x ; then
dnl       AC_REQUIRE(AC_PATH_X)
       orig_libs="$LIBS"
       LIBS="$LIBS -l$installedtklibroot $x_libraries $ac_cv_c_tcllib -lm"    
       AC_TRY_RUN([
       Tcl_AppInit()
       { exit(0); }], ac_cv_c_tklib="-l$installedtklibroot", ac_cv_c_tklib=""
       , ac_cv_c_tklib="-l$installedtklibroot")
       LIBS="${orig_libs}"
   fi
  ])
  if test x"${ac_cv_c_tklib}" = x ; then
    TKLIB="# no Tk library found"
    AC_MSG_WARN(Can't find Tk library)
  else
    TKLIB=$ac_cv_c_tklib
    AC_MSG_RESULT(found $TKLIB)
    no_tk=
  fi
fi
AC_PROVIDE([$0])
AC_SUBST(TKLIB)
])
AC_DEFUN(CY_PATH_TK, [
  CY_PATH_TKH
  CY_PATH_TKLIB
])
AC_DEFUN(CY_PATH_TCL, [
  CY_PATH_TCLH
  CY_PATH_TCLLIB
])



dnl --------------------------------------------------------------------
dnl Part 2 (from tcl7.5 by John Osterhout)
dnl --------------------------------------------------------------------

AC_DEFUN(AC_CHECK_DYNLOAD, [
#--------------------------------------------------------------------
#	The statements below define a collection of symbols related to
#	dynamic loading and shared libraries:
#
#	DL_OBJS -	Name of the object file that implements dynamic
#			loading for Tcl on this system.
#	DL_LIBS -	Library file(s) to include in tclsh and other base
#			applications in order for the "load" command to work.
#	LD_FLAGS -	Flags to pass to the compiler when linking object
#			files into an executable application binary such
#			as tclsh.
#	LD_SEARCH_FLAGS-Flags to pass to ld, such as "-R /usr/local/tcl/lib",
#			that tell the run-time dynamic linker where to look
#			for shared libraries such as libtcl.so.  Depends on
#			the variable LIB_INSTALL_DIR in the Makefile.
#	MAKE_LIB -	Command to execute to build the Tcl library;
#			differs depending on whether or not Tcl is being
#			compiled as a shared library.
#	SHLIB_CFLAGS -	Flags to pass to cc when compiling the components
#			of a shared library (may request position-independent
#			code, among other things).
#	SHLIB_LD -	Base command to use for combining object files
#			into a shared library.
#	SHLIB_LD_LIBS -	Dependent libraries for the linker to scan when
#			creating shared libraries.  This symbol typically
#			goes at the end of the "ld" commands that build
#			shared libraries. The value of the symbol is
#			"${LIBS}" if all of the dependent libraries should
#			be specified when creating a shared library.  If
#			dependent libraries should not be specified (as on
#			SunOS 4.x, where they cause the link to fail, or in
#			general if Tcl and Tk aren't themselves shared
#			libraries), then this symbol has an empty string
#			as its value.
#	SHLIB_SUFFIX -	Suffix to use for the names of dynamically loadable
#			extensions.  An empty string means we don't know how
#			to use shared libraries on this platform.
#	TCL_LIB_FILE -	Name of the file that contains the Tcl library, such
#			as libtcl7.5.so or libtcl7.5.a.
#	TCL_LIB_SUFFIX -Specifies everything that comes after the "libtcl"
#			in the shared library name, using the $VERSION variable
#			to put the version in the right place.  This is used
#			by platforms that need non-standard library names.
#			Examples:  ${VERSION}.so.1.1 on NetBSD, since it needs
#			to have a version after the .so, and ${VERSION}.a
#			on AIX, since the Tcl shared library needs to have
#			a .a extension whereas shared objects for loadable
#			extensions have a .so extension.  Defaults to
#			${VERSION}${SHLIB_SUFFIX}.
#--------------------------------------------------------------------

# Step 1: set the variable "system" to hold the name and version number
# for the system.  This can usually be done via the "uname" command, but
# there are a few systems, like Next, where this doesn't work.

AC_MSG_CHECKING([system version (for dynamic loading)])
if test -f /usr/lib/NextStep/software_version; then
    system=NEXTSTEP-`awk '/3/,/3/' /usr/lib/NextStep/software_version`
else
    system=`uname -s`-`uname -r`
    if test "$?" -ne 0 ; then
	AC_MSG_RESULT([unknown (can't find uname command)])
	system=unknown
    else
	# Special check for weird MP-RAS system (uname returns weird
	# results, and the version is kept in special file).
    
	if test -r /etc/.relid -a "X`uname -n`" = "X`uname -s`" ; then
	    system=MP-RAS-`awk '{print $3}' /etc/.relid'`
	fi
	if test "`uname -s`" = "AIX" ; then
	    system=AIX-`uname -v`.`uname -r`
	fi
	AC_MSG_RESULT($system)
    fi
fi

# Step 2: check for existence of -ldl library.  This is needed because
# Linux can use either -ldl or -ldld for dynamic loading.

AC_CHECK_LIB(dl, dlopen, have_dl=yes, have_dl=no)

# Step 3: disable dynamic loading if requested via a command-line switch.

AC_ARG_ENABLE(load, [  --disable-load          disallow dynamic loading and "load" command],
    [tcl_ok=$enableval], [tcl_ok=yes])
if test "$tcl_ok" = "no"; then
    system=unknown
fi

# Step 4: set configuration options based on system name and version.

fullSrcDir=`cd $srcdir; pwd`
AIX=no
TCL_SHARED_LIB_SUFFIX=""
TCL_UNSHARED_LIB_SUFFIX=""
TCL_LIB_VERSIONS_OK=ok
case $system in
    AIX-*)
	SHLIB_CFLAGS=""
	SHLIB_LD="$fullSrcDir/ldAix /bin/ld -bhalt:4 -bM:SRE -bE:lib.exp -H512 -T512"
	SHLIB_LD_LIBS='${LIBS}'
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o tclLoadAix.o"
	DL_LIBS="-lld"
	LD_FLAGS=""
	LD_SEARCH_FLAGS='-L${LIB_INSTALL_DIR}'
	AC_DEFINE(NO_DLFCN_H)
	AIX=yes
	TCL_SHARED_LIB_SUFFIX='${VERSION}.a'
	;;
    HP-UX-*.08.*|HP-UX-*.09.*|HP-UX-*.10.*)
	SHLIB_CFLAGS="+z"
	SHLIB_LD="ld -b"
	SHLIB_LD_LIBS='${LIBS}'
	SHLIB_SUFFIX=".sl"
	DL_OBJS="tclLoadShl.o"
	DL_LIBS="-ldld"
	LD_FLAGS="-Wl,-E"
	LD_SEARCH_FLAGS='-Wl,+b,${LIB_INSTALL_DIR}:.'
	;;
    IRIX-4.*)
	SHLIB_CFLAGS="-G 0"
	SHLIB_SUFFIX="..o"
	SHLIB_LD="echo tclLdAout $CC \{$SHLIB_CFLAGS\} | `pwd`/tclsh -r -G 0"
	SHLIB_LD_LIBS=""
	DL_OBJS="tclLoadAout.o"
	DL_LIBS=""
	LD_FLAGS="-Wl,-D,08000000"
	LD_SEARCH_FLAGS=""
	;;
    IRIX-5.*)
	SHLIB_CFLAGS=""
	SHLIB_LD="ld -shared -rdata_shared"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS=""
	LD_FLAGS=""
	LD_SEARCH_FLAGS='-Wl,-rpath,${LIB_INSTALL_DIR}'
	;;
    Linux*)
	SHLIB_CFLAGS="-fPIC"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	if test "$have_dl" = yes; then
	    SHLIB_LD="${CC} -shared"
	    DL_OBJS="tclLoadDl.o"
	    DL_LIBS="-ldl"
	    LD_FLAGS="-rdynamic"
	    LD_SEARCH_FLAGS=""
	else
	    AC_CHECK_HEADER(dld.h, [
		SHLIB_LD="ld -shared"
		DL_OBJS="tclLoadDld.o"
		DL_LIBS="-ldld"
		LD_FLAGS=""
		LD_SEARCH_FLAGS=""])
	fi
	;;
    MP-RAS-02*)
	SHLIB_CFLAGS="-K PIC"
	SHLIB_LD="cc -G"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS="-ldl"
	LD_FLAGS=""
	LD_SEARCH_FLAGS=""
	;;
    MP-RAS-*)
	SHLIB_CFLAGS="-K PIC"
	SHLIB_LD="cc -G"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS="-ldl"
	LD_FLAGS="-Wl,-Bexport"
	LD_SEARCH_FLAGS=""
	;;
    NetBSD-*|FreeBSD-*)
	# Not available on all versions:  check for include file.
	AC_CHECK_HEADER(dlfcn.h, [
	    SHLIB_CFLAGS="-fpic"
	    SHLIB_LD="ld -Bshareable"
	    SHLIB_LD_LIBS=""
	    SHLIB_SUFFIX=".so"
	    DL_OBJS="tclLoadDl2.o"
	    DL_LIBS=""
	    LD_FLAGS=""
	    LD_SEARCH_FLAGS=""
	], [
	    SHLIB_CFLAGS=""
	    SHLIB_LD="echo tclLdAout $CC \{$SHLIB_CFLAGS\} | `pwd`/tclsh -r -G 0"
	    SHLIB_LD_LIBS=""
	    SHLIB_SUFFIX="..o"
	    DL_OBJS="tclLoadAout.o"
	    DL_LIBS=""
	    LD_FLAGS=""
	    LD_SEARCH_FLAGS=""
	])

	# FreeBSD doesn't handle version numbers with dots.  Also, have to
	# append a dummy version number to .so file names.

	TCL_SHARED_LIB_SUFFIX='`echo ${VERSION} | tr -d .`.so.1.0'
	TCL_UNSHARED_LIB_SUFFIX='`echo ${VERSION} | tr -d .`.a'
	TCL_LIB_VERSIONS_OK=nodots
	;;
    NEXTSTEP-*)
	SHLIB_CFLAGS=""
	SHLIB_LD="cc -nostdlib -r"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadNext.o"
	DL_LIBS=""
	LD_FLAGS=""
	LD_SEARCH_FLAGS=""
	;;
    OSF1-1.[012])
	# OSF/1 1.[012] from OSF, and derivatives, including Paragon OSF/1
	SHLIB_CFLAGS=""
	# Hack: make package name same as library name
	SHLIB_LD='ld -R -export $@:'
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadOSF.o"
	DL_LIBS=""
	LD_FLAGS=""
	LD_SEARCH_FLAGS=""
	;;
    OSF1-1.*)
	# OSF/1 1.3 from OSF using ELF, and derivatives, including AD2
	SHLIB_CFLAGS="-fpic"
	SHLIB_LD="ld -shared"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS=""
	LD_FLAGS=""
	LD_SEARCH_FLAGS=""
	;;
    OSF1-V*)
        # Digital OSF/1
	SHLIB_CFLAGS=""
	SHLIB_LD='ld -shared -expect_unresolved "*"'
	SHLIB_LD='ld -shared -expect_unresolved \"*\"' # <-- row inserted by CK
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS=""
	LD_FLAGS=""
	LD_SEARCH_FLAGS='-Wl,-rpath,${LIB_INSTALL_DIR}'
	;;
    RISCos-*)
	SHLIB_CFLAGS="-G 0"
	SHLIB_LD="echo tclLdAout $CC \{$SHLIB_CFLAGS\} | `pwd`/tclsh -r -G 0"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX="..o"
	DL_OBJS="tclLoadAout.o"
	DL_LIBS=""
	LD_FLAGS="-Wl,-D,08000000"
	LD_SEARCH_FLAGS=""
	;;
    SCO_SV-3.2*)
        # Note, dlopen is available only on SCO 3.2.5 and greater.  However,
        # this test works, since "uname -s" was non-standard in 3.2.4 and
        # below.
	SHLIB_CFLAGS="-Kpic -belf"
	SHLIB_LD="ld -G"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS=""
	LD_FLAGS="-belf -Wl,-Bexport"
	LD_SEARCH_FLAGS=""
	;;
     SINIX*5.4*)
	SHLIB_CFLAGS="-K PIC"
	SHLIB_LD="cc -G"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS="-ldl"
	LD_FLAGS=""
	LD_SEARCH_FLAGS=""
	;;
    SunOS-4*)
	SHLIB_CFLAGS="-PIC"
	SHLIB_LD="ld"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS="-ldl"
	LD_FLAGS=""
	LD_SEARCH_FLAGS='-L${LIB_INSTALL_DIR}'

	# SunOS can't handle version numbers with dots in them in library
	# specs, like -ltcl7.5, so use -ltcl75 instead.  Also, it
	# requires an extra version number at the end of .so file names.
	# So, the library has to have a name like libtcl75.so.1.0

	TCL_SHARED_LIB_SUFFIX='`echo ${VERSION} | tr -d .`.so.1.0'
	TCL_UNSHARED_LIB_SUFFIX='`echo ${VERSION} | tr -d .`.a'
	TCL_LIB_VERSIONS_OK=nodots
	;;
    SunOS-5*)
	SHLIB_CFLAGS="-K PIC"
	SHLIB_LD="/usr/ccs/bin/ld -G -z text"
	SHLIB_LD_LIBS='${LIBS}'
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS="-ldl"
	LD_FLAGS=""
	LD_SEARCH_FLAGS='-R ${LIB_INSTALL_DIR}'
	;;
    ULTRIX-4.*)
	SHLIB_CFLAGS="-G 0"
	SHLIB_SUFFIX="..o"
	SHLIB_LD="echo tclLdAout $CC \{$SHLIB_CFLAGS\} | `pwd`/tclsh -r -G 0"
	SHLIB_LD_LIBS=""
	DL_OBJS="tclLoadAout.o"
	DL_LIBS=""
	LD_FLAGS="-Wl,-D,08000000"
	LD_SEARCH_FLAGS=""
	;;
    UNIX_SV*)
	SHLIB_CFLAGS="-K PIC"
	SHLIB_LD="cc -G"
	SHLIB_LD_LIBS=""
	SHLIB_SUFFIX=".so"
	DL_OBJS="tclLoadDl.o"
	DL_LIBS="-ldl"
	LD_FLAGS="-Wl,-Bexport"
	LD_SEARCH_FLAGS=""
	;;
esac

if test "x$DL_OBJS" != "x" ; then
    BUILD_DLTEST="\$(DLTEST_TARGETS)"
else
    echo "Can't figure out how to do dynamic loading or shared libraries"
    echo "on this system."
    SHLIB_CFLAGS=""
    SHLIB_LD=""
    SHLIB_SUFFIX=""
    DL_OBJS="tclLoadNone.o"
    DL_LIBS=""
    LD_FLAGS=""
    LD_SEARCH_FLAGS=""
    BUILD_DLTEST=""
fi

# If we're running gcc, then change the C flags for compiling shared
# libraries to the right flags for gcc, instead of those for the
# standard manufacturer compiler.

if test "$DL_OBJS" != "tclLoadNone.o" ; then
    if test "$CC" = "gcc" -o `$CC -v 2>&1 | grep -c gcc` != "0" ; then
	SHLIB_CFLAGS="-fPIC"
    fi
fi

AC_SUBST(SHLIB_CFLAGS)
AC_SUBST(SHLIB_LD)
AC_SUBST(SHLIB_LD_LIBS)
AC_SUBST(SHLIB_SUFFIX)

AC_SUBST(DL_LIBS)
AC_SUBST(DL_OBJS)
AC_SUBST(LD_FLAGS)
AC_SUBST(LD_SEARCH_FLAGS)
])
