# --------------------------------------------------------------------
# $Id: help.tcl,v 1.12 1997/07/06 15:10:37 adabas Exp $
# --------------------------------------------------------------------
# Copyright (c) 1996-1997 Christian Krone. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Tcl itself.
# See also licence.terms
# --------------------------------------------------------------------

proc htmlHelp {htmlFile withNetscape} {
    global options renderCmds embed_args

    set w .help

    if [winfo exists $w] {
	if ![string compare [wm state $w] iconic] {wm deiconify $w}
	raise $w
	return
    }

    if [catch {open $htmlFile} file] {
	tk_dialog .no_help "No Help available" \
		"Since the file $htmlFile isn't installed correctly,\
		no help is available" "" 0 Ok
	return
    }

    if {$withNetscape || [info exists embed_args]} {
	if ![catch {callNetscape $htmlFile}] {
	    close $file
	    return
	}
    }

    toplevel $w
    button $w.quit -text Dismiss -com "destroy $w"
    pack   $w.quit   -side bottom -fill x

    label  $w.status -textvariable helpStatus
    pack   $w.status -side bottom -ipadx 10 -anchor w

    scrollbar $w.scroll -command "$w.text yview"
    pack      $w.scroll -side right -fill y

    text $w.text -yscrollcommand "$w.scroll set"
    pack $w.text -fill both -expand 1 -side left -ipady 10 -ipadx 10

    bind  $w.text <Prior>     "$w.text yview scroll -1 pages; break"
    bind  $w.text <Next>      "$w.text yview scroll  1 pages; break"
    bind  $w.text <Home>      "$w.text yview moveto  0;       break"
    bind  $w.text <End>       "$w.text yview moveto  1;       break"
    bind  $w.text <Control-c> "destroy $w;                    break"
    bind  $w.text <F3>        "destroy $w;                    break"
    bind  $w      <Enter>     "focus $w.text;                 break"

    helpStatus "Parsing file $htmlFile..."
    HMinit_hyperwin $w.text
    set lastTag [HMparse_html [read $file] renderCmds 0 10 leftover HMrender]
    close $file

    set i 0
    while {$i < $lastTag} {
	set pct [expr {int($i*100/$lastTag)}]
	helpStatus "Rendering file (${pct}%)..."
	regsub -all {\\win\\} $renderCmds([incr i]) $w.text renderCmd

	if [catch $renderCmd msg] {
	    # If there was an error while rendering the text,
	    # probably the Dismiss button already destroyed the help window...
	    if ![string compare $msg "invalid command name \"$w.text\""] return
	}
    }
    helpStatus "Rendering file...done"

    catch {$w.text configure -state disabled}
}

# The following call stands here to force the sourcing of htmllib.tcl.
# This way we can thereafter redeclare some procedures...

HMlibrary_init

proc HMset_image {state win handle src} {
  helpStatus "Reading image $src"
  switch -glob $src {
    *.xbm   {
      if [regexp {^([^:]*):} $src match color] {
	regsub {^[^:]*:} $src "" src
      } else {
	set color black
      }
      set img [image create bitmap -file $src -foreground $color]
    }
    default {
      set img [image create photo  -file $src]
    }
  }
  HMgot_image $handle $img
}

proc HMlink_callback {state win href} {
  switch -glob $href {
    #* {
      HMgoto $state [string range $href 1 end]
    }
    default {
      puts "Got hit on $win, link $href, not yet implemented."
    }
  }
}

proc helpStatus {txt} {
  global helpStatus
  set helpStatus $txt
  update
}
