
# ---------------------------------------------------------------------
# Copyright (c) 1996-1997 Christian Krone. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Tcl itself.
# See also licence.terms
# $Id: infoSheet.tcl,v 1.6 1997/06/21 17:36:32 adabas Exp $
# ----------------------------------------------------------------------------

proc mkInfoSheet {i} {
    global currVal adamsg

    regexp {\(for Adabas D (.*)\)} $adamsg(version) match version
    set vers62 [expr {$version >= 6.2}]

    frame $i -width 480 -height 300 -relief raised -borderwidth 2
    pack $i -expand 1 -fill both

    frame $i.t -relief raised -borderwidth 2
    pack  $i.t -expand 1 -fill both
    label $i.t.l -text "Usage Levels and Serverdb State"
    pack  $i.t.l -side left -padx 10
    label $i.t.r -text "at"
    label $i.t.v -textvar currVal(stateAt) -width 20 -relief sunken
    pack  $i.t.v $i.t.r -side right -padx 10 -pady 5
    
    pack [ruler $i.m] -ipady 5
    trace variable currVal(data_pct)     w updateMeter
    trace variable currVal(log_pct)      w updateMeter
    trace variable currVal(sessions_pct) w updateMeter

    frame $i.w    -relief raised -borderwidth 2
    label $i.w.w1 -textvar currVal(sysTabsLoaded) -anchor w -foreground blue
    label $i.w.w2 -textvar currVal(warning)       -anchor e -foreground red
    pack  $i.w    -expand 1 -fill x -ipadx 15 -ipady 3
    pack  $i.w.w1 -side left
    pack  $i.w.w2 -side right

    frame $i.b
    pack  $i.b -expand 1 -fill both

    frame $i.b.l -relief raised -borderwidth 2
    frame $i.b.r -relief raised -borderwidth 2
    pack  $i.b.l $i.b.r -side left -ipadx 10 -ipady 5 -expand 1 -fill both

    frame $i.b.l.t
    frame $i.b.l.v
    frame $i.b.r.t
    frame $i.b.r.v
    pack  $i.b.l.t $i.b.l.v $i.b.r.t $i.b.r.v -side left -expand 1 -fill both

    label $i.b.l.t.sta -text "State"
    label $i.b.l.t.bac -text "Background"
    label $i.b.l.t.log -text "Log Segments"
    label $i.b.l.t.aut -text "Autosave Log"
    label $i.b.l.t.rem -text "Remote SQL"
    pack  $i.b.l.t.sta $i.b.l.t.bac $i.b.l.t.log $i.b.l.t.aut $i.b.l.t.rem \
	    -anchor w -fill y -expand 1

    label $i.b.l.v.sta -relief sunken -width 20 -anchor w \
	    -textvariable currVal(state)
    label $i.b.l.v.bac -relief sunken -width 20 -anchor w \
	    -textvariable currVal(background)
    label $i.b.l.v.log -relief sunken -width 20 -anchor w \
	    -textvariable currVal(logSegments)
    label $i.b.l.v.aut -relief sunken -width 20 -anchor w \
	    -textvariable currVal(autosaveLog)
    label $i.b.l.v.rem -relief sunken -width 20 -anchor w \
	    -textvariable currVal(remoteSQL)
    pack  $i.b.l.v.sta $i.b.l.v.bac $i.b.l.v.log $i.b.l.v.aut $i.b.l.v.rem \
	    -fill x -expand 1 -anchor w -ipady 1 -pady 1 -ipadx 2 -padx 5

    if $vers62 {
	pack forget $i.b.l.t.bac $i.b.l.t.log $i.b.l.v.bac $i.b.l.v.log
    }

    label $i.b.r.t.com -text "SQL Commands"
    label $i.b.r.t.rea -text "Logical Reads"
    label $i.b.r.t.wri -text "Logical Writes"
    label $i.b.r.t.hit -text "Data Cache Hitrate in %"
    label $i.b.r.t.con -text "Converter Cache Hitrate in %"
    pack  $i.b.r.t.com $i.b.r.t.rea $i.b.r.t.wri $i.b.r.t.hit $i.b.r.t.con \
	    -anchor w -fill y -expand 1

    label $i.b.r.v.com -relief sunken -width 20 -anchor e \
	    -textvariable currVal(sqlCommands)
    label $i.b.r.v.rea -relief sunken -width 20 -anchor e \
	    -textvariable currVal(reads)
    label $i.b.r.v.wri -relief sunken -width 20 -anchor e \
	    -textvariable currVal(writes)
    label $i.b.r.v.hit -relief sunken -width 20 -anchor e \
	    -textvariable currVal(hitrate)
    label $i.b.r.v.con -relief sunken -width 20 -anchor e \
	    -textvariable currVal(converter)
    pack  $i.b.r.v.com $i.b.r.v.rea $i.b.r.v.wri $i.b.r.v.hit $i.b.r.v.con \
	    -fill x -expand 1 -anchor w -ipady 1 -ipadx 2 -padx 5

    if $vers62 {
	pack forget $i.b.r.t.rea $i.b.r.t.wri $i.b.r.v.rea $i.b.r.v.wri
    }

    label $i.s -width 80 -textvar currVal(message) -relief raised -anchor w
    pack  $i.s -expand 1 -fill both -ipady 3

    update
}

proc ruler {c} {
    global _meter

    set _meter(c) [canvas $c -width 22c -height 6.2c -relief raised -borderwidth 2]

    $c create line 1c 1c 1c 1.5c 21c 1.5c 21c 1c -width 2

    $c create text 1c .9c -text "0%" -anchor s
    for {set y 12} {$y < 210} {incr y 2} {
	if {$y % 5} {$c create line ${y}m 1.5c ${y}m 1.3c -width 1}
    }
    for {set i 1} {$i <= 10} {incr i} {
	set x [expr 2*$i]
	$c create line ${x}c 1.5c ${x}c 1.2c -width 2
	set x [expr 2*$i+1]
	$c create line ${x}c 1.5c ${x}c 1c   -width 2
	$c create text ${x}c 1c -text "${i}0%" -anchor s
    }

    frame $c.datf
    label $c.datf.what -text "Data in pages"
    label $c.datf.vala -textvar currVal(data) -relief sunken -width 10
    label $c.datf.pct  -text "in %"
    label $c.datf.valp -textvar currVal(data_pct) -relief sunken -width 4
    pack  $c.datf.valp $c.datf.pct $c.datf.vala $c.datf.what -side right
    $c create window 211m 20m -window $c.datf -anchor e

    frame $c.logf
    label $c.logf.what -text "Log in pages"
    label $c.logf.vala -textvar currVal(log) -relief sunken -width 10
    label $c.logf.pct  -text "in %"
    label $c.logf.valp -textvar currVal(log_pct) -relief sunken -width 4
    pack  $c.logf.valp $c.logf.pct $c.logf.vala $c.logf.what -side right
    $c create window 211m 35m -window $c.logf -anchor e

    frame $c.sesf
    label $c.sesf.what -text "Sessions"
    label $c.sesf.vala -textvar currVal(sessions) -relief sunken -width 10
    label $c.sesf.pct  -text "in %"
    label $c.sesf.valp -textvar currVal(sessions_pct) -relief sunken -width 4
    pack  $c.sesf.valp $c.sesf.pct $c.sesf.vala $c.sesf.what -side right
    $c create window 211m 50m -window $c.sesf -anchor e

    oneMeter  $c data_pct     75 10.0 25.8 210.0 28.2
    oneMeter  $c log_pct      75 10.0 40.8 210.0 43.2
    oneMeter  $c sessions_pct 75 10.0 55.8 210.0 58.2

    return $c
}


proc oneMeter {c tag alarmPct x1 y1 x2 y2} {
    global _meter

    set _meter($tag,x1) $x1
    set _meter($tag,y1) $y1
    set _meter($tag,x2) $x2
    set _meter($tag,y2) $y2
    set _meter($tag,alarm_pct) $alarmPct

    set x1p [winfo pixels $c [expr {$x1-0.8}]m]
    set y1p [winfo pixels $c [expr {$y1-0.8}]m]
    set x2p [winfo pixels $c [expr {$x2+0.8}]m]
    set y2p [winfo pixels $c [expr {$y2+0.8}]m]
    set off [winfo pixels $c 0.8m]

    $c create polygon \
	    [expr {$x1p-$off}] [expr {$y1p-$off}] \
	    [expr {$x2p+$off}] [expr {$y1p-$off}] \
	    [expr {$x2p-1}]    [expr {$y1p+1}]    \
	    [expr {$x1p+1}]    [expr {$y2p-1}]    \
	    [expr {$x1p-$off}] [expr {$y2p+$off}] \
	    -outline "" -fill gray45
    $c create polygon \
	    [expr {$x1p-$off}] [expr {$y2p+$off}] \
	    [expr {$x1p+1}]    [expr {$y2p-1}]    \
	    [expr {$x2p-1}]    [expr {$y1p+1}]    \
	    [expr {$x2p+$off}] [expr {$y1p-$off}] \
	    [expr {$x2p+$off}] [expr {$y2p+$off}] \
	    -outline "" -fill gray95
    $c create rectangle $x1p $y1p $x2p $y2p -outline "" -fill gray70

    set x1p [winfo pixels $c ${x1}m]
    set y1p [winfo pixels $c ${y1}m]
    set x2p [winfo pixels $c ${x1}m]
    set y2p [winfo pixels $c ${y2}m]
    set off [winfo pixels $c 0.8m]

    #
    # Create the base quicksilver line in green.
    #
    $c create polygon \
	    [expr {$x1p-$off}] [expr {$y1p-$off}] \
	    [expr {$x2p+$off}] [expr {$y1p-$off}] \
	    [expr {$x2p-1}]    [expr {$y1p+1}]    \
	    [expr {$x1p+1}]    [expr {$y2p-1}]    \
	    [expr {$x1p-$off}] [expr {$y2p+$off}] \
	    -outline "" -fill gray95 -tag ${tag}1
    $c create polygon \
	    [expr {$x1p-$off}] [expr {$y2p+$off}] \
	    [expr {$x1p+1}]    [expr {$y2p-1}]    \
	    [expr {$x2p-1}]    [expr {$y1p+1}]    \
	    [expr {$x2p+$off}] [expr {$y1p-$off}] \
	    [expr {$x2p+$off}] [expr {$y2p+$off}] \
	    -outline "" -fill gray45 -tag ${tag}2
    $c create rectangle $x1p $y1p $x2p $y2p -outline "" -fill SeaGreen -tag ${tag}3

    # And now the red tip of the quicksilver (for more than ALARM%)
    set x1p [winfo pixels $c [expr {($x2-$x1)*$alarmPct/100+$x1}]m]
    $c create polygon [expr {$x1p+$off}] $y1p $x2p $y1p \
	    $x2p $y2p [expr {$x1p-$off}] $y2p -outline "" -fill red -tag ${tag}4
    $c lower ${tag}4
}


proc setMeter {c tag pct} {
    global _meter

    set x1p [winfo pixels $c $_meter($tag,x1)m]
    set y1p [winfo pixels $c $_meter($tag,y1)m]
    set xop [winfo pixels $c $_meter($tag,x2)m]
    set y2p [winfo pixels $c $_meter($tag,y2)m]
    set x2p [expr {($xop-$x1p)*$pct/100+$x1p}]
    set off [winfo pixels $c 0.8m]

    $c coords ${tag}1 \
	    [expr {$x1p-$off}] [expr {$y1p-$off}] \
	    [expr {$x2p+$off}] [expr {$y1p-$off}] \
	    [expr {$x2p-1}]    [expr {$y1p+1}]    \
	    [expr {$x1p+1}]    [expr {$y2p-1}]    \
	    [expr {$x1p-$off}] [expr {$y2p+$off}]
    $c coords ${tag}2 \
	    [expr {$x1p-$off}] [expr {$y2p+$off}] \
	    [expr {$x1p+1}]    [expr {$y2p-1}]    \
	    [expr {$x2p-1}]    [expr {$y1p+1}]    \
	    [expr {$x2p+$off}] [expr {$y1p-$off}] \
	    [expr {$x2p+$off}] [expr {$y2p+$off}] 
    $c coords ${tag}3 $x1p $y1p $x2p $y2p

    # And now the red tip of the quicksilver (for more than ALARM%)
    if {$pct > $_meter($tag,alarm_pct)} {
	set x1p [expr {($xop-$x1p)*$_meter($tag,alarm_pct)/100+$x1p}]
	$c coords ${tag}4 \
		[expr {$x1p+$off}] $y1p $x2p $y1p \
		$x2p $y2p [expr {$x1p-$off}] $y2p
	$c raise ${tag}4
    } else {
	$c lower ${tag}4
    }
}

proc updateMeter {name1 name2 op} {
    global _meter

    upvar $name1 x
    setMeter $_meter(c) $name2 $x($name2)
}
