# ---------------------------------------------------------------------
# Copyright (c) 1996-1997 Christian Krone. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Tcl itself.
# See also licence.terms
# $Id: prolog.tcl,v 1.13 1997/07/06 15:09:56 adabas Exp $
# ----------------------------------------------------------------------------

# ---------------------------------------------------------------------
# First and all we need the AdabasTcl extension.
# ---------------------------------------------------------------------

proc loadAdabastcl {} {
    global env auto_path

    if ![info exists env(DBROOT)] {
	append err "This application is only functional, if the environment " \
		"variable DBROOT is set correctly."

	tk_dialog .err "Fatal error" $err questhead 0 Exit  
        exit 1
    }

    # We better put our directories at the front of the path...
    set auto_path [linsert $auto_path 0 $env(DBROOT)/lib $env(DBROOT)/tcl]

    if [catch {package require Adabastcl} msg] {
	append err "This application is only functional with the Adabastcl " \
		"extension. While starting it, the following error occurs:" \
		"\n\n$msg\n\n" \
		"You must have set DBROOT correctly (its current value is " \
		"$env(DBROOT)) and you have to have an installed " \
		"AdabasTcl extension to the Adabas D database server."

	tk_dialog .err "Fatal error" $err questhead 0 Exit  
        exit 2
    }

    # Just to be sure, that the extension is loaded. "package require" does
    # not actually load the shared library, but adds the commands only to the
    # list of the unknown procedures; this applies not to variables - and we
    # will need adabastcl_library more or less immediately.
    adabas version

    # We switch on the trace, if the appropriate environment variable is set.
    if [info exists env(ADABASTCL_TRACE)] {
	global adamsg
	set adamsg(tracefile) $env(ADABASTCL_TRACE)
    }
}

# ----------------------------------------------------------------------
# Is Tk loaded at all? This error can happen, if e.g. the DISPLAY
# variable isn't set or points to the wrong display. Since the X server
# already complained to stdout, our messages here can be rather terse.
# ----------------------------------------------------------------------

if [catch {package require Tk}] {
    puts "GUI not available. Exited"
    exit 3
}

# ----------------------------------------------------------------------
# Now we have to do some limbo to get TclTk's version clear.
# 1. The argument of the -weight option of the grid command changed
#    from float into an integer.
# 2. Are we running as plugin or have a Tk version, that is capable of
#    reading gif out of the -data option?
# 3. Do we have a Tk with the new font command?
# 4. Do we have a Tk with the new menu bar mechanism?
# 5. Do we have a Tk with native dialogs (tk_messageBox/tk_getOpenFile)?
# 6. Do we have the "file delete" subcommand?
# 7. Do we have a Tk, where buttons understand the -default option?
# ----------------------------------------------------------------------

set tkCompat(gridWeightMax) [expr $tk_version  >= 4.2 ? 100 : 1.0]
set tkCompat(gridWeightMin) [expr $tk_version  >= 4.2 ?   0 : 0.0]
set tkCompat(imageViaData)  [expr $tk_version  >= 8.0 || [info exists embed_args]]
set tkCompat(fontCmd)       [expr $tk_version  >= 8.0]
set tkCompat(menubars)      [expr $tk_version  >= 8.0]
set tkCompat(nativeDialogs) [expr $tk_version  >= 4.2]
set tkCompat(fileDelCmd)    [expr $tcl_version >= 7.6]
switch -glob $tk_patchLevel {
    tk8.0a? - tk8.0b1 {set tkCompat(defaultButton) 1}
    tk[89]*           {set tkCompat(defaultButton) normal}
}

# ----------------------------------------------------------------------
# If this is not a development environment, we redefine tkerror here, so
# that the user doesn't see the "See trace" and "Skip messages" buttons.
# ----------------------------------------------------------------------

if ![info exists env(ADABASTCL_APPLICATIONS_DEVELOPMENT)] {
    proc bgerror err {
	tk_messageBox -icon error -title "Error" -message "Error: $err"
    }
}

# -------------------------------------------------------------------------
# aboutHelp: The notorious about dialog.
# -------------------------------------------------------------------------

proc aboutHelp {appl} {
    tk_messageBox -title "About $appl" -message "Adabas D: $appl
Version 1.0\n\nJuly 1997\n\nChristian Krone
krischan@cs.tu-berlin.de" -type ok
}

# ---------------------------------------------------------------------
# callHtmlHelp: Small wrapper around htmlHelp.
# ---------------------------------------------------------------------
proc callHtmlHelp {appl} {
    global adabastcl_library options

    htmlHelp $adabastcl_library/manuals/$appl.html $options(val:netscapeHelp)
}

# ---------------------------------------------------------------------
# callNetscape: Calls netscape to display the given file.
# ---------------------------------------------------------------------
proc callNetscape {file} {
    global tcl_platform env embed_args

    if [info exists embed_args] {
	if ![catch {browser_displayURL AdabasTcl file:$file}] return
    }

    switch $tcl_platform(platform) {
	windows {
	    foreach var {TMP TEMP TMPDIR} {
		if [info exists env($var)] {
		    set tmpDir $env($var)
		    break
		}
	    }
	    if ![info exists tmpDir] {
		set tmpDir c:/tmp
	    }
	    set shortcut [file join $tmpDir adtcltmp.url]
	    set err      [catch {open $shortcut w} url]
	    if $err {
		set msg $url
	    } else {
		puts  $url "\[InternetShortcut]"
		puts  $url "URL=file:$file"
		close $url
		set err [catch {exec rundll32.exe url.dll,OpenURL $shortcut} msg]
	    }
	}
	default {
	    set err [catch {exec netscape -remote openURL(file:$file,AdabasTcl) >&/dev/null} msg]
	    if $err {
		set err [catch {exec netscape file:$file >&/dev/null &} msg]
	    }
	}
    }
    if $err {
	return -code error $msg
    }
    return ""
}
