
# ---------------------------------------------------------------------
# $Id: toolBox.tcl,v 1.11 1997/07/06 15:12:09 adabas Exp $
# ---------------------------------------------------------------------
# Copyright (c) 1997 Christian Krone. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Tcl itself.
# See also licence.terms
# ----------------------------------------------------------------------------

proc toolBox {w args} {
    frame $w  -relief raised -borderwidth 2 -highlightthickness 0
    set ok [toolButton   1 $w new   "doNew" \
	    "New SQL"      "Clear the SQL window"]
    set ok [toolButton $ok $w prev  "prevSql -1" \
	    "Previous SQL" "Display the previous SQL statement"]
    set ok [toolButton $ok $w next  "prevSql  1" \
	    "Next SQL"     "Display the next SQL statement"]
    set ok [toolSep    $ok $w 0]
    set ok [toolButton $ok $w exec  {eval $execCmd} \
	    "Execute SQL"  "Execute the SQL statement"]
    set ok [toolSep    $ok $w 1]
    set ok [toolButton $ok $w open  "openSql" \
	    "Open File"    "Read the content of a file into the SQL window"]
    set ok [toolButton $ok $w save  "saveSql" \
	    "Save SQL"     "Save the content of the SQL window into a file"]
    set ok [toolButton $ok $w obj   "showTree" \
	    "Show DB Objects" "Display DB objects in a tree window."]
    set ok [toolButton $ok $w get   "getQuery" \
	    "Get Query"    "Display a stored command in the SQL window."]
    set ok [toolSep    $ok $w 2]
    set ok [toolButton $ok $w up    "scrollBox .o up" \
	    "Scroll up results"    "Scroll results one page up"]
    set ok [toolButton $ok $w down  "scrollBox .o down" \
	    "Scroll down results"  "Scroll results one page down"]
    set ok [toolButton $ok $w left  "scrollBox .o left" \
	    "Scroll left results"  "Scroll results one page to the left"]
    set ok [toolButton $ok $w right "scrollBox .o right" \
	    "Scroll right results" "Scroll results one page to the right"]
    set ok [toolButton $ok $w view  "preview" \
	    "Preview" "Preview the results"]
    set ok [toolSep    $ok $w 3]
    set ok [toolButton $ok $w help  "callHtmlHelp tkquery" \
	    "Help"    "Display the help text for TkQuery"]
    set ok [toolButton $ok $w exit  "confirmExit" \
	    "Exit"    "Exit TkQuery"]
    if $ok {
	if [catch {mkImage stop}] return
	eval pack $w -anchor w -fill x $args
    }
}

proc mkImage {name} {
    global adabastcl_library imageData

    if [info exists imageData($name)] {
	image create photo img_$name -format gif -data $imageData($name)
    } else {
	if ![string length [info commands toolBoxImages]] {
	    if [catch {image create photo toolBoxImages -format gif \
		    -file [file join $adabastcl_library tools.gif]} msg] {
		return -code error "Could not create toolbox buttons: $msg"
	    }
	}
	switch $name {
	    down  {set x   0}
	    exec  {set x  29}
	    exit  {set x  58}
	    get   {set x  87}
	    help  {set x 116}
	    left  {set x 145}
	    new   {set x 174}
	    next  {set x 203}
	    open  {set x 232}
	    prev  {set x 261}
	    right {set x 290}
	    save  {set x 319}
	    stop  {set x 348}
	    up    {set x 377}
	    view  {set x 406}
	    obj   {set x 435}
	}
	image create photo img_$name
	img_$name copy toolBoxImages -from $x 0 [expr $x+29] 29
    } 
    return img_$name
}

proc toolButton {ok frame name cmd balloon help} {
    global balloonHelp

    if !$ok {return 0}

    if [catch {mkImage $name} imgName] {return 0}

    set but [button $frame.$name -image $imgName -command $cmd \
	    -highlightthickness 0 -borderwidth 2 -relief raised -takefocus 0]

    bind $but <Enter> [list setMsg -help $help]
    bind $but <Leave> [list setMsg -reset]

    set balloonHelp($but) $balloon
    bindtags $but [list $but Button . all balloon]
    pack $but -side left -padx 1 -pady 1

    return 1
}

proc confToolButton {frame name img balloon help} {
    global balloonHelp

    set but $frame.$name
    bind $but <Enter> [list setMsg -help $help]
    bind $but <Leave> [list setMsg -reset]
    $but configure -image img_$img
    set balloonHelp($but) $balloon
    update idletasks
}

proc toolSep {ok frame cnt} {
    pack [frame $frame.sp$cnt -width 8] -side left
    return 1
}

# -------------------------------------------------------------------------
# The following procedures, which implements the balloon help, are (slightly
# modified) from John Haxby <jch@hazel.pwd.hp.com>. Thanks, John!
# -------------------------------------------------------------------------
bind balloon <Enter> {
    if {$options(val:balloonHelp) && [info exists balloonHelp(%W)] \
	    && [string compare [%W cget -state] disabled]} {
	set balloonHelp(%W,after) [after 500 {showBalloonHelp %W}]
    }
}
foreach event {Leave Any-KeyPress Any-Button} {
    bind balloon <$event> {unShowBalloonHelp %W}
}

proc showBalloonHelp {w} {
    global balloonHelp tcl_platform

    if ![info exists balloonHelp($w)] return

    set curpos [winfo pointerxy $w]
    set curwin [eval winfo containing $curpos]
    if ![string compare $w $curwin] {
	if ![winfo exists .balloon] {
	    toplevel .balloon
	    wm overrideredirect .balloon true
	    pack [label .balloon.l -foreground black -background yellow \
		    -highlightthickness 1 -highlightbackground black]
	    wm withdraw .balloon
	}
	.balloon.l configure -text $balloonHelp($w)

        update idletask
	set x [expr [lindex $curpos 0]+16]
	set y [expr [lindex $curpos 1]+16]
        raise .balloon

	# The following looks funny, but it is the only way, I've found
	# to get the help popups at the correct place on evere platform
	switch $tcl_platform(platform) {
	    unix {
		wm geometry  .balloon +$x+$y
		wm deiconify .balloon
	    }
	    default {
		wm deiconify .balloon
		wm geometry  .balloon +$x+$y
	    }
	}
    }
}

proc unShowBalloonHelp {w} {
    global balloonHelp
    if [info exists balloonHelp($w,after)] {
	after cancel $balloonHelp($w,after)
	unset balloonHelp($w,after)
    }
    catch {wm withdraw .balloon}
}

if !$tkCompat(imageViaData) return

set imageData(down) {
    R0lGODdhHQAdAMIAAL6+vgAAACyKVQAA/wAAggAAAAAAAAAAACwAAAAAHQAdAAADbAi63P4w
    yrmCvYHKIHrPGsR5Ahg6FmmeTDCMJYsO7yc3Ls2td67zMt8LyBK+bi2akngyMkNOZGVAIFCf
    moCVepQCXNWr97u1Yh8YC9VKSJ8V2nB5XX1Xqvh8PajP29F6fxFxbWN3ghSIhosRCQA7
}
set imageData(exec) {
    R0lGODdhHQAdAMIAAL6+vgAAAC9PT/ffsiyKVQAAAAAAAAAAACwAAAAAHQAdAAADfQi63P4w
    ykmrreFiELoTgyAKVEecGQMObDhCwSmnS2uzNBMTYzD+t5aoEVsFhZ0jaVE8KkW2paLprAp1
    p58WqMTKCBljtBW4MnfgcFA8KId0HM9iC8WZpxF2yM6STvSAFmxubXcUdEE5FGs3ihOMURo3
    JFoalpeYmZqbnJoJAD
}
set imageData(exit) {
    R0lGODdhHQAdAOMAAL6+vgAAAHCAkPXes82FPy6LVwD//y9PT9zc3AAAAAAAAAAAAAAAAAAA
    AAAAAAAAACwAAAAAHQAdAAAEwxDISau9mIbNe89WIIxkKQwBWIlmGaCCOrGt8BKiugG0OwwE
    XAwUKGxaL2AwRzQYTcngcpgJGJy9m1Sou2JJWilz5rF6C2ClmMrzut+s8FTzrn/l3Jn9/cSP
    JWVmTmgjNwcHc02DNC8HCIh5VYs+BwCQfxdFTz4Eh4lVRj02ap8YO6J+bJmAUKSROmWumFUA
    I7WpQzG6urW9tqNbLL2+Ery8vWEDv7XGxr66WjDE0865PEAoxc/b1dA/KcvW4tQ8O+MCEQA7
}
set imageData(get) {
    R0lGODdhHQAdAMIAAL6+vgAAAP/6zQAA/wAAgHCAkAAAAAAAACwAAAAAHQAdAAADlwi63P4w
    ykmrvTiDIPr4QyeOgRScKCoQrHB2QVE83DiCH+zKTvq2vhcnNmPUbiCbaMgzroBBlY7oxIWU
    y2lzE+3qXLviEascasVkshlM3cC8JDC7OU5na4EBgf4OluUBe3x2NmZ6MoOEdyuIRSyPkJFH
    QwONCnlWmR+BU4JFXF1BQIdbDJGnp4gSjaytlquusZ8atLW2FQkAO6J
}
set imageData(help) {
    R0lGODdhHQAdAMIAAL6+vv+lAP8AALIiInCAkAAAAAAAAAAAACwAAAAAHQAdAAADhQi63P5Q
    hUlrhFPozfVlQTeM5KgRX7iVLClcqlASqNYOqBPPtGKzvYYKmAMMebrfbHEkBRtKZ645ekJb
    vR3yEaWhqDgrVBb+RqtFiDd4Ln+EZKn4TV2/4fFy+m5U2vljaHOAACdehGqHiHg4i3AhI45M
    Gkd7hCJhkoU/ipJkf5prlo6dEQkAO4g
}
set imageData(left) {
    R0lGODdhHQAdAMIAAL6+vgAAAAAAgAAA/y6LVwAAAAAAAAAAACwAAAAAHQAdAAADXgi63P4w
    ykmrvThrGjYMndcEQigqZHmiQmuKrTCAdG3XTtoOsjz8swBhSHwBdD0ecDkjDl/IZJLZLI5i
    uym1SjAeY0otVdh9YG9o20Pn3aTabtVqAZoz4Pa8fs/vexIAO3O
}
set imageData(new) {
    R0lGODdhHQAdAMIAAL6+vgAAAP/7z9O2jnGCkgAAAAAAAAAAACwAAAAAHQAdAAADagi63P4u
    yEkpfEHozbW8TdaNwRCAizhypYkC6uoN9IDGckWAuFwPu0vPRwtChjKNEZOULSPN1TMUHU0Z
    yOQ1Ve1sFVknr8v5wsgbc1g6RgvU7ncbDXfX6XPyXc+r+P1mAASDhIWGhC+JFwkAO3A
}
set imageData(next) {
    R0lGODdhHQAdAMIAAL6+vqBSLdK0jAAAAP/6zS6LVwAAAAAAACwAAAAAHQAdAAADXgi63P4w
    ykmrvTi3oGMQHTCMZGmOFKGubKsO0/DKMkHbLBzN9sjXtolrOKOcjqjQJ/RYMjegJ8MpVXw4
    VSs2G9hWu1nANUx9FsSgsxldUKsv53ghDXhj2vi8PcynJAAAOwS
}
set imageData(open) {
    R0lGODdhHQAdAMIAAAAAAL6+vi6LV/Xes//6zQAAAAAAAAAAACwAAAAAHQAdAAADgQix3P5Q
    KEjrEtJqh/PenfdVoTg+pXkyJTCtTTkM7ruGwKzXNu86AExOR5wxAISk0hYIDos0mktJJTAV
    z9nQx61Bdlptdcxc5LZa5Jhabp7Dg3W1jXxL5WyI2ofPP9R9cnSBeIOEa4aHc3qKZIyNfkCQ
    kQ2Ak3QAmZqbnJ0wn6APCQA7
}
set imageData(prev) {
    R0lGODdhHQAdAMIAAL6+vqBSLdK0jAAAAP/6zS6LVwAAAAAAACwAAAAAHQAdAAADXwi63P4w
    ykmrvTi/oGMQnDaMZGmO0kisbOsSg/SqqzrAxETDt83jMd3tRQxSTkiU5hPqNJhOBzTKmFIV
    H9B1Yb12qV9ntgnWbgvQglMNUGvZHXWhIJi375m5fg/f+i0JAD
}
set imageData(right) {
    R0lGODdhHQAdAMIAAL6+vgAAAAAAgC6LVwAA/wAAAAAAAAAAACwAAAAAHQAdAAADXgi63P4w
    ykmrvTjrvQKHgfc1gSCOSmmiqeCCYSzPsbs6wTAERO//BEEw6Dp1dDvgT8i03Y5InnLYdBpz
    yOSUSSySsroQkGvF0c4yopGjErAAqjX7iQq9U/e8fs/vUxIAOzu
}
set imageData(save) {
    R0lGODdhHQAdAOMAAL6+vhyS/3GCkixNTQAAggAAAP/7z8+GPNO2jvffsgAAAAAAAAAAAAAA
    AAAAAAAAACwAAAAAHQAdAAAEfhDISau9OOvNu/9AIIrCOAQEGBKpMBEDq6KE+8YpSAtD3xcy
    HWtIDH5QAoNyaRDkjjXm0jkjGC6Gpwd1tWSr3coXxBKYzYeDM4VQVdKURNs9OcwBBzldkm+n
    9Xt5CX+AewgJiIh3dIKJi26Ejnt8jYWBjY9uRUZ0m1qToKGhEQA7
}
set imageData(stop) {
    R0lGODdhHQAdAMIAAL6+vgAAAC9PT/ffsv8AAAAAAAAAAAAAACwAAAAAHQAdAAADfQi63P4w
    ykmrreFiELoTgyAKVEecGQMObDhCwSmnS2uzNBMTYzD+t5aoEVsFhZ0jaVE8KkW2paLprAp1
    p58WqMTKCBljtBW4MnfgcFA8KId0HM9iC8WZpxF2yM6STvSAFmxubXcUdEE5FGs3ihOMURo3
    JFoalpeYmZqbnJoJAD
}
set imageData(up) {
    R0lGODdhHQAdAMIAAL6+vgAAAAAAgAAA/y6LVwAAAAAAAAAAACwAAAAAHQAdAAADaAi63P4w
    yukCvSoIi6UWW/d8YMmJAFmaqLqyGDkIwzzDU6Dv97zvLZrthMr0QsWFpkYjFgNHZ6tGlYqg
    1IG1g60mlVnt11jdxrK6capKMF+wAUJbDY3L3RSd/E7f88d2e3g5P2lqh4cJAD
}
set imageData(view) {
    R0lGODdhHQAdAMIAAL6+vgAAAP/6zXCAkAD//wAAgKBSLQAAACwAAAAAHQAdAAADqgi63P7Q
    hRDrC0JQy3HWHDSNHhgqwUAMbEuUG6cOSwaocLgqGSEouE9MRAP4fJ9bySSq/Ri/wbISewIH
    0eWQMbE2CsAlc4HBQAo0aSZHXtsaLaXms26vCYD3Qqqd1wEeEyxJSgYwfmNlJIsGgG50W46L
    JAONh2NQQiSAlY5CEWJ0Gp2BFqEwpF6gkI8plidigaONJyisdSmAtbJ/nJFUkA2/pr21EJjG
    EicJAD
}
set imageData(obj) {
    R0lGODdhHQAdAPcAAAAAAL6+vvXes/8AAP/6zbCwaRUVAggIQACgzPDyuBX/FQi/CLytGLhp
    8RUC/whAv2BQBNG6AAkVAEAIAN4gYHby0QL/CUC/QFAEAAEAsAAAFQAACDBgALnRsBUJFQhA
    CAAAFPCw8BUVFQgICEgA5vOwAP8VAL8IAIUUBKDwAAMVAC7mALkAsBUAFQgACFQEyDwA8QkA
    /wgAvwIABACwAAAVAAAIAG7QAADysAD/FQS/CKkE1KkA8QwA/0AAv0wArb2waRIVAkAIQKTc
    +IzyuBH/FaMEVIwA8REA/wwAv5gABEgEYLkA0RUACQgAQDAAALmwsGDwANHysAn/FUC/CGit
    FPNp8P8CFb9ACMjIADq4AAUVAANwAADyAAD/AAC/AAAEALgAABUAAAgAAExgPALRkQAJEQBA
    CGAA2NGw8gkV/0AIv4QAPPOwkf8VEb8ICNwUAETwAADmYOAA0QAEjLgA8RUA/0wAyAKwOgAV
    BQAIQGAgTNHzvQn/EgCttND8xvO48P8VEL8IQPegA/DyAAP/AAi/AGAEKEoA8gBgAgDRAAAJ
    AABAAEQAYPSw0f8VCQAAtJCwpRYVCUQUKPTw8v8V/78Iv5AAsBYAFQBgAADR8AAJFQC0wPSl
    uP8JFQA4YCfz0QP/CQi/QABE3pC6dhYVAgBgzADR8QAJ/wBAvx3eIAB2OwACBQBAQB1SAwAB
    AADIKAC68gAV/wAIvwDcAgHyAEggYPQ70f8FCb9AQEQD6PQA8f8A/78AvwA4PPTzRf//Bb+/
    QDwCACcA4AMAFQBgKJDR8hYJ/x34Ah08YABF0QAFCQDgAPAIQPbz8v///7+/vwDPBABsAAAC
    AAAQAADzsAC/CAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
    AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
    AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAHQAdAAAIrgADCBxIsKDBgwgTKkQIoKHD
    hxAjMhxAsSKAihgvWpyIcYDGjh89MoxIkiRDAihTAkjJcqXKkSVjNjzJkoDLmjdtGpTJcyZB
    AAKCCnWZU2XLn0KTCuj58CdQpQ1t1kSZEwDSiEuZ+hT4VOlSqVOrIvWaVatTr1GLUj06EChW
    rVsDdIUKFidbrmTLMh2LduFItFb97tTbcKngwWQDH26bV/FivFAf74QoubLlywQDAgA7
}
