/*
 * AdabasApi.h --
 *
 *      This module contains procedures, that implement the functionalty
 *      of the adasql procedures (adalogon, adaopen, adasql, adafetch, ...).
 *      Despite the fact, that all procedures return Tcl results, it
 *      could be used by other extensions (perl, python, ...), too.
 *
 * Copyright (c) 1996-1997 Christian Krone. All rights reserved.
 * This program is free software; you can redistribute it and/or
 * modify it under the same terms as Tcl itself.
 * See also licence.terms
 *
 *  $Id: AdabasApi.h,v 1.10 1997/06/28 17:18:18 adabas Exp $
 */

#ifndef _ADABAS_API
#define _ADABAS_API

/*
 * This include file could be used by other program systems, too (like
 * perl or python extension). In such cases AdabasSend.h isn't included yet.
  *So we have to define the logon handle structure as opaque data type here.
 */

#ifndef ADABAS_TCL_VERSION
typedef struct AdabasInfo *AdabasInfo;
#endif

/*
 * The parameter of AdabasLogon, which determines the kind of application.
 */

typedef enum {
  UserAppl,
  ControlAppl,
  OdbcAppl
} ApplKind;

/*
 * The data type for a cursorHandle. It should be used as opaque pointer
 * in client modules.
 */

typedef struct {
  AdabasInfo *logonInfo;
  int         cntParams;
  int         longColFound;
  int         massRows;
  int         rowIx;
  int4        dataLength;
  int4        dataEnd;
  char        resultTable[80]; /* more than enough. */
  field_info *shortInfos;
  char       *columnNames;

  /*
   * When we get a pointer to this structure via the API, we can't be sure,
   * that it points to an address, where a valid CursorInfo resides. For this
   * we wrote here a magic number and delete it, when closing the cursor.
   */

# define CURSOR_MAGIC 23+01+1962
  int  magic;

  /*
   * The Api call of AdabasLogoff doesn't know the name of the logonHandle.
   * So we have to store it here.
   */

  char cursorName[20];
} CursorInfo;

/*
 * Exported procedure headings.
 */

EXTERN void         AdabasApiInit _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN CursorInfo * AdabasCursorHandle _ANSI_ARGS_((Tcl_Interp *interp,
			char *cursorName));
EXTERN AdabasInfo * AdabasLogon _ANSI_ARGS_((Tcl_Interp *interp, char *serverdb,
			char *connectStr, int isolation, char *sqlMode,
			int serv, char *locale, int applKind));
EXTERN CursorInfo * AdabasOpen _ANSI_ARGS_((Tcl_Interp *interp, AdabasInfo *vars));
EXTERN int          AdabasSql _ANSI_ARGS_((Tcl_Interp *interp,
			 CursorInfo *cursorVars, int messType, int withParameter,
			 char *cmd, char *resultTable, char *sqlMode));
EXTERN int          AdabasExecParsId _ANSI_ARGS_((Tcl_Interp *interp,
			 CursorInfo *cursorVars, char *parsId));
EXTERN int          AdabasDropParsId _ANSI_ARGS_((Tcl_Interp *interp,
			 CursorInfo *cursorVars, char *parsId));
EXTERN int          AdabasFetch _ANSI_ARGS_((Tcl_Interp *interp,
			CursorInfo *cursorVars, char *target, int count,
			char *sqlMode, int arraySet));
EXTERN int          AdabasCancel _ANSI_ARGS_((Tcl_Interp *interp,
			CursorInfo *cursorVars));
EXTERN int          AdabasColumns _ANSI_ARGS_((Tcl_Interp *interp,
			CursorInfo *cursorVars));
EXTERN int          AdabasAutoCommit _ANSI_ARGS_((Tcl_Interp *interp,
			AdabasInfo *vars, int onOff));
EXTERN int          AdabasCommit _ANSI_ARGS_((Tcl_Interp *interp,
			AdabasInfo *vars));
EXTERN int          AdabasRollback _ANSI_ARGS_((Tcl_Interp *interp,
			AdabasInfo *vars));
EXTERN int          AdabasUtil _ANSI_ARGS_((Tcl_Interp *interp, AdabasInfo *vars,
			char *cmd));
EXTERN int          AdabasUsage _ANSI_ARGS_((Tcl_Interp *interp,
			AdabasInfo *vars, int usageKind, char *objectType,
			char *param1, char *param2, char *param3));
EXTERN int          AdabasSpecial _ANSI_ARGS_((Tcl_Interp *interp,
			AdabasInfo *vars, int messType, char *data));
EXTERN int          AdabasReadLong _ANSI_ARGS_((Tcl_Interp *interp,
			CursorInfo *cursorVars, Tcl_Obj *longDescr,
			char *tableName, char *columnName, char *whereCond,
			int encoding, char *fileName));
EXTERN int          AdabasWriteLong _ANSI_ARGS_((Tcl_Interp *interp,
			CursorInfo *cursorVars, char *tableName, char *columnName,
			char *whereCond, int encoding, char *fileName,
			char *longValue));
EXTERN int          AdabasClose _ANSI_ARGS_((Tcl_Interp *interp,
			CursorInfo *cursorVars));
EXTERN int          AdabasLogoff _ANSI_ARGS_((Tcl_Interp *interp,
			AdabasInfo *vars));
EXTERN char *       getDataOfCursor _ANSI_ARGS_((Tcl_Interp *interp,
			CursorInfo *cursorVars, int flags));
EXTERN void         AdabasTrace _ANSI_ARGS_((char *kind, char *cursorName,
			char *dir));

#endif /* _ADABAS_API */

