/*
 * AdabasFormat.h --
 *
 *      Functions to transform a value in the internal format of Adabas D
 *      into a c string, integer, float or the like and vice versa.
 *
 * Copyright (c) 1996-1997 Christian Krone. All rights reserved.
 * This program is free software; you can redistribute it and/or
 * modify it under the same terms as Tcl itself.
 * See also licence.terms
 *
 * $Id: AdabasFormat.h,v 1.19 1997/05/31 14:19:31 adabas Exp $
 */

#ifndef _ADABAS_FORMAT
#define _ADABAS_FORMAT

/*
 * The records, which represents long descriptors, have the following structure.
 * They are a Tcl_ObjType of there own...
 */

typedef struct {
  long_descriptor longDesc;
  char            longDescName[100];
  AdabasInfo     *logon;
  CursorInfo     *cursor;
  char            dataType;
#define LONG_MAGIC 24+12+1997
  int             longMagic;
} LongDescInfo;


/*
 * Exported procedure headings.
 */

EXTERN void AdabasFormatInit _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN int  AdabasCryptCmd _ANSI_ARGS_((ClientData clientData,
		Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]));
EXTERN int  AdabasPutCmd _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
		int objc, Tcl_Obj *CONST objv[]));
EXTERN int  AdabasGetCmd _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
		int objc, Tcl_Obj *CONST objv[]));
EXTERN int  AdabasAppendData _ANSI_ARGS_((Tcl_Interp *interp, AdabasInfo *vars,
		CursorInfo *cursorVars, char *data, Tcl_Obj *destObj,
		int dataType, int ioLen, int len, int frac, char *nullValue,
		char *specialNull, int isElement));
EXTERN void AdabasPasswdCrypt _ANSI_ARGS_((Tcl_Interp *interp,
		Tcl_DString *cryptPw, char *passwd));
EXTERN int  AdabasGetLongDescFromObj _ANSI_ARGS_((Tcl_Interp *interp,
		Tcl_Obj *longDescObj, LongDescInfo **outLongInfo));
EXTERN void AdabasDeleteLongDescr _ANSI_ARGS_((AdabasInfo *ofThisLogon,
		CursorInfo *exceptForThisCursor));

#define AdabasDeleteAllLongDescrOf(thisLogon) \
  AdabasDeleteLongDescr ((thisLogon), (CursorInfo *) NULL)

#endif /* _ADABAS_FORMAT */


