/*
 * AdabasLong.c --
 *
 *      This module contains procedures, that implement the long column
 *      handling in AdabasTcl.
 *
 * Copyright (c) 1996-1997 Christian Krone. All rights reserved.
 * This program is free software; you can redistribute it and/or
 * modify it under the same terms as Tcl itself.
 * See also licence.terms
 *
 *  $Id: AdabasLong.h,v 1.11 1997/03/13 20:47:46 adabas Exp $
 */

#ifndef _ADABAS_LONG
#define _ADABAS_LONG

/*
 * Declarations of all the procedures of AdabasLong.c
 */

EXTERN int AdabasLongSelect _ANSI_ARGS_((Tcl_Interp *interp,
               CursorInfo *cursorVars, char *tableName, char *columnName,
	       char *whereCond, long_descriptor *longDesc));
EXTERN int AdabasLongReadFirst _ANSI_ARGS_((Tcl_Interp *interp,
	       CursorInfo *cursorVars, long_descriptor *longDesc, int dataType,
	       int encoding, char *fileName, long *bytes, int *cont));
EXTERN int AdabasLongReadNext _ANSI_ARGS_((Tcl_Interp *interp,
	       CursorInfo *cursorVars, long_descriptor *longDesc, int dataType,
	       int encoding, char *fileName, long *bytes, int *cont));
EXTERN int AdabasLongUpdate _ANSI_ARGS_((Tcl_Interp *interp,
	       CursorInfo *cursorVars, char *tableName, char *columnName,
	       char *whereCond, Tcl_DString *parsId));
EXTERN int AdabasLongWriteFirst _ANSI_ARGS_((Tcl_Interp *interp,
	       CursorInfo *cursorVars, long_descriptor *longDesc,
	       Tcl_DString *parsId, char *fileName, char *longValue,
	       int encoding, int length, int4 *bytes, int *cont));
EXTERN int AdabasLongWriteNext _ANSI_ARGS_((Tcl_Interp *interp,
	       CursorInfo *cursorVars, long_descriptor *longDesc,
	       char *fileName, char *longValue, int encoding, int length,
	       int4 *bytes, int *cont));
EXTERN int AdabasLongToFile _ANSI_ARGS_((Tcl_Interp *interp, int toFile,
	       char *fileName, int length, char *data));
EXTERN int AdabasLongValLength _ANSI_ARGS_((Tcl_Interp  *interp,
	       char *fileName, char *longValue, int encoding,
	       Tcl_DString *substVal, int4 *length));

#endif /* _ADABAS_LONG */
