/* -------------------------------------------------------------- */
/*  $Id: AdabasPacket.h,v 1.28 1997/01/03 22:21:31 adabas Exp $ */
/* -------------------------------------------------------------- */
/* Copyright (c) 1996 Christian Krone. All rights reserved.       */
/* This program is free software; you can redistribute it and/or  */
/* modify it under the same terms as Tcl itself.                  */
/* See also licence.terms                                         */
/* -------------------------------------------------------------- */

/* ----------------- Constant definitions------------------------ */
/*
 * Flag parameter of getData.
 */
#define FOR_LONG_OP 1
#define MASS_CMD    2
#define UTILITY_CMD 4

/* ----------------- Type definitions --------------------------- */
typedef struct {
  char application[3];
  int  messType;
  int  withInfo;
#if ADABAS_VERSION >= 62
  int  producer;
#endif
  int  sqlMode;
  int  massCmd;
  int  commitImmediately;
  int  swapKind;
} AdabasPacketInfo;

/* ----------------- Exported procedure headings ---------------- */

EXTERN void AdabasPacketInit _ANSI_ARGS_((AdabasPacketInfo *vars));

EXTERN int scanMessType _ANSI_ARGS_((Tcl_Interp *interp, char *arg));
EXTERN int scanDataType _ANSI_ARGS_((Tcl_Interp *interp, char *arg));
#if ADABAS_VERSION >= 62
EXTERN int scanProducer _ANSI_ARGS_((Tcl_Interp *interp, char *arg));
#endif
EXTERN int scanSqlMode _ANSI_ARGS_((Tcl_Interp *interp, char *arg,
				    int EXTERNal));
EXTERN char *scanApplication _ANSI_ARGS_((Tcl_Interp *interp, char *arg));
EXTERN service scanService _ANSI_ARGS_((Tcl_Interp *interp, char *arg));
EXTERN char *dataType2String _ANSI_ARGS_((int data_type));
EXTERN char *messType2String _ANSI_ARGS_((int messType));
#if ADABAS_VERSION >= 62
EXTERN char *producer2String _ANSI_ARGS_((int producer));
#endif
EXTERN char *sqlMode2String _ANSI_ARGS_((int sqlMode, int EXTERNal));
EXTERN char *application2String _ANSI_ARGS_((char *application));
EXTERN char *service2String _ANSI_ARGS_((int serv));
EXTERN int datatypeIsLong _ANSI_ARGS_((int dataType));

#if ADABAS_VERSION >= 62
EXTERN int getResultCount _ANSI_ARGS_((segment *retSegment));
EXTERN void putResultPart _ANSI_ARGS_((Tcl_Interp *interp, part *ret_part,
				       int4 *part_length));
EXTERN int getShortInfos _ANSI_ARGS_((segment *retSegment,
				      field_info **shortInfos,
				      char **columnNames));
EXTERN int getResultTable _ANSI_ARGS_((segment *retSegment,
				       char *resultTable));
EXTERN int getParsId _ANSI_ARGS_((Tcl_Interp *interp, segment *retSegment,
				  Tcl_DString *parsIdDString));
EXTERN char *getData _ANSI_ARGS_((segment *retSegment, int4 *dataLength,
				  int *argCount, int flags));
EXTERN char *getLongdesc _ANSI_ARGS_((segment *retSegment));

#else /* ADABAS_VERSION <= 61 */
EXTERN int  getResultCount _ANSI_ARGS_((packet *retSegment));
EXTERN void putResultPart _ANSI_ARGS_((Tcl_Interp *interp, int partNo,
				       int2 *currPos, packet *retSegment,
				       int sndMessType));
EXTERN int getShortInfos _ANSI_ARGS_((packet *retSegment,
				      field_info **shortInfos,
				      char **columnNames));
EXTERN int getResultTable _ANSI_ARGS_((packet *retSegment, int messType,
				       char *resultTable));
EXTERN int getParsId _ANSI_ARGS_((Tcl_Interp *interp, packet *retSegment,
				  Tcl_DString *parsIdDString));
EXTERN char *getData _ANSI_ARGS_((packet *retSegment, int4 *dataLength,
				  int *argCount, int flags));
EXTERN char *getLongdesc _ANSI_ARGS_((packet *retSegment, int withArgCount));
#endif
